/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.swing.event.EventListenerList;
import org.jfugue.JFugueElement;
import org.jfugue.MidiParser;
import org.jfugue.MusicStringRenderer;
import org.jfugue.PatternListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pattern
implements Serializable {
    private StringBuilder musicString;
    private Map<String, String> properties;
    protected EventListenerList listenerList = new EventListenerList();
    public static final String TITLE = "Title";

    public Pattern() {
        this("");
    }

    public Pattern(String musicString) {
        this.setMusicString(musicString);
        this.properties = new HashMap<String, String>();
    }

    public Pattern(Pattern pattern) {
        this(new String(pattern.getMusicString()));
        for (String key : pattern.getProperties().keySet()) {
            String value = pattern.getProperty(key);
            this.setProperty(key, value);
        }
    }

    public Pattern(Pattern ... patterns) {
        this();
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            this.add(p);
            ++n2;
        }
    }

    static Pattern loadMidi(File file) throws IOException, InvalidMidiDataException {
        MidiParser parser = new MidiParser();
        MusicStringRenderer renderer = new MusicStringRenderer();
        parser.addParserListener(renderer);
        parser.parse(MidiSystem.getSequence(file));
        Pattern pattern = new Pattern(renderer.getPattern().getMusicString());
        return pattern;
    }

    public void setMusicString(String musicString) {
        this.musicString = new StringBuilder();
        this.musicString.append(musicString);
    }

    private void appendMusicString(String appendString) {
        this.musicString.append(appendString);
    }

    public String getMusicString() {
        return this.musicString.toString();
    }

    public void insert(String musicString) {
        this.musicString.insert(0, " ");
        this.musicString.insert(0, musicString);
    }

    public void add(Pattern pattern) {
        this.fireFragmentAdded(pattern);
        this.appendMusicString(" ");
        this.appendMusicString(pattern.getMusicString());
    }

    public void add(String musicString) {
        this.add(new Pattern(musicString));
    }

    public void add(Pattern pattern, int numTimes) {
        int i = 0;
        while (i < numTimes) {
            this.fireFragmentAdded(pattern);
            this.appendMusicString(" ");
            this.appendMusicString(pattern.getMusicString());
            ++i;
        }
    }

    public void add(String musicString, int numTimes) {
        this.add(new Pattern(musicString), numTimes);
    }

    public void add(Pattern ... patterns) {
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            this.add(pattern);
            ++n2;
        }
    }

    public void add(String ... musicStrings) {
        String[] stringArray = musicStrings;
        int n = musicStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.add(string);
            ++n2;
        }
    }

    public void addElement(JFugueElement element) {
        String elementMusicString = element.getMusicString();
        if (elementMusicString.charAt(0) == '+' || elementMusicString.charAt(0) == '_') {
            this.appendMusicString(elementMusicString);
        } else {
            this.appendMusicString(" ");
            this.appendMusicString(elementMusicString);
            this.fireFragmentAdded(new Pattern(elementMusicString));
        }
    }

    public void setTitle(String title) {
        this.setProperty(TITLE, title);
    }

    public String getTitle() {
        return this.getProperty(TITLE);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void repeat(int times) {
        this.repeat(null, this.getMusicString(), times, null);
    }

    public void repeat(int times, int beginIndex) {
        String string = this.getMusicString();
        this.repeat(string.substring(0, beginIndex), string.substring(beginIndex), times, null);
    }

    public void repeat(int times, int beginIndex, int endIndex) {
        String string = this.getMusicString();
        this.repeat(string.substring(0, beginIndex), string.substring(beginIndex, endIndex), times, string.substring(endIndex));
    }

    private void repeat(String header, String repeater, int times, String trailer) {
        StringBuffer buffy = new StringBuffer();
        if (header != null) {
            buffy.append(header);
        }
        int i = 0;
        while (i < times) {
            buffy.append(repeater);
            if (i < times - 1) {
                buffy.append(" ");
            }
            ++i;
        }
        if (trailer != null) {
            buffy.append(trailer);
        }
        this.setMusicString(buffy.toString());
    }

    public Pattern subPattern(int beginIndex) {
        return new Pattern(this.substring(beginIndex));
    }

    public Pattern subPattern(int beginIndex, int endIndex) {
        return new Pattern(this.substring(beginIndex, endIndex));
    }

    protected String substring(int beginIndex) {
        return this.getMusicString().substring(beginIndex);
    }

    protected String substring(int beginIndex, int endIndex) {
        return this.getMusicString().substring(beginIndex, endIndex);
    }

    public static Pattern loadPattern(File file) throws IOException {
        StringBuffer buffy = new StringBuffer();
        Pattern pattern = new Pattern();
        BufferedReader bread = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while (bread.ready()) {
            String s = bread.readLine();
            if (s == null || s.length() <= 1) continue;
            if (s.charAt(0) != '#') {
                buffy.append(" ");
                buffy.append(s);
                continue;
            }
            String key = s.substring(1, s.indexOf(58)).trim();
            String value = s.substring(s.indexOf(58) + 1, s.length()).trim();
            if (key.equalsIgnoreCase(TITLE)) {
                pattern.setTitle(value);
                continue;
            }
            pattern.setProperty(key, value);
        }
        bread.close();
        pattern.setMusicString(buffy.toString());
        return pattern;
    }

    public void savePattern(File file) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        if (this.getProperties().size() > 0 || this.getTitle() != null) {
            out.write("#\n");
            if (this.getTitle() != null) {
                out.write("# ");
                out.write("Title: ");
                out.write(this.getTitle());
                out.write("\n");
            }
            for (String key : this.getProperties().keySet()) {
                if (key.equals(TITLE)) continue;
                String value = this.getProperty(key);
                out.write("# ");
                out.write(key);
                out.write(": ");
                out.write(value);
                out.write("\n");
            }
            out.write("#\n");
            out.write("\n");
        }
        String musicString = this.getMusicString();
        while (musicString.length() > 0) {
            if (musicString.length() > 80 && musicString.indexOf(32, 80) > -1) {
                int indexOf80ColumnSpace = musicString.indexOf(32, 80);
                out.write(musicString.substring(0, indexOf80ColumnSpace));
                out.newLine();
                musicString = musicString.substring(indexOf80ColumnSpace, musicString.length());
                continue;
            }
            out.write(musicString);
            musicString = "";
        }
        out.close();
    }

    public String getPropertiesAsSentence() {
        StringBuilder buddy = new StringBuilder();
        for (String key : this.getProperties().keySet()) {
            String value = this.getProperty(key);
            buddy.append(key);
            buddy.append(": ");
            buddy.append(value);
            buddy.append("; ");
        }
        String result = buddy.toString();
        return result.substring(0, result.length() - 2);
    }

    public String getPropertiesAsParagraph() {
        StringBuilder buddy = new StringBuilder();
        for (String key : this.getProperties().keySet()) {
            String value = this.getProperty(key);
            buddy.append(key);
            buddy.append(": ");
            buddy.append(value);
            buddy.append("\n");
        }
        String result = buddy.toString();
        return result.substring(0, result.length());
    }

    public void offset(long offsetTime) {
        StringBuffer buffy = new StringBuffer();
        String[] tokens = this.getMusicString().split(" ");
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].length() > 0 && tokens[i].charAt(0) == '@') {
                String timeNumberString = tokens[i].substring(1, tokens[i].length());
                if (timeNumberString.indexOf("[") == -1) {
                    long timeNumber = new Long(timeNumberString);
                    long newTime = timeNumber + offsetTime;
                    if (newTime < 0L) {
                        newTime = 0L;
                    }
                    buffy.append("@" + newTime);
                } else {
                    buffy.append(tokens[i]);
                }
            } else {
                buffy.append(tokens[i]);
            }
            buffy.append(" ");
            ++i;
        }
        this.setMusicString(buffy.toString());
    }

    public String[] getTokens() {
        StringTokenizer strtok = new StringTokenizer(this.musicString.toString(), " \n\t");
        ArrayList<String> list = new ArrayList<String>();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            if (token == null) continue;
            list.add(token);
        }
        String[] retVal = new String[list.size()];
        list.toArray(retVal);
        return retVal;
    }

    public void addPatternListener(PatternListener l) {
        this.listenerList.add(PatternListener.class, l);
    }

    public void removePatternListener(PatternListener l) {
        this.listenerList.remove(PatternListener.class, l);
    }

    protected void clearPatternListeners() {
        EventListener[] l = this.listenerList.getListeners(PatternListener.class);
        int numListeners = l.length;
        int i = 0;
        while (i < numListeners) {
            this.listenerList.remove(PatternListener.class, (PatternListener)l[i]);
            ++i;
        }
    }

    private void fireFragmentAdded(Pattern fragment) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == PatternListener.class) {
                ((PatternListener)listeners[i + 1]).fragmentAdded(fragment);
            }
            i -= 2;
        }
    }

    public String toString() {
        return this.getMusicString();
    }
}

