/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import org.jfugue.JFugueElement;

public final class KeySignature
implements JFugueElement {
    private byte keySig;
    private byte scale;
    private static final String[] majorSigs = new String[]{"Cb", "Gb", "Db", "Ab", "Eb", "Bb", "F", "C", "G", "D", "A", "E", "B", "F#", "C#"};
    private static final String[] minorSigs = new String[]{"Ab", "Eb", "Bb", "F", "C", "G", "D", "A", "E", "B", "F#", "C#", "G#", "D#", "A#"};

    public KeySignature(byte keySig, byte scale) {
        this.setKeySig(keySig);
        this.setScale(scale);
    }

    public void setKeySig(byte keySig) {
        this.keySig = keySig;
    }

    public void setScale(byte scale) {
        this.scale = scale;
    }

    public byte getKeySig() {
        return this.keySig;
    }

    public byte getScale() {
        return this.scale;
    }

    public String getMusicString() {
        StringBuilder keySigSB = new StringBuilder();
        keySigSB.append("K");
        if (this.scale == 0) {
            keySigSB.append(majorSigs[this.getKeySig() + 7]);
            keySigSB.append("maj");
        } else {
            keySigSB.append(minorSigs[this.getKeySig() + 7]);
            keySigSB.append("min");
        }
        return keySigSB.toString();
    }

    public String getVerifyString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("KeySig: keySig=");
        buffy.append(this.getKeySig());
        buffy.append(", scale=");
        buffy.append(this.getScale());
        return buffy.toString();
    }
}

