/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import org.jfugue.JFugueException;

public final class IntelligentDeviceResolver {
    public static MidiDevice selectReceiverDevice() throws MidiUnavailableException {
        return IntelligentDeviceResolver.selectDevice("midi", "usb", "out");
    }

    public static MidiDevice selectTransmitterDevice() throws MidiUnavailableException {
        return IntelligentDeviceResolver.selectDevice("midi", "usb", "in");
    }

    public static MidiDevice selectDevice(String ... keywords) throws MidiUnavailableException {
        int bestMatch = 0;
        int thisMatch = 0;
        MidiDevice device = null;
        MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < info.length) {
            String infoString = info[i].toString().toLowerCase();
            thisMatch = 0;
            int k = 0;
            while (k < keywords.length) {
                if (infoString.contains(keywords[k])) {
                    ++thisMatch;
                }
                ++k;
            }
            if (thisMatch > bestMatch) {
                device = MidiSystem.getMidiDevice(info[i]);
                bestMatch = thisMatch;
            }
            ++i;
        }
        if (device == null) {
            throw new JFugueException("IntelligentDeviceResolver not intelligent enough.  Be explicit about the MidiDevice.");
        }
        return device;
    }
}

