/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;
import org.jfugue.IntelligentDeviceResolver;
import org.jfugue.MidiParser;
import org.jfugue.MusicStringRenderer;
import org.jfugue.Parser;
import org.jfugue.ParserListener;
import org.jfugue.Pattern;

public class DeviceThatWillTransmitMidi {
    private MidiDevice device;
    private Transmitter transmitter;
    private MidiReceiverForTransmitterDevice mrftd;

    public DeviceThatWillTransmitMidi() throws MidiUnavailableException {
        this.device = IntelligentDeviceResolver.selectTransmitterDevice();
        this.init();
    }

    public DeviceThatWillTransmitMidi(MidiDevice.Info info) throws MidiUnavailableException {
        this.device = MidiSystem.getMidiDevice(info);
        this.init();
    }

    private void init() throws MidiUnavailableException {
        try {
            if (!this.device.isOpen()) {
                this.device.open();
            }
            this.transmitter = this.device.getTransmitter();
            this.mrftd = new MidiReceiverForTransmitterDevice();
        }
        catch (MidiUnavailableException e) {
            this.device.close();
            throw e;
        }
    }

    public Transmitter getTransmitter() {
        return this.transmitter;
    }

    public void addParserListener(ParserListener listener) {
        this.mrftd.getParser().addParserListener(listener);
    }

    public void removeParserListener(ParserListener listener) {
        this.mrftd.getParser().removeParserListener(listener);
    }

    public void startListening() {
        this.transmitter.setReceiver(this.mrftd);
    }

    public void stopListening() {
        this.device.close();
    }

    public void listenForMillis(long millis) throws InterruptedException {
        this.startListening();
        Thread.sleep(millis);
        this.stopListening();
    }

    public Pattern getPatternFromListening() {
        return this.mrftd.getPattern();
    }

    public Sequence getSequenceFromListening() {
        return this.mrftd.getSequence();
    }

    public void close() {
        this.transmitter.close();
        this.device.close();
    }

    class MidiReceiverForTransmitterDevice
    implements Receiver {
        private MidiParser parser;
        private Sequencer sequencer;
        private Receiver sequencerReceiver;
        private MusicStringRenderer renderer;

        public MidiReceiverForTransmitterDevice() {
            System.out.println("Built mrftd");
            this.parser = new MidiParser();
            this.renderer = new MusicStringRenderer();
            this.parser.addParserListener(this.renderer);
            try {
                this.sequencer = MidiSystem.getSequencer();
                this.sequencerReceiver = this.sequencer.getReceiver();
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }

        public Parser getParser() {
            return this.parser;
        }

        public void send(MidiMessage message, long timestamp) {
            System.out.println("Parsing " + message + " ts: " + timestamp);
            this.parser.parse(message, timestamp / 4000L);
            this.sequencerReceiver.send(message, timestamp);
        }

        public void close() {
            this.sequencerReceiver.close();
        }

        public Pattern getPattern() {
            return this.renderer.getPattern();
        }

        public Sequence getSequence() {
            return this.sequencer.getSequence();
        }
    }
}

