/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkSBIT
extends PngChunkSingle {
    public static final String ID = "sBIT";
    private int graysb;
    private int alphasb;
    private int redsb;
    private int greensb;
    private int bluesb;

    public PngChunkSBIT(ImageInfo info) {
        super(ID, info);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    private int getCLen() {
        int len;
        int n = len = this.imgInfo.greyscale ? 1 : 3;
        if (this.imgInfo.alpha) {
            ++len;
        }
        return len;
    }

    public void parseFromRaw(ChunkRaw c) {
        if (c.len != this.getCLen()) {
            throw new PngjException("bad chunk length " + c);
        }
        if (this.imgInfo.greyscale) {
            this.graysb = PngHelperInternal.readInt1fromByte(c.data, 0);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelperInternal.readInt1fromByte(c.data, 1);
            }
        } else {
            this.redsb = PngHelperInternal.readInt1fromByte(c.data, 0);
            this.greensb = PngHelperInternal.readInt1fromByte(c.data, 1);
            this.bluesb = PngHelperInternal.readInt1fromByte(c.data, 2);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelperInternal.readInt1fromByte(c.data, 3);
            }
        }
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw c = null;
        c = this.createEmptyChunk(this.getCLen(), true);
        if (this.imgInfo.greyscale) {
            c.data[0] = (byte)this.graysb;
            if (this.imgInfo.alpha) {
                c.data[1] = (byte)this.alphasb;
            }
        } else {
            c.data[0] = (byte)this.redsb;
            c.data[1] = (byte)this.greensb;
            c.data[2] = (byte)this.bluesb;
            if (this.imgInfo.alpha) {
                c.data[3] = (byte)this.alphasb;
            }
        }
        return c;
    }

    public void setGraysb(int gray) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only greyscale images support this");
        }
        this.graysb = gray;
    }

    public int getGraysb() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only greyscale images support this");
        }
        return this.graysb;
    }

    public void setAlphasb(int a) {
        if (!this.imgInfo.alpha) {
            throw new PngjException("only images with alpha support this");
        }
        this.alphasb = a;
    }

    public int getAlphasb() {
        if (!this.imgInfo.alpha) {
            throw new PngjException("only images with alpha support this");
        }
        return this.alphasb;
    }

    public void setRGB(int r, int g, int b) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.redsb = r;
        this.greensb = g;
        this.bluesb = b;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.redsb, this.greensb, this.bluesb};
    }
}

