/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class DarculaSpinnerUI
extends BasicSpinnerUI {
    private FocusAdapter myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            DarculaSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DarculaSpinnerUI.this.spinner.repaint();
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarculaSpinnerUI();
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        super.replaceEditor(oldEditor, newEditor);
        if (oldEditor != null) {
            oldEditor.getComponents()[0].removeFocusListener(this.myFocusListener);
        }
        if (newEditor != null) {
            newEditor.getComponents()[0].addFocusListener(this.myFocusListener);
        }
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = super.createEditor();
        editor.getComponents()[0].addFocusListener(this.myFocusListener);
        return editor;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Border border = this.spinner.getBorder();
        if (border != null) {
            border.paintBorder(c, g, 0, 0, this.spinner.getWidth(), this.spinner.getHeight());
        }
    }

    @Override
    protected Component createPreviousButton() {
        JButton button = this.createArrow(5);
        button.setName("Spinner.previousButton");
        button.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.installPreviousButtonListeners(button);
        return button;
    }

    @Override
    protected Component createNextButton() {
        JButton button = this.createArrow(1);
        button.setName("Spinner.nextButton");
        button.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.installNextButtonListeners(button);
        return button;
    }

    @Override
    protected LayoutManager createLayout() {
        return new LayoutManagerDelegate(super.createLayout()){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                JComponent editor = DarculaSpinnerUI.this.spinner.getEditor();
                if (editor != null) {
                    Rectangle bounds = editor.getBounds();
                    editor.setBounds(bounds.x, bounds.y, bounds.width - 6, bounds.height);
                }
            }
        };
    }

    private JButton createArrow(int direction) {
        Color shadow = UIUtil.getPanelBackground();
        DoubleColor enabledColor = new DoubleColor((Color)Gray._255, UIUtil.getLabelForeground());
        DoubleColor disabledColor = new DoubleColor((Color)Gray._200, UIUtil.getLabelForeground().darker());
        BasicArrowButton b = new BasicArrowButton(direction, shadow, shadow, (Color)enabledColor, shadow, (Color)enabledColor, (Color)disabledColor){
            private final /* synthetic */ Color val$enabledColor;
            private final /* synthetic */ Color val$disabledColor;
            {
                this.val$enabledColor = color;
                this.val$disabledColor = color2;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
            }

            @Override
            public void paint(Graphics g) {
                int y = this.direction == 1 ? this.getHeight() - 6 : 2;
                this.paintTriangle(g, (this.getWidth() - 8) / 2 - 1, y, 0, this.direction, DarculaSpinnerUI.this.spinner.isEnabled());
            }

            @Override
            public boolean isOpaque() {
                return false;
            }

            @Override
            public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                int w = 8;
                int h = 6;
                int mid = 4;
                g.setColor(isEnabled ? this.val$enabledColor : this.val$disabledColor);
                g.translate(x, y);
                switch (direction) {
                    case 5: {
                        int[] nArray = new int[3];
                        nArray[1] = 8;
                        nArray[2] = mid;
                        g.fillPolygon(nArray, new int[]{1, 1, 6}, 3);
                        break;
                    }
                    case 1: {
                        int[] nArray = new int[3];
                        nArray[1] = 8;
                        nArray[2] = mid;
                        int[] nArray2 = new int[3];
                        nArray2[0] = 5;
                        nArray2[1] = 5;
                        g.fillPolygon(nArray, nArray2, 3);
                    }
                }
                g.translate(-x, -y);
                config.restore();
            }
        };
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof UIResource) {
            b.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            b.setBorder(buttonBorder);
        }
        b.setInheritsPopupMenu(true);
        return b;
    }

    static class LayoutManagerDelegate
    implements LayoutManager {
        protected final LayoutManager myDelegate;

        LayoutManagerDelegate(LayoutManager delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.myDelegate.addLayoutComponent(name, comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.myDelegate.removeLayoutComponent(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.myDelegate.preferredLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.myDelegate.minimumLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            this.myDelegate.layoutContainer(parent);
        }
    }
}

