/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.util.pipe.AbstractSchemaValidationTube;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceException;
import org.xml.sax.SAXException;

public class ServerSchemaValidationTube
extends AbstractSchemaValidationTube {
    private static final Logger LOGGER = Logger.getLogger(ServerSchemaValidationTube.class.getName());
    private final Schema schema;
    private final Validator validator;
    private final boolean noValidation;
    private final SEIModel seiModel;
    private final WSDLPort wsdlPort;

    public ServerSchemaValidationTube(WSEndpoint wSEndpoint, WSBinding wSBinding, SEIModel sEIModel, WSDLPort wSDLPort, Tube tube) {
        super(wSBinding, tube);
        this.seiModel = sEIModel;
        this.wsdlPort = wSDLPort;
        if (wSEndpoint.getServiceDefinition() != null) {
            Source[] sourceArray;
            AbstractSchemaValidationTube.MetadataResolverImpl metadataResolverImpl = new AbstractSchemaValidationTube.MetadataResolverImpl(this, wSEndpoint.getServiceDefinition());
            for (Source source : sourceArray = this.getSchemaSources(wSEndpoint.getServiceDefinition(), metadataResolverImpl)) {
                LOGGER.fine("Constructing service validation schema from = " + source.getSystemId());
            }
            if (sourceArray.length != 0) {
                this.noValidation = false;
                this.sf.setResourceResolver(metadataResolverImpl);
                try {
                    this.schema = this.sf.newSchema(sourceArray);
                }
                catch (SAXException sAXException) {
                    throw new WebServiceException(sAXException);
                }
                this.validator = this.schema.newValidator();
                return;
            }
        }
        this.noValidation = true;
        this.schema = null;
        this.validator = null;
    }

    @Override
    protected Validator getValidator() {
        return this.validator;
    }

    @Override
    protected boolean isNoValidation() {
        return this.noValidation;
    }

    @Override
    public NextAction processRequest(Packet packet) {
        if (this.isNoValidation() || !this.feature.isInbound() || !packet.getMessage().hasPayload() || packet.getMessage().isFault()) {
            return super.processRequest(packet);
        }
        try {
            this.doProcess(packet);
        }
        catch (SAXException sAXException) {
            LOGGER.log(Level.WARNING, "Client Request doesn't pass Service's Schema Validation", sAXException);
            SOAPVersion sOAPVersion = this.binding.getSOAPVersion();
            Message message = SOAPFaultBuilder.createSOAPFaultMessage(sOAPVersion, null, sAXException, sOAPVersion.faultCodeClient);
            return this.doReturnWith(packet.createServerResponse(message, this.wsdlPort, this.seiModel, this.binding));
        }
        return super.processRequest(packet);
    }

    @Override
    public NextAction processResponse(Packet packet) {
        if (this.isNoValidation() || !this.feature.isOutbound() || packet.getMessage() == null || !packet.getMessage().hasPayload() || packet.getMessage().isFault()) {
            return super.processResponse(packet);
        }
        try {
            this.doProcess(packet);
        }
        catch (SAXException sAXException) {
            throw new WebServiceException(sAXException);
        }
        return super.processResponse(packet);
    }

    protected ServerSchemaValidationTube(ServerSchemaValidationTube serverSchemaValidationTube, TubeCloner tubeCloner) {
        super(serverSchemaValidationTube, tubeCloner);
        this.schema = serverSchemaValidationTube.schema;
        this.validator = this.schema.newValidator();
        this.noValidation = serverSchemaValidationTube.noValidation;
        this.seiModel = serverSchemaValidationTube.seiModel;
        this.wsdlPort = serverSchemaValidationTube.wsdlPort;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new ServerSchemaValidationTube(this, tubeCloner);
    }
}

