/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.protocol.soap;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.message.DOMHeader;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;

abstract class MUTube
extends AbstractFilterTubeImpl {
    private static final String MU_FAULT_DETAIL_LOCALPART = "NotUnderstood";
    private static final QName MU_HEADER_DETAIL = new QName(SOAPVersion.SOAP_12.nsUri, "NotUnderstood");
    protected static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.soap.decoder");
    private static final String MUST_UNDERSTAND_FAULT_MESSAGE_STRING = "One or more mandatory SOAP header blocks not understood";
    protected final SOAPVersion soapVersion;
    protected SOAPBindingImpl binding;

    protected MUTube(WSBinding wSBinding, Tube tube) {
        super(tube);
        if (!(wSBinding instanceof SOAPBinding)) {
            throw new WebServiceException("MUPipe should n't be used for bindings other than SOAP.");
        }
        this.binding = (SOAPBindingImpl)wSBinding;
        this.soapVersion = wSBinding.getSOAPVersion();
    }

    protected MUTube(MUTube mUTube, TubeCloner tubeCloner) {
        super(mUTube, tubeCloner);
        this.binding = mUTube.binding;
        this.soapVersion = mUTube.soapVersion;
    }

    public final Set<QName> getMisUnderstoodHeaders(MessageHeaders messageHeaders, Set<String> set, Set<QName> set2) {
        return messageHeaders.getNotUnderstoodHeaders(set, set2, this.binding);
    }

    final SOAPFaultException createMUSOAPFaultException(Set<QName> set) {
        try {
            SOAPFault sOAPFault = this.soapVersion.getSOAPFactory().createFault(MUST_UNDERSTAND_FAULT_MESSAGE_STRING, this.soapVersion.faultCodeMustUnderstand);
            sOAPFault.setFaultString("MustUnderstand headers:" + set + " are not understood");
            return new SOAPFaultException(sOAPFault);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    final Message createMUSOAPFaultMessage(Set<QName> set) {
        try {
            String string = MUST_UNDERSTAND_FAULT_MESSAGE_STRING;
            if (this.soapVersion == SOAPVersion.SOAP_11) {
                string = "MustUnderstand headers:" + set + " are not understood";
            }
            Message message = SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, string, this.soapVersion.faultCodeMustUnderstand);
            if (this.soapVersion == SOAPVersion.SOAP_12) {
                MUTube.addHeader(message, set);
            }
            return message;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    private static void addHeader(Message message, Set<QName> set) throws SOAPException {
        for (QName qName : set) {
            SOAPElement sOAPElement = SOAPVersion.SOAP_12.getSOAPFactory().createElement(MU_HEADER_DETAIL);
            sOAPElement.addNamespaceDeclaration("abc", qName.getNamespaceURI());
            sOAPElement.setAttribute("qname", "abc:" + qName.getLocalPart());
            DOMHeader<SOAPElement> dOMHeader = new DOMHeader<SOAPElement>(sOAPElement);
            message.getHeaders().add(dOMHeader);
        }
    }
}

