/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.util.SAXMessageFormatter;
import java.util.Locale;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class DefaultValidationErrorHandler
extends DefaultHandler {
    private static int ERROR_COUNT_LIMIT = 10;
    private int errorCount = 0;
    private Locale locale = Locale.getDefault();

    public DefaultValidationErrorHandler(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        String string;
        if (this.errorCount >= ERROR_COUNT_LIMIT) {
            return;
        }
        if (this.errorCount == 0) {
            System.err.println(SAXMessageFormatter.formatMessage(this.locale, "errorHandlerNotSet", new Object[]{this.errorCount}));
        }
        if ((string = sAXParseException.getSystemId()) == null) {
            string = "null";
        }
        String string2 = "Error: URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
        System.err.println(string2);
        ++this.errorCount;
    }
}

