/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.events;

import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.media_duration_changed;
import uk.co.caprica.vlcj.binding.internal.media_meta_changed;
import uk.co.caprica.vlcj.binding.internal.media_parsed_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_audio_device;
import uk.co.caprica.vlcj.binding.internal.media_player_audio_volume;
import uk.co.caprica.vlcj.binding.internal.media_player_buffering;
import uk.co.caprica.vlcj.binding.internal.media_player_chapter_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_es_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_length_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_media_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_pausable_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_position_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_scrambled_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_seekable_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_snapshot_taken;
import uk.co.caprica.vlcj.binding.internal.media_player_time_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_title_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_vout;
import uk.co.caprica.vlcj.binding.internal.media_state_changed;
import uk.co.caprica.vlcj.binding.internal.media_subitem_added;
import uk.co.caprica.vlcj.binding.internal.media_subitemtree_added;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.events.AbstractMediaPlayerEvent;
import uk.co.caprica.vlcj.player.events.MediaDurationChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaEndOfSubItemsEvent;
import uk.co.caprica.vlcj.player.events.MediaFreedEvent;
import uk.co.caprica.vlcj.player.events.MediaMetaChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaNewEvent;
import uk.co.caprica.vlcj.player.events.MediaParsedChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerAudioDeviceEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerAudioVolumeEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerBackwardEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerBufferingEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerChapterChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerCorkedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerESAddedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerESDeletedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerESSelectedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEncounteredErrorEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEndReachedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEventType;
import uk.co.caprica.vlcj.player.events.MediaPlayerForwardEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerLengthChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerMediaChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerMutedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerNothingSpecialEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerOpeningEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerPausableChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerPausedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerPlayingEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerPositionChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerScrambledChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerSeekableChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerSnapshotTakenEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerStoppedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerTimeChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerTitleChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerVoutEvent;
import uk.co.caprica.vlcj.player.events.MediaStateChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaSubItemAddedEvent;
import uk.co.caprica.vlcj.player.events.MediaSubItemFinishedEvent;
import uk.co.caprica.vlcj.player.events.MediaSubItemPlayedEvent;
import uk.co.caprica.vlcj.player.events.MediaSubItemTreeAddedEvent;

public class MediaPlayerEventFactory {
    private final MediaPlayer mediaPlayer;

    public MediaPlayerEventFactory(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    public MediaPlayerEvent createEvent(libvlc_event_t event, long eventMask) {
        AbstractMediaPlayerEvent result = null;
        switch (libvlc_event_e.event(event.type)) {
            case libvlc_MediaPlayerMediaChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_CHANGED)) break;
                libvlc_media_t mediaInstance = ((media_player_media_changed)event.u.getTypedValue(media_player_media_changed.class)).md;
                result = new MediaPlayerMediaChangedEvent(this.mediaPlayer, mediaInstance, this.mediaPlayer.mrl(mediaInstance));
                break;
            }
            case libvlc_MediaPlayerNothingSpecial: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_CHANGED)) break;
                result = new MediaPlayerNothingSpecialEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerOpening: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.OPENING)) break;
                result = new MediaPlayerOpeningEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerBuffering: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.BUFFERING)) break;
                result = new MediaPlayerBufferingEvent(this.mediaPlayer, ((media_player_buffering)event.u.getTypedValue(media_player_buffering.class)).new_cache);
                break;
            }
            case libvlc_MediaPlayerPlaying: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.PLAYING)) break;
                result = new MediaPlayerPlayingEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerPaused: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.PAUSED)) break;
                result = new MediaPlayerPausedEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerStopped: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.STOPPED)) break;
                result = new MediaPlayerStoppedEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerForward: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.FORWARD)) break;
                result = new MediaPlayerForwardEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerBackward: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.BACKWARD)) break;
                result = new MediaPlayerBackwardEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerEndReached: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.FINISHED)) break;
                result = new MediaPlayerEndReachedEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerEncounteredError: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.ERROR)) break;
                result = new MediaPlayerEncounteredErrorEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerTimeChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.TIME_CHANGED)) break;
                result = new MediaPlayerTimeChangedEvent(this.mediaPlayer, ((media_player_time_changed)event.u.getTypedValue(media_player_time_changed.class)).new_time);
                break;
            }
            case libvlc_MediaPlayerPositionChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.POSITION_CHANGED)) break;
                result = new MediaPlayerPositionChangedEvent(this.mediaPlayer, ((media_player_position_changed)event.u.getTypedValue(media_player_position_changed.class)).new_position);
                break;
            }
            case libvlc_MediaPlayerSeekableChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.SEEKABLE_CHANGED)) break;
                result = new MediaPlayerSeekableChangedEvent(this.mediaPlayer, ((media_player_seekable_changed)event.u.getTypedValue(media_player_seekable_changed.class)).new_seekable);
                break;
            }
            case libvlc_MediaPlayerPausableChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.PAUSABLE_CHANGED)) break;
                result = new MediaPlayerPausableChangedEvent(this.mediaPlayer, ((media_player_pausable_changed)event.u.getTypedValue(media_player_pausable_changed.class)).new_pausable);
                break;
            }
            case libvlc_MediaPlayerTitleChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.TITLE_CHANGED)) break;
                result = new MediaPlayerTitleChangedEvent(this.mediaPlayer, ((media_player_title_changed)event.u.getTypedValue(media_player_title_changed.class)).new_title);
                break;
            }
            case libvlc_MediaPlayerSnapshotTaken: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.SNAPSHOT_TAKEN)) break;
                result = new MediaPlayerSnapshotTakenEvent(this.mediaPlayer, ((media_player_snapshot_taken)event.u.getTypedValue(media_player_snapshot_taken.class)).filename);
                break;
            }
            case libvlc_MediaPlayerLengthChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.LENGTH_CHANGED)) break;
                result = new MediaPlayerLengthChangedEvent(this.mediaPlayer, ((media_player_length_changed)event.u.getTypedValue(media_player_length_changed.class)).new_length);
                break;
            }
            case libvlc_MediaPlayerVout: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.VIDEO_OUTPUT)) break;
                result = new MediaPlayerVoutEvent(this.mediaPlayer, ((media_player_vout)event.u.getTypedValue(media_player_vout.class)).new_count);
                break;
            }
            case libvlc_MediaPlayerScrambledChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.SCRAMBLED_CHANGED)) break;
                result = new MediaPlayerScrambledChangedEvent(this.mediaPlayer, ((media_player_scrambled_changed)event.u.getTypedValue(media_player_scrambled_changed.class)).new_scrambled);
                break;
            }
            case libvlc_MediaPlayerESAdded: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.ES_ADDED)) break;
                result = new MediaPlayerESAddedEvent(this.mediaPlayer, ((media_player_es_changed)event.u.getTypedValue(media_player_es_changed.class)).i_type, ((media_player_es_changed)event.u.getTypedValue(media_player_es_changed.class)).i_id);
                break;
            }
            case libvlc_MediaPlayerESDeleted: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.ES_DELETED)) break;
                result = new MediaPlayerESDeletedEvent(this.mediaPlayer, ((media_player_es_changed)event.u.getTypedValue(media_player_es_changed.class)).i_type, ((media_player_es_changed)event.u.getTypedValue(media_player_es_changed.class)).i_id);
                break;
            }
            case libvlc_MediaPlayerESSelected: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.ES_SELECTED)) break;
                result = new MediaPlayerESSelectedEvent(this.mediaPlayer, ((media_player_es_changed)event.u.getTypedValue(media_player_es_changed.class)).i_type, ((media_player_es_changed)event.u.getTypedValue(media_player_es_changed.class)).i_id);
                break;
            }
            case libvlc_MediaPlayerCorked: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_PLAYER_CORKED)) break;
                result = new MediaPlayerCorkedEvent(this.mediaPlayer, true);
                break;
            }
            case libvlc_MediaPlayerUncorked: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_PLAYER_CORKED)) break;
                result = new MediaPlayerCorkedEvent(this.mediaPlayer, false);
                break;
            }
            case libvlc_MediaPlayerMuted: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_PLAYER_MUTED)) break;
                result = new MediaPlayerMutedEvent(this.mediaPlayer, true);
                break;
            }
            case libvlc_MediaPlayerUnmuted: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_PLAYER_MUTED)) break;
                result = new MediaPlayerMutedEvent(this.mediaPlayer, false);
                break;
            }
            case libvlc_MediaPlayerAudioVolume: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_PLAYER_AUDIO_VOLUME)) break;
                result = new MediaPlayerAudioVolumeEvent(this.mediaPlayer, ((media_player_audio_volume)event.u.getTypedValue(media_player_audio_volume.class)).volume);
                break;
            }
            case libvlc_MediaPlayerAudioDevice: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_PLAYER_AUDIO_DEVICE)) break;
                result = new MediaPlayerAudioDeviceEvent(this.mediaPlayer, ((media_player_audio_device)event.u.getTypedValue(media_player_audio_device.class)).device);
                break;
            }
            case libvlc_MediaPlayerChapterChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_PLAYER_CHAPTER_CHANGED)) break;
                result = new MediaPlayerChapterChangedEvent(this.mediaPlayer, ((media_player_chapter_changed)event.u.getTypedValue(media_player_chapter_changed.class)).new_chapter);
                break;
            }
            case libvlc_MediaMetaChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_META_CHANGED)) break;
                result = new MediaMetaChangedEvent(this.mediaPlayer, ((media_meta_changed)event.u.getTypedValue(media_meta_changed.class)).meta_type);
                break;
            }
            case libvlc_MediaSubItemAdded: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_SUB_ITEM_ADDED)) break;
                result = new MediaSubItemAddedEvent(this.mediaPlayer, ((media_subitem_added)event.u.getTypedValue(media_subitem_added.class)).new_child);
                break;
            }
            case libvlc_MediaDurationChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_DURATION_CHANGED)) break;
                result = new MediaDurationChangedEvent(this.mediaPlayer, ((media_duration_changed)event.u.getTypedValue(media_duration_changed.class)).new_duration);
                break;
            }
            case libvlc_MediaParsedChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_PARSED_CHANGED)) break;
                result = new MediaParsedChangedEvent(this.mediaPlayer, ((media_parsed_changed)event.u.getTypedValue(media_parsed_changed.class)).new_status);
                break;
            }
            case libvlc_MediaFreed: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_FREED)) break;
                result = new MediaFreedEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaStateChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_STATE_CHANGED)) break;
                result = new MediaStateChangedEvent(this.mediaPlayer, ((media_state_changed)event.u.getTypedValue(media_state_changed.class)).new_state);
                break;
            }
            case libvlc_MediaSubItemTreeAdded: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_SUB_ITEM_TREE_ADDED)) break;
                result = new MediaSubItemTreeAddedEvent(this.mediaPlayer, ((media_subitemtree_added)event.u.getTypedValue(media_subitemtree_added.class)).item);
            }
        }
        return result;
    }

    public MediaPlayerEvent createMediaNewEvent(long eventMask) {
        if (MediaPlayerEventType.set(eventMask, MediaPlayerEventType.NEW_MEDIA)) {
            return new MediaNewEvent(this.mediaPlayer);
        }
        return null;
    }

    public MediaPlayerEvent createMediaSubItemPlayedEvent(int subItemIndex, long eventMask) {
        if (MediaPlayerEventType.set(eventMask, MediaPlayerEventType.SUB_ITEM_PLAYED)) {
            return new MediaSubItemPlayedEvent(this.mediaPlayer, subItemIndex);
        }
        return null;
    }

    public MediaPlayerEvent createMediaSubItemFinishedEvent(int subItemIndex, long eventMask) {
        if (MediaPlayerEventType.set(eventMask, MediaPlayerEventType.SUB_ITEM_FINISHED)) {
            return new MediaSubItemFinishedEvent(this.mediaPlayer, subItemIndex);
        }
        return null;
    }

    public MediaPlayerEvent createMediaEndOfSubItemsEvent(long eventMask) {
        if (MediaPlayerEventType.set(eventMask, MediaPlayerEventType.END_OF_SUB_ITEMS)) {
            return new MediaEndOfSubItemsEvent(this.mediaPlayer);
        }
        return null;
    }
}

