/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader;

import com.bulenkov.iconloader.RetinaImage;
import com.bulenkov.iconloader.util.BufferExposingByteArrayOutputStream;
import com.bulenkov.iconloader.util.ConcurrencyUtil;
import com.bulenkov.iconloader.util.Pair;
import com.bulenkov.iconloader.util.ReflectionUtil;
import com.bulenkov.iconloader.util.StringUtil;
import com.bulenkov.iconloader.util.UIUtil;
import com.bulenkov.iconloader.util.URLUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class IconLoader {
    public static boolean STRICT = false;
    private static boolean USE_DARK_ICONS = UIUtil.isUnderDarcula();
    private static final ConcurrentMap<URL, CachedImageIcon> ourIconsCache = new ConcurrentHashMap<URL, CachedImageIcon>(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = new WeakHashMap<Icon, Icon>(200);
    private static final ImageIcon EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

        @Override
        public String toString() {
            return "Empty icon " + super.toString();
        }
    };
    private static AtomicBoolean ourIsActivated = new AtomicBoolean(true);
    private static AtomicBoolean ourIsSaveRealIconPath = new AtomicBoolean(false);
    public static final Component ourComponent = new Component(){};

    private IconLoader() {
    }

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !mediatracker.isErrorID(1);
    }

    public static Pair<Image, String> loadFromUrl(URL url) {
        for (Pair<String, Integer> each : IconLoader.getFileNames(url.toString())) {
            try {
                return Pair.create(IconLoader.loadFromStream(URLUtil.openStream(new URL((String)each.first)), (Integer)each.second), each.first);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static Image loadFromUrl(URL url, boolean dark, boolean retina) {
        for (Pair<String, Integer> each : IconLoader.getFileNames(url.toString(), dark, retina)) {
            try {
                return IconLoader.loadFromStream(URLUtil.openStream(new URL((String)each.first)), (Integer)each.second);
            }
            catch (IOException ignore) {
            }
        }
        return null;
    }

    public static Image loadFromResource(String s) {
        int stackFrameCount = 2;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(1);
        }
        if (callerClass == null) {
            return null;
        }
        return IconLoader.loadFromResource(s, callerClass);
    }

    public static Image loadFromResource(String path, Class aClass) {
        for (Pair<String, Integer> each : IconLoader.getFileNames(path)) {
            Image image;
            InputStream stream = aClass.getResourceAsStream((String)each.first);
            if (stream == null || (image = IconLoader.loadFromStream(stream, (Integer)each.second)) == null) continue;
            return image;
        }
        return null;
    }

    public static List<Pair<String, Integer>> getFileNames(String file) {
        return IconLoader.getFileNames(file, USE_DARK_ICONS, UIUtil.isRetina());
    }

    public static List<Pair<String, Integer>> getFileNames(String file, boolean dark, boolean retina) {
        if (retina || dark) {
            ArrayList<Pair<String, Integer>> answer = new ArrayList<Pair<String, Integer>>(4);
            String name = StringUtil.getFileNameWithoutExtension(file);
            String ext = StringUtil.getFileExtension(file);
            if (dark && retina) {
                answer.add(Pair.create(name + "@2x_dark." + ext, 2));
            }
            if (dark) {
                answer.add(Pair.create(name + "_dark." + ext, 1));
            }
            if (retina) {
                answer.add(Pair.create(name + "@2x." + ext, 2));
            }
            answer.add(Pair.create(file, 1));
            return answer;
        }
        return Collections.singletonList(Pair.create(file, 1));
    }

    public static Image loadFromStream(InputStream inputStream) {
        return IconLoader.loadFromStream(inputStream, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadFromStream(InputStream inputStream, int scale) {
        if (scale <= 0) {
            throw new IllegalArgumentException("Scale must 1 or more");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            IconLoader.waitForImage(image);
            if (UIUtil.isRetina() && scale > 1) {
                image = RetinaImage.createFrom(image, scale, ourComponent);
            }
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Icon getIcon(Image image) {
        return new MyImageIcon(image);
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        USE_DARK_ICONS = useDarkIcons;
        ourIconsCache.clear();
        ourIcon2DisabledIcon.clear();
    }

    public static Icon getIcon(String path) {
        int stackFrameCount = 2;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(1);
        }
        assert (callerClass != null) : path;
        return IconLoader.getIcon(path, callerClass);
    }

    public static Icon findIcon(String path) {
        int stackFrameCount = 2;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(1);
        }
        if (callerClass == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass);
    }

    public static Icon getIcon(String path, Class aClass) {
        Icon icon = IconLoader.findIcon(path, aClass);
        assert (icon != null) : "Icon cannot be found in '" + path + "', aClass='" + aClass + "'";
        return icon;
    }

    public static void activate() {
        ourIsActivated.set(true);
    }

    public static void disable() {
        ourIsActivated.set(false);
    }

    public static boolean isLoaderDisabled() {
        return !ourIsActivated.get();
    }

    static void enableSaveRealIconPath() {
        ourIsSaveRealIconPath.set(true);
    }

    public static Icon findIcon(String path, Class aClass) {
        return IconLoader.findIcon(path, aClass, true);
    }

    public static Icon findIcon(String path, Class aClass, boolean computeNow) {
        URL myURL = aClass.getResource(path);
        if (myURL == null) {
            if (STRICT) {
                throw new RuntimeException("Can't find icon in '" + path + "' near " + aClass);
            }
            return null;
        }
        return IconLoader.findIcon(myURL);
    }

    public static Icon findIcon(URL url) {
        if (url == null) {
            return null;
        }
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url);
            icon = ConcurrencyUtil.cacheOrGet(ourIconsCache, url, icon);
        }
        return icon;
    }

    public static Icon findIcon(String path, ClassLoader classLoader) {
        if (!StringUtil.startsWithChar(path, '/')) {
            return null;
        }
        URL url = classLoader.getResource(path.substring(1));
        return IconLoader.findIcon(url);
    }

    private static Icon checkIcon(Image image, URL url) {
        if (image == null || image.getHeight(LabelHolder.ourFakeComponent) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (icon != null && !IconLoader.isGoodSize(icon)) {
            return EMPTY_ICON;
        }
        return icon;
    }

    public static boolean isGoodSize(Icon icon) {
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    public static Icon getDisabledIcon(Icon icon) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        Icon disabledIcon = ourIcon2DisabledIcon.get(icon);
        if (disabledIcon == null) {
            if (!IconLoader.isGoodSize(icon)) {
                return EMPTY_ICON;
            }
            int scale = UIUtil.isRetina() ? 2 : 1;
            BufferedImage image = new BufferedImage(scale * icon.getIconWidth(), scale * icon.getIconHeight(), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(UIUtil.TRANSPARENT_COLOR);
            graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            graphics.scale(scale, scale);
            icon.paintIcon(LabelHolder.ourFakeComponent, graphics, 0, 0);
            graphics.dispose();
            Image img = IconLoader.createDisabled(image);
            if (UIUtil.isRetina()) {
                img = RetinaImage.createFrom(img, 2, ourComponent);
            }
            disabledIcon = new MyImageIcon(img);
            ourIcon2DisabledIcon.put(icon, disabledIcon);
        }
        return disabledIcon;
    }

    private static Image createDisabled(BufferedImage image) {
        GrayFilter filter = UIUtil.getGrayFilter();
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public static Icon getTransparentIcon(Icon icon) {
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    public static Icon getTransparentIcon(final Icon icon, final float alpha) {
        return new Icon(){

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }
        };
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();

        private LabelHolder() {
        }
    }

    public static abstract class LazyIcon
    implements Icon {
        private boolean myWasComputed;
        private Icon myIcon;
        private boolean isDarkVariant = IconLoader.access$100();

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon = this.getOrComputeIcon();
            if (icon != null) {
                icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconWidth() : 0;
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconHeight() : 0;
        }

        protected final synchronized Icon getOrComputeIcon() {
            if (!this.myWasComputed || this.isDarkVariant != USE_DARK_ICONS) {
                this.isDarkVariant = USE_DARK_ICONS;
                this.myWasComputed = true;
                this.myIcon = this.compute();
            }
            return this.myIcon;
        }

        public final void load() {
            this.getIconWidth();
        }

        protected abstract Icon compute();
    }

    private static final class MyImageIcon
    extends ImageIcon {
        public MyImageIcon(Image image) {
            super(image);
        }

        @Override
        public final synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            ImageObserver observer = this.getImageObserver();
            UIUtil.drawImage(g, this.getImage(), x, y, observer == null ? c : observer);
        }
    }

    static final class CachedImageIcon
    implements Icon {
        private Object myRealIcon;
        String realPath;
        private final URL myUrl;
        private boolean dark;

        public CachedImageIcon(URL url) {
            this.myUrl = url;
            this.dark = USE_DARK_ICONS;
        }

        private synchronized Icon getRealIcon() {
            Icon icon;
            Object realIcon;
            if (IconLoader.isLoaderDisabled()) {
                return EMPTY_ICON;
            }
            if (this.dark != USE_DARK_ICONS) {
                this.myRealIcon = null;
                this.dark = USE_DARK_ICONS;
            }
            if ((realIcon = this.myRealIcon) instanceof Icon) {
                return (Icon)realIcon;
            }
            if (realIcon instanceof Reference && (icon = (Icon)((Reference)realIcon).get()) != null) {
                return icon;
            }
            Pair<Image, String> image = IconLoader.loadFromUrl(this.myUrl);
            icon = IconLoader.checkIcon((Image)image.first, this.myUrl);
            if (icon != null) {
                realIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<Icon>(icon);
                this.myRealIcon = realIcon;
                if (ourIsSaveRealIconPath.get()) {
                    this.realPath = (String)image.second;
                }
            }
            return icon == null ? EMPTY_ICON : icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getRealIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            return this.myUrl.toString();
        }
    }
}

