/*
 * Decompiled with CFR 0.152.
 */
package org.monte.screenrecorder;

import com.sun.awt.AWTUtilities;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JRecordingAreaFrame
extends JFrame {
    private static final Color backgroundColor = new Color(-1996488705, true);
    private int dragWhich = -1;
    private Insets dragInsets = new Insets(10, 10, 10, 10);
    private Dimension minSize = new Dimension(320, 240);
    private Handler handler = new Handler();
    private JButton closeButton;
    private JLabel infoLabel;
    private JPanel infoPanel;

    public JRecordingAreaFrame() {
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        this.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        this.setBackground(backgroundColor);
        JContentPane cp = new JContentPane();
        this.setContentPane(cp);
        this.getRootPane().setOpaque(true);
        cp.setOpaque(false);
        AWTUtilities.setWindowOpaque((Window)this, (boolean)false);
        this.initComponents();
        this.infoLabel.addMouseListener(this.handler);
        this.infoLabel.addMouseMotionListener(this.handler);
        cp.addMouseListener(this.handler);
        cp.addMouseMotionListener(this.handler);
        this.infoLabel.setOpaque(false);
        this.infoPanel.setBorder(new EraseBorder(new Insets(8, 10, 8, 10)));
        this.infoLabel.setForeground(new Color(0xFFFFFF));
        this.closeButton.setOpaque(false);
        this.setSize(600, 400);
        this.updateLabel();
    }

    public void updateLabel() {
        Rectangle r = this.getBounds();
        this.infoLabel.setText("Recording Area: " + r.x + ", " + r.y + "; " + r.width + " x " + r.height);
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.closeButton = new JButton();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridBagLayout());
        this.infoPanel.setLayout(new GridBagLayout());
        this.infoLabel.setText("Recording Area: 0,0,640,480");
        this.infoPanel.add((Component)this.infoLabel, new GridBagConstraints());
        this.getContentPane().add((Component)this.infoPanel, new GridBagConstraints());
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(formListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.closeButton, gridBagConstraints);
        this.pack();
    }

    private void closeButtonPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JRecordingAreaFrame().setVisible(true);
            }
        });
    }

    private static class EraseBorder
    implements Border {
        private Insets insets;

        public EraseBorder(Insets insets) {
            this.insets = insets;
        }

        @Override
        public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
            Graphics2D g = (Graphics2D)gr;
            g.setComposite(AlphaComposite.Src);
            g.setColor(new Color(-1728053248, true));
            g.fillRect(x, y, width, height);
            g.setComposite(AlphaComposite.SrcOver);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return (Insets)this.insets.clone();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == JRecordingAreaFrame.this.closeButton) {
                JRecordingAreaFrame.this.closeButtonPerformed(evt);
            }
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener {
        private Point prevp;
        private int region;

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private int getRegion(MouseEvent e) {
            Point p = this.getLocationOnRootPane(e);
            int w = JRecordingAreaFrame.this.getWidth();
            int h = JRecordingAreaFrame.this.getHeight();
            if (p.x < ((JRecordingAreaFrame)JRecordingAreaFrame.this).dragInsets.left) {
                if (p.y < ((JRecordingAreaFrame)JRecordingAreaFrame.this).dragInsets.top) {
                    return 8;
                }
                if (p.y > h - ((JRecordingAreaFrame)JRecordingAreaFrame.this).dragInsets.bottom) {
                    return 6;
                }
                return 7;
            }
            if (p.x > w - ((JRecordingAreaFrame)JRecordingAreaFrame.this).dragInsets.right) {
                if (p.y < ((JRecordingAreaFrame)JRecordingAreaFrame.this).dragInsets.top) {
                    return 2;
                }
                if (p.y > h - ((JRecordingAreaFrame)JRecordingAreaFrame.this).dragInsets.bottom) {
                    return 4;
                }
                return 3;
            }
            if (p.y < ((JRecordingAreaFrame)JRecordingAreaFrame.this).dragInsets.top) {
                return 1;
            }
            if (p.y > h - ((JRecordingAreaFrame)JRecordingAreaFrame.this).dragInsets.bottom) {
                return 5;
            }
            return 0;
        }

        private Point getLocationOnRootPane(MouseEvent e) {
            Point mp = e.getLocationOnScreen();
            Point rp = JRecordingAreaFrame.this.getRootPane().getLocationOnScreen();
            mp.x -= rp.x;
            mp.y -= rp.y;
            return mp;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.prevp = this.getLocationOnRootPane(e);
            this.prevp = e.getLocationOnScreen();
            this.region = this.getRegion(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p = e.getLocationOnScreen();
            Point l = JRecordingAreaFrame.this.getLocation();
            Dimension s = JRecordingAreaFrame.this.getSize();
            Point d = new Point(p.x - this.prevp.x, p.y - this.prevp.y);
            switch (this.region) {
                case 1: {
                    JRecordingAreaFrame.this.setLocation(l.x, l.y + d.y);
                    JRecordingAreaFrame.this.setSize(s.width, Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.height, s.height - d.y));
                    break;
                }
                case 5: {
                    JRecordingAreaFrame.this.setLocation(l.x, Math.min(l.y + d.y + s.height - ((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.height, l.y));
                    JRecordingAreaFrame.this.setSize(s.width, Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.height, s.height + d.y));
                    break;
                }
                case 7: {
                    JRecordingAreaFrame.this.setLocation(l.x + d.x, l.y);
                    JRecordingAreaFrame.this.setSize(Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.width, s.width - d.x), s.height);
                    break;
                }
                case 3: {
                    JRecordingAreaFrame.this.setLocation(Math.min(l.x + d.x + s.width - ((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.width, l.x), l.y);
                    JRecordingAreaFrame.this.setSize(Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.width, s.width + d.x), s.height);
                    break;
                }
                case 2: {
                    JRecordingAreaFrame.this.setLocation(Math.min(l.x + d.x + s.width - ((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.width, l.x), l.y + d.y);
                    JRecordingAreaFrame.this.setSize(Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.width, s.width + d.x), Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.height, s.height - d.y));
                    break;
                }
                case 4: {
                    JRecordingAreaFrame.this.setLocation(Math.min(l.x + d.x + s.width - ((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.width, l.x), Math.min(l.y + d.y + s.height - ((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.height, l.y));
                    JRecordingAreaFrame.this.setSize(Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.width, s.width + d.x), Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.height, s.height + d.y));
                    break;
                }
                case 8: {
                    JRecordingAreaFrame.this.setLocation(l.x + d.x, l.y + d.y);
                    JRecordingAreaFrame.this.setSize(Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.width, s.width - d.x), Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.height, s.height - d.y));
                    break;
                }
                case 6: {
                    JRecordingAreaFrame.this.setLocation(l.x + d.x, Math.min(l.y + d.y + s.height - ((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.height, l.y));
                    JRecordingAreaFrame.this.setSize(Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.width, s.width - d.x), Math.max(((JRecordingAreaFrame)JRecordingAreaFrame.this).minSize.height, s.height + d.y));
                    break;
                }
                case 0: {
                    JRecordingAreaFrame.this.setLocation(l.x + d.x, l.y + d.y);
                    break;
                }
            }
            this.prevp = p;
            JRecordingAreaFrame.this.updateLabel();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int r = this.getRegion(e);
            switch (r) {
                case 1: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                case 5: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 7: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getPredefinedCursor(10));
                    break;
                }
                case 3: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 2: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getPredefinedCursor(7));
                    break;
                }
                case 4: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                case 8: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getPredefinedCursor(6));
                    break;
                }
                case 6: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getPredefinedCursor(4));
                    break;
                }
                case 0: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                default: {
                    JRecordingAreaFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private static class JContentPane
    extends JPanel {
        private JContentPane() {
        }

        @Override
        protected void paintComponent(Graphics gr) {
            int w = this.getWidth();
            int h = this.getHeight();
            Graphics2D g = (Graphics2D)gr;
            g.setComposite(AlphaComposite.Src);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, w, h);
            g.setColor(Color.BLACK);
            g.drawRect(1, 1, w - 3, h - 3);
            g.drawRect(2, 2, w - 5, h - 5);
            g.drawRect(3, 3, w - 7, h - 7);
            g.setColor(Color.WHITE);
            float dash_phase = System.currentTimeMillis() % 1000L / 50L;
            BasicStroke s = new BasicStroke(3.0f, 0, 2, 1.0f, new float[]{5.0f, 5.0f}, dash_phase);
            g.setStroke(s);
            g.drawRect(2, 2, w - 5, h - 5);
            this.repaint(100L);
        }
    }
}

