/*
 * Decompiled with CFR 0.152.
 */
package org.monte.moviemaker;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import org.monte.media.Buffer;
import org.monte.media.Format;
import org.monte.media.VideoFormatKeys;
import org.monte.media.gui.datatransfer.FileTextFieldTransferHandler;
import org.monte.media.math.Rational;
import org.monte.media.mp3.MP3AudioInputStream;
import org.monte.media.quicktime.AbstractQuickTimeStream;
import org.monte.media.quicktime.QuickTimeOutputStream;
import org.monte.media.quicktime.QuickTimeWriter;

public class MovieMakerMain
extends JFrame {
    private JFileChooser imageFolderChooser;
    private JFileChooser soundFileChooser;
    private JFileChooser movieFileChooser;
    private Preferences prefs;
    private WhatToDo whatToDo = WhatToDo.STRETCH_AND_SQUASH_VIDEO_TRACK;
    private JLabel aboutLabel;
    private JButton chooseImageFolderButton;
    private JButton chooseSoundFileButton;
    private JComboBox compressionBox;
    private JLabel compressionLabel;
    private JButton createMovieButton;
    private JRadioButton fastStartCompressedRadio;
    private JRadioButton fastStartRadio;
    private JTextField fpsField;
    private JLabel fpsLabel;
    private JTextField heightField;
    private JLabel heightLabel;
    private JTextField imageFolderField;
    private JLabel imageFolderHelpLabel;
    private JRadioButton noPreparationRadio;
    private JCheckBox passThroughCheckBox;
    private JTextField soundFileField;
    private JLabel soundFileHelpLable;
    private ButtonGroup streamingGroup;
    private JLabel streamingLabel;
    private JTextField widthField;
    private JLabel widthLabel;

    public MovieMakerMain() {
        JComponent[] smallComponents;
        this.initComponents();
        String version = this.getClass().getPackage().getImplementationVersion();
        if (version != null) {
            this.setTitle(String.valueOf(this.getTitle()) + " " + version);
        }
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(12, 18, 18, 18));
        this.imageFolderField.setTransferHandler(new FileTextFieldTransferHandler(1));
        this.soundFileField.setTransferHandler(new FileTextFieldTransferHandler());
        JComponent[] jComponentArray = smallComponents = new JComponent[]{this.compressionBox, this.compressionLabel, this.fpsField, this.fpsLabel, this.heightField, this.heightLabel, this.widthField, this.widthLabel, this.passThroughCheckBox, this.noPreparationRadio, this.fastStartCompressedRadio, this.fastStartRadio};
        int n = smallComponents.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent c = jComponentArray[n2];
            c.putClientProperty("JComponent.sizeVariant", "small");
            ++n2;
        }
        this.prefs = Preferences.userNodeForPackage(MovieMakerMain.class);
        this.imageFolderField.setText(this.prefs.get("movie.imageFolder", ""));
        this.soundFileField.setText(this.prefs.get("movie.soundFile", ""));
        this.widthField.setText("" + this.prefs.getInt("movie.width", 320));
        this.heightField.setText("" + this.prefs.getInt("movie.height", 240));
        this.passThroughCheckBox.setSelected(this.prefs.getBoolean("movie.passThrough", false));
        String fps = "" + this.prefs.getDouble("movie.fps", 30.0);
        if (fps.endsWith(".0")) {
            fps = fps.substring(0, fps.length() - 2);
        }
        this.fpsField.setText(fps);
        this.compressionBox.setSelectedIndex(Math.max(0, Math.min(this.compressionBox.getItemCount() - 1, this.prefs.getInt("movie.compression", 1))));
        String streaming = this.prefs.get("movie.streaming", "fastStartCompressed");
        Enumeration<AbstractButton> i = this.streamingGroup.getElements();
        while (i.hasMoreElements()) {
            AbstractButton btn = i.nextElement();
            if (!btn.getActionCommand().equals(streaming)) continue;
            btn.setSelected(true);
            break;
        }
    }

    private void initComponents() {
        this.streamingGroup = new ButtonGroup();
        this.aboutLabel = new JLabel();
        this.imageFolderHelpLabel = new JLabel();
        this.imageFolderField = new JTextField();
        this.chooseImageFolderButton = new JButton();
        this.soundFileHelpLable = new JLabel();
        this.soundFileField = new JTextField();
        this.chooseSoundFileButton = new JButton();
        this.createMovieButton = new JButton();
        this.widthLabel = new JLabel();
        this.widthField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightField = new JTextField();
        this.compressionLabel = new JLabel();
        this.compressionBox = new JComboBox();
        this.fpsLabel = new JLabel();
        this.fpsField = new JTextField();
        this.passThroughCheckBox = new JCheckBox();
        this.streamingLabel = new JLabel();
        this.noPreparationRadio = new JRadioButton();
        this.fastStartRadio = new JRadioButton();
        this.fastStartCompressedRadio = new JRadioButton();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(3);
        this.setTitle("QuickTime Movie Maker");
        this.aboutLabel.setText("<html><b>This is a demo of the Monte Media library.</b><br>Copyright \u00a9 2010-2012 Werner Randelshofer. All rights reserved.<br> This software can be licensed under Creative Commons Atribution 3.0.");
        this.imageFolderHelpLabel.setText("Drag a folder with image files into the field below:");
        this.chooseImageFolderButton.setText("Choose...");
        this.chooseImageFolderButton.addActionListener(formListener);
        this.soundFileHelpLable.setText("Drag a sound file into the field below (.au, .aiff, .wav, .mp3):");
        this.chooseSoundFileButton.setText("Choose...");
        this.chooseSoundFileButton.addActionListener(formListener);
        this.createMovieButton.setText("Create QuickTime Movie...");
        this.createMovieButton.addActionListener(formListener);
        this.widthLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.widthLabel.setText("Width:");
        this.widthField.setColumns(4);
        this.widthField.setFont(new Font("Lucida Grande", 0, 11));
        this.widthField.setText("320");
        this.heightLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.heightLabel.setText("Height:");
        this.heightField.setColumns(4);
        this.heightField.setFont(new Font("Lucida Grande", 0, 11));
        this.heightField.setText("240");
        this.compressionLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.compressionLabel.setText("Compression:");
        this.compressionBox.setFont(new Font("Lucida Grande", 0, 11));
        this.compressionBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Animation", "JPEG", "PNG"}));
        this.fpsLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.fpsLabel.setText("FPS:");
        this.fpsField.setColumns(4);
        this.fpsField.setFont(new Font("Lucida Grande", 0, 11));
        this.fpsField.setText("30");
        this.passThroughCheckBox.setFont(new Font("Lucida Grande", 0, 11));
        this.passThroughCheckBox.setText("Pass through");
        this.passThroughCheckBox.setToolTipText("Check this box if the folder contains already encoded video frames in the desired size.");
        this.streamingLabel.setText("Prepare for Internet Streaming");
        this.streamingGroup.add(this.noPreparationRadio);
        this.noPreparationRadio.setFont(new Font("Lucida Grande", 0, 11));
        this.noPreparationRadio.setSelected(true);
        this.noPreparationRadio.setText("No preparation");
        this.noPreparationRadio.setActionCommand("none");
        this.noPreparationRadio.addActionListener(formListener);
        this.streamingGroup.add(this.fastStartRadio);
        this.fastStartRadio.setFont(new Font("Lucida Grande", 0, 11));
        this.fastStartRadio.setText("Fast Start");
        this.fastStartRadio.setActionCommand("fastStart");
        this.fastStartRadio.addActionListener(formListener);
        this.streamingGroup.add(this.fastStartCompressedRadio);
        this.fastStartCompressedRadio.setFont(new Font("Lucida Grande", 0, 11));
        this.fastStartCompressedRadio.setText("Fast Start - Compressed Header");
        this.fastStartCompressedRadio.setActionCommand("fastStartCompressed");
        this.fastStartCompressedRadio.addActionListener(formListener);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(61, 61, 61).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.widthLabel).addComponent(this.fpsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fpsField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.compressionLabel).addGap(1, 1, 1).addComponent(this.compressionBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.passThroughCheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.widthField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.heightLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightField, -2, -1, -2))).addGap(41, 41, 41)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aboutLabel, -1, 484, Short.MAX_VALUE).addComponent(this.imageFolderHelpLabel).addComponent(this.soundFileHelpLable).addGroup(layout.createSequentialGroup().addComponent(this.soundFileField, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseSoundFileButton)).addComponent(this.createMovieButton, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.imageFolderField, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseImageFolderButton)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.streamingLabel).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fastStartRadio).addComponent(this.noPreparationRadio).addComponent(this.fastStartCompressedRadio)))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.aboutLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.imageFolderHelpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.imageFolderField, -2, -1, -2).addComponent(this.chooseImageFolderButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthLabel).addComponent(this.widthField, -2, -1, -2).addComponent(this.heightLabel).addComponent(this.heightField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compressionBox, -2, -1, -2).addComponent(this.fpsLabel).addComponent(this.fpsField, -2, -1, -2).addComponent(this.compressionLabel).addComponent(this.passThroughCheckBox)).addGap(18, 18, 18).addComponent(this.soundFileHelpLable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.soundFileField, -2, -1, -2).addComponent(this.chooseSoundFileButton)).addGap(18, 18, 18).addComponent(this.streamingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noPreparationRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fastStartRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fastStartCompressedRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.createMovieButton).addContainerGap()));
        this.pack();
    }

    private void chooseImageFolder(ActionEvent evt) {
        if (this.imageFolderChooser == null) {
            this.imageFolderChooser = new JFileChooser();
            this.imageFolderChooser.setFileSelectionMode(1);
            if (this.imageFolderField.getText().length() > 0) {
                this.imageFolderChooser.setSelectedFile(new File(this.imageFolderField.getText()));
            } else if (this.soundFileField.getText().length() > 0) {
                this.imageFolderChooser.setCurrentDirectory(new File(this.soundFileField.getText()).getParentFile());
            }
        }
        if (this.imageFolderChooser.showOpenDialog(this) == 0) {
            this.imageFolderField.setText(this.imageFolderChooser.getSelectedFile().getPath());
        }
    }

    private void chooseSoundFile(ActionEvent evt) {
        if (this.soundFileChooser == null) {
            this.soundFileChooser = new JFileChooser();
            if (this.soundFileField.getText().length() > 0) {
                this.soundFileChooser.setSelectedFile(new File(this.soundFileField.getText()));
            } else if (this.imageFolderField.getText().length() > 0) {
                this.soundFileChooser.setCurrentDirectory(new File(this.imageFolderField.getText()));
            }
        }
        if (this.soundFileChooser.showOpenDialog(this) == 0) {
            this.soundFileField.setText(this.soundFileChooser.getSelectedFile().getPath());
        }
    }

    private void createMovie(ActionEvent evt) {
        Format videoFormat;
        double fps;
        int height;
        int width;
        final File soundFile = this.soundFileField.getText().trim().length() == 0 ? null : new File(this.soundFileField.getText().trim());
        final File imageFolder = this.imageFolderField.getText().trim().length() == 0 ? null : new File(this.imageFolderField.getText().trim());
        final String streaming = this.prefs.get("movie.streaming", "fastStartCompressed");
        if (soundFile == null && imageFolder == null) {
            JOptionPane.showMessageDialog(this, "<html>You need to specify a folder with<br>image files and/or a sound file.");
            return;
        }
        try {
            width = Integer.parseInt(this.widthField.getText());
            height = Integer.parseInt(this.heightField.getText());
            fps = Double.parseDouble(this.fpsField.getText());
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, "<html>Width, Height and FPS must be numeric.");
            return;
        }
        if (fps != fps) {
            JOptionPane.showMessageDialog(this, "<html>FPS must be a real number greater than zero.");
            return;
        }
        if (width <= 0 || height <= 0 || fps <= 0.0) {
            JOptionPane.showMessageDialog(this, "<html>Width, Height and FPS must be greater than zero.");
            return;
        }
        switch (this.compressionBox.getSelectedIndex()) {
            case 0: {
                videoFormat = QuickTimeWriter.VIDEO_RAW;
                break;
            }
            case 1: {
                videoFormat = QuickTimeWriter.VIDEO_ANIMATION;
                break;
            }
            case 2: {
                videoFormat = QuickTimeWriter.VIDEO_JPEG;
                break;
            }
            default: {
                videoFormat = QuickTimeWriter.VIDEO_PNG;
            }
        }
        this.prefs.put("movie.imageFolder", this.imageFolderField.getText());
        this.prefs.put("movie.soundFile", this.soundFileField.getText());
        this.prefs.putInt("movie.width", width);
        this.prefs.putInt("movie.height", height);
        this.prefs.putDouble("movie.fps", fps);
        this.prefs.putInt("movie.compression", this.compressionBox.getSelectedIndex());
        this.prefs.putBoolean("movie.passThrough", this.passThroughCheckBox.isSelected());
        if (this.movieFileChooser == null) {
            this.movieFileChooser = new JFileChooser();
            if (this.prefs.get("movie.outputFile", null) != null) {
                this.movieFileChooser.setSelectedFile(new File(this.prefs.get("movie.outputFile", null)));
            } else if (this.imageFolderField.getText().length() > 0) {
                this.movieFileChooser.setCurrentDirectory(new File(this.imageFolderField.getText()).getParentFile());
            } else if (this.soundFileField.getText().length() > 0) {
                this.movieFileChooser.setCurrentDirectory(new File(this.soundFileField.getText()).getParentFile());
            }
        }
        if (this.movieFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        final File movieFile = this.movieFileChooser.getSelectedFile().getPath().toLowerCase().endsWith(".mov") ? this.movieFileChooser.getSelectedFile() : new File(String.valueOf(this.movieFileChooser.getSelectedFile().getPath()) + ".mov");
        this.prefs.put("movie.outputFile", movieFile.getPath());
        this.createMovieButton.setEnabled(false);
        final boolean passThrough = this.passThroughCheckBox.isSelected();
        SwingWorker w = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    Object[] imgFiles = null;
                    if (imageFolder != null && (imgFiles = imageFolder.listFiles(new FileFilter(){
                        FileSystemView fsv = FileSystemView.getFileSystemView();

                        @Override
                        public boolean accept(File f) {
                            return f.isFile() && !this.fsv.isHiddenFile(f) && !f.getName().equals("Thumbs.db");
                        }
                    })) != null) {
                        Arrays.sort(imgFiles);
                    }
                    if (movieFile.exists()) {
                        movieFile.delete();
                    }
                    if (imgFiles != null && soundFile != null && imgFiles.length > 0) {
                        MovieMakerMain.this.writeVideoAndAudio(movieFile, (File[])imgFiles, soundFile, width, height, fps, videoFormat, passThrough, streaming);
                    } else if (imgFiles != null && imgFiles.length > 0) {
                        MovieMakerMain.this.writeVideoOnlyVFR(movieFile, (File[])imgFiles, width, height, fps, videoFormat, passThrough, streaming);
                    } else if (soundFile != null) {
                        MovieMakerMain.this.writeAudioOnly(movieFile, soundFile, streaming);
                    }
                    return null;
                }
                catch (Throwable t) {
                    return t;
                }
            }

            @Override
            protected void done() {
                Object o;
                try {
                    o = this.get();
                }
                catch (Exception ex) {
                    o = ex;
                }
                if (o instanceof Throwable) {
                    Throwable t = (Throwable)o;
                    t.printStackTrace();
                    JOptionPane.showMessageDialog(MovieMakerMain.this, "<html>Creating the QuickTime Movie failed.<br>" + (t.getMessage() == null ? t.toString() : t.getMessage()), "Sorry", 0);
                }
                MovieMakerMain.this.createMovieButton.setEnabled(true);
            }
        };
        w.execute();
    }

    private void streamingRadioPerformed(ActionEvent evt) {
        this.prefs.put("movie.streaming", evt.getActionCommand());
    }

    private void writeVideoOnlyVFR(File movieFile, File[] imgFiles, int width, int height, double fps, Format videoFormat, boolean passThrough, String streaming) throws IOException {
        File tmpFile = streaming.equals("none") ? movieFile : new File(String.valueOf(movieFile.getPath()) + ".tmp");
        ProgressMonitor p = new ProgressMonitor(this, "Creating " + movieFile.getName(), "Creating Output File...", 0, imgFiles.length);
        Graphics g = null;
        Image img = null;
        BufferedImage prevImg = null;
        int[] data = null;
        int[] prevData = null;
        QuickTimeWriter qtOut = null;
        try {
            int timeScale = (int)(fps * 100.0);
            int duration = 100;
            qtOut = new QuickTimeWriter(tmpFile);
            int vt = qtOut.addVideoTrack(videoFormat, timeScale, width, height);
            qtOut.setSyncInterval(0, 30);
            if (!passThrough) {
                img = new BufferedImage(width, height, 1);
                data = ((DataBufferInt)((BufferedImage)img).getRaster().getDataBuffer()).getData();
                prevImg = new BufferedImage(width, height, 1);
                prevData = ((DataBufferInt)prevImg.getRaster().getDataBuffer()).getData();
                g = ((BufferedImage)img).createGraphics();
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            int prevImgDuration = 0;
            Buffer buf = new Buffer();
            int i = 0;
            while (i < imgFiles.length && !p.isCanceled()) {
                File f = imgFiles[i];
                p.setNote("Processing " + f.getName());
                p.setProgress(i);
                if (passThrough) {
                    qtOut.writeSample(vt, f, (long)duration, true);
                } else {
                    BufferedImage fImg = ImageIO.read(f);
                    g.drawImage(fImg, 0, 0, width, height, null);
                    if (i != 0 && Arrays.equals(data, prevData)) {
                        prevImgDuration += duration;
                    } else {
                        if (prevImgDuration != 0) {
                            qtOut.write(vt, prevImg, prevImgDuration);
                        }
                        prevImgDuration = duration;
                        System.arraycopy(data, 0, prevData, 0, data.length);
                    }
                }
                ++i;
            }
            if (prevImgDuration != 0) {
                qtOut.write(vt, prevImg, prevImgDuration);
            }
            if (streaming.equals("fastStart")) {
                qtOut.toWebOptimizedMovie(movieFile, false);
                tmpFile.delete();
            } else if (streaming.equals("fastStartCompressed")) {
                qtOut.toWebOptimizedMovie(movieFile, true);
                tmpFile.delete();
            }
            qtOut.close();
            qtOut = null;
        }
        finally {
            p.close();
            if (g != null) {
                g.dispose();
            }
            if (img != null) {
                img.flush();
            }
            if (qtOut != null) {
                qtOut.close();
            }
        }
    }

    private void writeVideoOnlyFFR(File movieFile, File[] imgFiles, int width, int height, double fps, Format videoFormat, boolean passThrough, String streaming) throws IOException {
        File tmpFile = streaming.equals("none") ? movieFile : new File(String.valueOf(movieFile.getPath()) + ".tmp");
        ProgressMonitor p = new ProgressMonitor(this, "Creating " + movieFile.getName(), "Creating Output File...", 0, imgFiles.length);
        Graphics g = null;
        Image imgBuffer = null;
        QuickTimeOutputStream qtOut = null;
        try {
            Rational duration = new Rational(1000L, (int)(fps * 1000.0));
            qtOut = new QuickTimeWriter(tmpFile);
            int vt = ((QuickTimeWriter)qtOut).addTrack(videoFormat.append(VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height));
            if (!passThrough) {
                imgBuffer = new BufferedImage(width, height, 1);
                g = ((BufferedImage)imgBuffer).createGraphics();
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            Buffer buf = new Buffer();
            int i = 0;
            while (i < imgFiles.length && !p.isCanceled()) {
                File f = imgFiles[i];
                p.setNote("Processing " + f.getName());
                p.setProgress(i);
                if (passThrough) {
                    qtOut.writeSample(vt, f, duration.floor(qtOut.getMediaTimeScale(vt)).getNumerator(), true);
                } else {
                    BufferedImage fImg = ImageIO.read(f);
                    if (fImg != null) {
                        g.drawImage(fImg, 0, 0, width, height, null);
                        buf.data = imgBuffer;
                        buf.sampleDuration = duration;
                        ((QuickTimeWriter)qtOut).write(vt, buf);
                    }
                }
                ++i;
            }
            if (streaming.equals("fastStart")) {
                qtOut.toWebOptimizedMovie(movieFile, false);
                tmpFile.delete();
            } else if (streaming.equals("fastStartCompressed")) {
                qtOut.toWebOptimizedMovie(movieFile, true);
                tmpFile.delete();
            }
            qtOut.close();
            qtOut = null;
        }
        finally {
            p.close();
            if (g != null) {
                g.dispose();
            }
            if (imgBuffer != null) {
                imgBuffer.flush();
            }
            if (qtOut != null) {
                qtOut.close();
            }
        }
    }

    private void writeAudioOnly(File movieFile, File audioFile, String streaming) throws IOException {
        File tmpFile = streaming.equals("none") ? movieFile : new File(String.valueOf(movieFile.getPath()) + ".tmp");
        int length = (int)Math.min(Integer.MAX_VALUE, audioFile.length());
        ProgressMonitor p = new ProgressMonitor(this, "Creating " + movieFile.getName(), "Initializing...", 0, length);
        AudioInputStream audioIn = null;
        QuickTimeWriter qtOut = null;
        try {
            try {
                qtOut = new QuickTimeWriter(tmpFile);
                audioIn = audioFile.getName().toLowerCase().endsWith(".mp3") ? new MP3AudioInputStream(audioFile) : AudioSystem.getAudioInputStream(audioFile);
                AudioFormat audioFormat = audioIn.getFormat();
                int at = qtOut.addAudioTrack(audioFormat);
                boolean isVBR = audioFormat.getProperty("vbr") != null && (Boolean)audioFormat.getProperty("vbr") != false;
                int asSize = audioFormat.getFrameSize();
                int nbOfFramesInBuffer = isVBR ? 1 : Math.max(1, 1024 / asSize);
                int asDuration = (int)(audioFormat.getSampleRate() / audioFormat.getFrameRate());
                long count = 0L;
                byte[] audioBuffer = new byte[asSize * nbOfFramesInBuffer];
                int bytesRead = audioIn.read(audioBuffer);
                while (bytesRead != -1) {
                    if (bytesRead != 0) {
                        int framesRead = bytesRead / asSize;
                        qtOut.writeSamples(at, framesRead, audioBuffer, 0, bytesRead, asDuration);
                        p.setProgress((int)(count += (long)bytesRead));
                    }
                    if (isVBR) {
                        audioFormat = audioIn.getFormat();
                        if (audioFormat == null) break;
                        asSize = audioFormat.getFrameSize();
                        asDuration = (int)(audioFormat.getSampleRate() / audioFormat.getFrameRate());
                        if (audioBuffer.length < asSize) {
                            audioBuffer = new byte[asSize];
                        }
                    }
                    bytesRead = audioIn.read(audioBuffer);
                }
                audioIn.close();
                audioIn = null;
                if (streaming.equals("fastStart")) {
                    qtOut.toWebOptimizedMovie(movieFile, false);
                    tmpFile.delete();
                } else if (streaming.equals("fastStartCompressed")) {
                    qtOut.toWebOptimizedMovie(movieFile, true);
                    tmpFile.delete();
                }
                qtOut.close();
                qtOut = null;
            }
            catch (UnsupportedAudioFileException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
        finally {
            p.close();
            if (audioIn != null) {
                audioIn.close();
            }
            if (qtOut != null) {
                qtOut.close();
            }
        }
    }

    private void writeVideoAndAudio(File movieFile, File[] imgFiles, File audioFile, int width, int height, double fps, Format videoFormat, boolean passThrough, String streaming) throws IOException {
        File tmpFile = streaming.equals("none") ? movieFile : new File(String.valueOf(movieFile.getPath()) + ".tmp");
        ProgressMonitor p = new ProgressMonitor(this, "Creating " + movieFile.getName(), "Creating Output File...", 0, imgFiles.length);
        AudioInputStream audioIn = null;
        QuickTimeOutputStream qtOut = null;
        Image imgBuffer = null;
        Graphics g = null;
        try {
            try {
                byte[] audioBuffer;
                int asSize;
                audioIn = audioFile.getName().toLowerCase().endsWith(".mp3") ? new MP3AudioInputStream(audioFile) : AudioSystem.getAudioInputStream(audioFile);
                AudioFormat audioFormat = audioIn.getFormat();
                boolean isVBR = audioFormat.getProperty("vbr") != null && (Boolean)audioFormat.getProperty("vbr") != false;
                int asDuration = (int)(audioFormat.getSampleRate() / audioFormat.getFrameRate());
                int vsDuration = 100;
                qtOut = new QuickTimeWriter(tmpFile);
                int at = ((QuickTimeWriter)qtOut).addAudioTrack(audioFormat);
                int vt = ((QuickTimeWriter)qtOut).addVideoTrack(videoFormat, (int)(fps * (double)vsDuration), width, height);
                qtOut.setCompressionQuality(vt, 0.95f);
                if (isVBR) {
                    asSize = audioFormat.getFrameSize();
                    audioBuffer = new byte[asSize];
                } else {
                    asSize = audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8;
                    audioBuffer = new byte[(int)(qtOut.getMediaTimeScale(0) / 2L * (long)asSize)];
                }
                if (!passThrough) {
                    imgBuffer = new BufferedImage(width, height, 1);
                    g = ((BufferedImage)imgBuffer).createGraphics();
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                }
                int movieTime = 0;
                int imgIndex = 0;
                boolean isAudioDone = false;
                Buffer buf = new Buffer();
                while (!(imgIndex >= imgFiles.length && isAudioDone || p.isCanceled())) {
                    movieTime = (int)((long)movieTime + qtOut.getMovieTimeScale() / 2L);
                    while (!isAudioDone && qtOut.getTrackDuration(0) < (long)movieTime + qtOut.getMovieTimeScale()) {
                        int len = audioIn.read(audioBuffer);
                        if (len == -1) {
                            isAudioDone = true;
                        } else {
                            qtOut.writeSamples(at, len / asSize, audioBuffer, 0, len, asDuration);
                        }
                        if (!isVBR) continue;
                        audioFormat = audioIn.getFormat();
                        if (audioFormat == null) break;
                        asSize = audioFormat.getFrameSize();
                        asDuration = (int)(audioFormat.getSampleRate() / audioFormat.getFrameRate());
                        if (audioBuffer.length >= asSize) continue;
                        audioBuffer = new byte[asSize];
                    }
                    while (imgIndex < imgFiles.length && qtOut.getTrackDuration(1) < (long)movieTime) {
                        p.setProgress(imgIndex);
                        p.setNote("Processing " + imgFiles[imgIndex].getName());
                        if (passThrough) {
                            qtOut.writeSample(vt, imgFiles[imgIndex], (long)vsDuration, true);
                        } else {
                            BufferedImage fImg = ImageIO.read(imgFiles[imgIndex]);
                            if (fImg == null) continue;
                            g.drawImage(fImg, 0, 0, width, height, null);
                            fImg.flush();
                            ((QuickTimeWriter)qtOut).write(vt, (BufferedImage)imgBuffer, vsDuration);
                        }
                        ++imgIndex;
                    }
                }
                switch (this.whatToDo) {
                    case CUT_LONGER_TRACK: {
                        long d0 = qtOut.getTrackDuration(at);
                        long d1 = qtOut.getTrackDuration(vt);
                        int longerTrack = -1;
                        int shorterDuration = -1;
                        if (d0 != 0L && d1 != 0L) {
                            if (d0 > d1) {
                                longerTrack = 0;
                                shorterDuration = (int)d1;
                            } else if (d1 > d0) {
                                longerTrack = 1;
                                shorterDuration = (int)d0;
                            }
                        }
                        if (longerTrack == -1) break;
                        LinkedList<AbstractQuickTimeStream.Edit> l = new LinkedList<AbstractQuickTimeStream.Edit>();
                        l.add(new AbstractQuickTimeStream.Edit(shorterDuration, 0, 1.0));
                        qtOut.setEditList(longerTrack, l.toArray(new AbstractQuickTimeStream.Edit[l.size()]));
                        break;
                    }
                    case DONT_CARE: {
                        break;
                    }
                    case REPEAT_SHORTER_TRACK: {
                        long d0 = qtOut.getTrackDuration(at);
                        long d1 = qtOut.getTrackDuration(vt);
                        int shorterTrack = -1;
                        int longerTrack = -1;
                        int shorterDuration = -1;
                        int longerDuration = -1;
                        if (d0 != 0L && d1 != 0L) {
                            if (d0 > d1) {
                                shorterTrack = 1;
                                longerTrack = 0;
                                shorterDuration = (int)d1;
                                longerDuration = (int)d0;
                            } else if (d1 > d0) {
                                longerTrack = 1;
                                shorterTrack = 1;
                                shorterDuration = (int)d0;
                                longerDuration = (int)d1;
                            }
                        }
                        if (longerTrack == -1) break;
                        LinkedList<AbstractQuickTimeStream.Edit> l = new LinkedList<AbstractQuickTimeStream.Edit>();
                        while (longerDuration > 0) {
                            l.add(new AbstractQuickTimeStream.Edit(Math.min(shorterDuration, longerDuration), 0, 1.0));
                            longerDuration -= shorterDuration;
                        }
                        qtOut.setEditList(shorterTrack, l.toArray(new AbstractQuickTimeStream.Edit[l.size()]));
                        break;
                    }
                    case STRETCH_AND_SQUASH_VIDEO_TRACK: {
                        long d0 = qtOut.getTrackDuration(at);
                        long d1 = qtOut.getTrackDuration(vt);
                        if (d0 == d1 || d0 == 0L || d1 == 0L) break;
                        LinkedList<AbstractQuickTimeStream.Edit> l = new LinkedList<AbstractQuickTimeStream.Edit>();
                        l.add(new AbstractQuickTimeStream.Edit((int)d0, 0, (float)d1 / (float)d0));
                        qtOut.setEditList(1, l.toArray(new AbstractQuickTimeStream.Edit[l.size()]));
                    }
                }
                if (streaming.equals("fastStart")) {
                    qtOut.toWebOptimizedMovie(movieFile, false);
                    tmpFile.delete();
                } else if (streaming.equals("fastStartCompressed")) {
                    qtOut.toWebOptimizedMovie(movieFile, true);
                    tmpFile.delete();
                }
                qtOut.close();
                qtOut = null;
            }
            catch (UnsupportedAudioFileException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
        finally {
            p.close();
            if (qtOut != null) {
                qtOut.close();
            }
            if (audioIn != null) {
                audioIn.close();
            }
            if (g != null) {
                g.dispose();
            }
            if (imgBuffer != null) {
                imgBuffer.flush();
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MovieMakerMain m = new MovieMakerMain();
                m.setVisible(true);
                m.pack();
            }
        });
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == MovieMakerMain.this.chooseImageFolderButton) {
                MovieMakerMain.this.chooseImageFolder(evt);
            } else if (evt.getSource() == MovieMakerMain.this.chooseSoundFileButton) {
                MovieMakerMain.this.chooseSoundFile(evt);
            } else if (evt.getSource() == MovieMakerMain.this.createMovieButton) {
                MovieMakerMain.this.createMovie(evt);
            } else if (evt.getSource() == MovieMakerMain.this.noPreparationRadio) {
                MovieMakerMain.this.streamingRadioPerformed(evt);
            } else if (evt.getSource() == MovieMakerMain.this.fastStartRadio) {
                MovieMakerMain.this.streamingRadioPerformed(evt);
            } else if (evt.getSource() == MovieMakerMain.this.fastStartCompressedRadio) {
                MovieMakerMain.this.streamingRadioPerformed(evt);
            }
        }
    }

    static enum WhatToDo {
        REPEAT_SHORTER_TRACK,
        STRETCH_AND_SQUASH_VIDEO_TRACK,
        CUT_LONGER_TRACK,
        DONT_CARE;

    }
}

