/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tiff;

import java.util.HashMap;

public enum IFDDataType {
    ASCII(2),
    BYTE(1),
    SHORT(3),
    LONG(4),
    RATIONAL(5),
    SBYTE(6),
    UNDEFINED(7),
    SSHORT(8),
    SLONG(9),
    SRATIONAL(10),
    FLOAT(11),
    DOUBLE(12),
    IFD(13);

    private final int typeNumber;
    private static final HashMap<Integer, IFDDataType> valueToFieldType;

    static {
        valueToFieldType = new HashMap();
        IFDDataType[] iFDDataTypeArray = IFDDataType.values();
        int n = iFDDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFDDataType t = iFDDataTypeArray[n2];
            valueToFieldType.put(t.getTypeNumber(), t);
            ++n2;
        }
    }

    private IFDDataType(int typeNumber) {
        this.typeNumber = typeNumber;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public static IFDDataType valueOf(String string) {
        return Enum.valueOf(IFDDataType.class, string);
    }
}

