/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.seq;

import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.stream.FileImageInputStream;
import org.monte.media.image.BitmapImage;
import org.monte.media.seq.SEQDecoder;
import org.monte.media.seq.SEQFrame;
import org.monte.media.seq.SEQMovieTrack;

public class SEQReader {
    private SEQMovieTrack track;
    private int fetchedEven = -1;
    private int fetchedOdd = -1;
    private BitmapImage bitmapEven;
    private BitmapImage bitmapOdd;

    public SEQReader(File file) throws IOException {
        this(file, true);
    }

    public SEQReader(File file, boolean variableFramerate) throws IOException {
        FileImageInputStream in = null;
        try {
            in = new FileImageInputStream(file);
            SEQDecoder decoder = new SEQDecoder(in);
            this.track = new SEQMovieTrack();
            decoder.produce(this.track, false);
            if (variableFramerate) {
                int n = this.removeDuplicateFrames(this.track);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void close() throws IOException {
    }

    public int getFrameCount() {
        return this.track.getFrameCount();
    }

    public int getTimeBase() {
        return this.track.getJiffies();
    }

    public BitmapImage createCompatibleBitmap() {
        return new BitmapImage(this.track.getWidth(), this.track.getHeight(), this.track.getNbPlanes() + (this.track.getMasking() == 1 ? 1 : 0), this.track.getFrame(0).getColorModel());
    }

    public void readFrame(int index, BitmapImage image) {
        BitmapImage fetched = this.fetchFrame(index);
        System.arraycopy(fetched.getBitmap(), 0, image.getBitmap(), 0, fetched.getBitmap().length);
        image.setPlanarColorModel(this.track.getFrame(index).getColorModel());
    }

    public int getJiffies() {
        return this.track.getJiffies();
    }

    public int getDuration(int index) {
        return (int)this.track.getFrame(index).getRelTime();
    }

    private BitmapImage fetchFrame(int index) {
        BitmapImage bitmap;
        int fetched;
        if (this.bitmapOdd == null || this.bitmapEven == null) {
            this.bitmapOdd = this.createCompatibleBitmap();
            this.bitmapEven = this.createCompatibleBitmap();
        }
        SEQFrame frame = null;
        int interleave = this.track.getInterleave();
        if (interleave == 1 || (index & 1) == 0) {
            if (this.fetchedEven == index) {
                return this.bitmapEven;
            }
            fetched = this.fetchedEven;
            bitmap = this.bitmapEven;
            this.fetchedEven = index;
            if (fetched == index + interleave && this.track.getFrame(fetched).isBidirectional()) {
                frame = this.track.getFrame(fetched);
                frame.decode(bitmap, this.track);
                return bitmap;
            }
            if (fetched > index) {
                frame = this.track.getFrame(0);
                frame.decode(bitmap, this.track);
                fetched = 0;
            }
        } else {
            if (this.fetchedOdd == index) {
                return this.bitmapOdd;
            }
            fetched = this.fetchedOdd;
            bitmap = this.bitmapOdd;
            this.fetchedOdd = index;
            if (fetched == index + interleave && this.track.getFrame(fetched).isBidirectional()) {
                frame = this.track.getFrame(fetched);
                frame.decode(bitmap, this.track);
                return bitmap;
            }
            if (fetched > index) {
                frame = this.track.getFrame(0);
                frame.decode(bitmap, this.track);
                frame = this.track.getFrame(1);
                frame.decode(bitmap, this.track);
                fetched = 1;
            }
        }
        int i = fetched + interleave;
        while (i <= index) {
            frame = this.track.getFrame(i);
            frame.decode(bitmap, this.track);
            i += interleave;
        }
        return bitmap;
    }

    private int removeDuplicateFrames(SEQMovieTrack track) {
        int width = track.getWidth();
        int height = track.getHeight();
        SEQFrame f0 = track.getFrame(0);
        BitmapImage bmp = new BitmapImage(width, height, track.getNbPlanes(), f0.getColorModel());
        bmp.setPreferredChunkyColorModel(f0.getColorModel());
        byte[] previousBmp = new byte[bmp.getBitmap().length];
        int[] previousColors = new int[16];
        int[] colors = new int[16];
        int removed = 0;
        SEQFrame previousF = f0;
        int i = 1;
        int n = track.getFrameCount();
        while (i < n) {
            SEQFrame f = track.getFrame(i);
            f.decode(bmp, track);
            ((IndexColorModel)f.getColorModel()).getRGBs(colors);
            if (Arrays.equals(bmp.getBitmap(), previousBmp) && Arrays.equals(colors, previousColors)) {
                previousF.setRelTime(previousF.getRelTime() + f.getRelTime());
                track.removeFrame(i);
                --n;
                --i;
                ++removed;
            } else {
                System.arraycopy(colors, 0, previousColors, 0, 16);
                System.arraycopy(bmp.getBitmap(), 0, previousBmp, 0, previousBmp.length);
                previousF = f;
            }
            ++i;
        }
        return removed;
    }
}

