/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.riff;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.monte.media.riff.RIFFParser;

public class RIFFChunk {
    private int id;
    private int type;
    private long size;
    private long scan;
    private byte[] data;
    private Hashtable<RIFFChunk, RIFFChunk> propertyChunks;
    private ArrayList<RIFFChunk> collectionChunks;
    private String parserMessage;

    public RIFFChunk(int type, int id) {
        this.id = id;
        this.type = type;
        this.size = -1L;
        this.scan = -1L;
    }

    public RIFFChunk(int type, int id, long size, long scan) {
        this.id = id;
        this.type = type;
        this.size = size;
        this.scan = scan;
    }

    public RIFFChunk(int type, int id, long size, long scan, RIFFChunk propGroup) {
        this.id = id;
        this.type = type;
        this.size = size;
        this.scan = scan;
        if (propGroup != null) {
            if (propGroup.propertyChunks != null) {
                this.propertyChunks = new Hashtable<RIFFChunk, RIFFChunk>(propGroup.propertyChunks);
            }
            if (propGroup.collectionChunks != null) {
                this.collectionChunks = new ArrayList<RIFFChunk>(propGroup.collectionChunks);
            }
        }
    }

    public int getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public long getScan() {
        return this.scan;
    }

    public void putPropertyChunk(RIFFChunk chunk) {
        if (this.propertyChunks == null) {
            this.propertyChunks = new Hashtable();
        }
        this.propertyChunks.put(chunk, chunk);
    }

    public RIFFChunk getPropertyChunk(int id) {
        if (this.propertyChunks == null) {
            return null;
        }
        RIFFChunk chunk = new RIFFChunk(this.type, id);
        return this.propertyChunks.get(chunk);
    }

    public Enumeration propertyChunks() {
        if (this.propertyChunks == null) {
            this.propertyChunks = new Hashtable();
        }
        return this.propertyChunks.keys();
    }

    public void addCollectionChunk(RIFFChunk chunk) {
        if (this.collectionChunks == null) {
            this.collectionChunks = new ArrayList();
        }
        this.collectionChunks.add(chunk);
    }

    public RIFFChunk[] getCollectionChunks(int id) {
        if (this.collectionChunks == null) {
            return new RIFFChunk[0];
        }
        Iterator<RIFFChunk> enm = this.collectionChunks.iterator();
        int i = 0;
        while (enm.hasNext()) {
            RIFFChunk chunk = enm.next();
            if (chunk.id != id) continue;
            ++i;
        }
        RIFFChunk[] array = new RIFFChunk[i];
        i = 0;
        for (RIFFChunk chunk : this.collectionChunks) {
            if (chunk.id != id) continue;
            array[i++] = chunk;
        }
        return array;
    }

    public Iterator collectionChunks() {
        if (this.collectionChunks == null) {
            this.collectionChunks = new ArrayList();
        }
        return this.collectionChunks.iterator();
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object another) {
        if (another instanceof RIFFChunk) {
            RIFFChunk that = (RIFFChunk)another;
            return that.id == this.id && that.type == this.type;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void setParserMessage(String newValue) {
        this.parserMessage = newValue;
    }

    public String getParserMessage() {
        return this.parserMessage;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "{" + RIFFParser.idToString(this.getType()) + "," + RIFFParser.idToString(this.getID()) + "}";
    }
}

