/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.pbm;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import org.monte.media.AbortException;
import org.monte.media.ParseException;
import org.monte.media.iff.IFFChunk;
import org.monte.media.iff.IFFParser;
import org.monte.media.iff.IFFVisitor;
import org.monte.media.iff.MC68000InputStream;
import org.monte.media.ilbm.CRNGColorCycle;
import org.monte.media.ilbm.ColorCycle;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.ilbm.DRNGColorCycle;

public class PBMDecoder
implements IFFVisitor {
    protected static final int PBM_ID = IFFParser.stringToID("PBM ");
    protected static final int BMHD_ID = IFFParser.stringToID("BMHD");
    protected static final int CMAP_ID = IFFParser.stringToID("CMAP");
    protected static final int CRNG_ID = IFFParser.stringToID("CRNG");
    protected static final int DRNG_ID = IFFParser.stringToID("DRNG");
    protected static final int BODY_ID = IFFParser.stringToID("BODY");
    private static final int AUTH_ID = IFFParser.stringToID("AUTH");
    private static final int ANNO_ID = IFFParser.stringToID("ANNO");
    private static final int COPYRIGHT_ID = IFFParser.stringToID("(c) ");
    protected static final int MSK_NONE = 0;
    protected static final int MSK_HAS_MASK = 1;
    protected static final int MSK_HAS_TRANSPARENT_COLOR = 2;
    protected static final int MSK_LASSO = 3;
    protected static final int CMP_NONE = 0;
    protected static final int CMP_BYTE_RUN_1 = 1;
    protected InputStream inputStream;
    protected URL location;
    protected ArrayList<ColorCyclingMemoryImageSource> sources;
    protected Hashtable properties;
    protected int bmhdWidth;
    protected int bmhdHeight;
    protected int bmhdXPosition;
    protected int bmhdYPosition;
    protected int bmhdNbPlanes;
    protected int bmhdMasking;
    protected int bmhdCompression;
    protected int bmhdTransparentColor;
    protected int bmhdXAspect;
    protected int bmhdYAspect;
    protected int bmhdPageWidth;
    protected int bmhdPageHeight;
    protected ColorModel cmapColorModel;
    protected ColorCyclingMemoryImageSource memoryImageSource;

    public PBMDecoder(InputStream in) {
        this.inputStream = in;
    }

    public PBMDecoder(URL location) {
        this.location = location;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<ColorCyclingMemoryImageSource> produce() throws IOException {
        boolean mustCloseStream;
        InputStream in = null;
        this.sources = new ArrayList();
        if (this.inputStream != null) {
            in = this.inputStream;
            mustCloseStream = false;
        } else {
            in = this.location.openStream();
            mustCloseStream = true;
        }
        try {
            try {
                IFFParser iff = new IFFParser();
                this.registerChunks(iff);
                iff.parse(in, this);
                return this.sources;
            }
            catch (ParseException e1) {
                e1.printStackTrace();
                if (!mustCloseStream) return this.sources;
                in.close();
                return this.sources;
            }
            catch (AbortException e) {
                e.printStackTrace();
                if (!mustCloseStream) return this.sources;
                in.close();
                return this.sources;
            }
        }
        finally {
            if (mustCloseStream) {
                in.close();
            }
        }
    }

    public void registerChunks(IFFParser iff) {
        iff.declareGroupChunk(PBM_ID, 1179603533);
        iff.declarePropertyChunk(PBM_ID, BMHD_ID);
        iff.declarePropertyChunk(PBM_ID, CMAP_ID);
        iff.declareDataChunk(PBM_ID, BODY_ID);
        iff.declareCollectionChunk(PBM_ID, ANNO_ID);
        iff.declareCollectionChunk(PBM_ID, COPYRIGHT_ID);
        iff.declareCollectionChunk(PBM_ID, AUTH_ID);
        iff.declareCollectionChunk(PBM_ID, CRNG_ID);
        iff.declareCollectionChunk(PBM_ID, DRNG_ID);
    }

    @Override
    public void enterGroup(IFFChunk chunk) {
    }

    @Override
    public void leaveGroup(IFFChunk chunk) {
    }

    @Override
    public void visitChunk(IFFChunk group, IFFChunk chunk) throws ParseException, AbortException {
        this.decodeBMHD(group.getPropertyChunk(BMHD_ID));
        this.decodeCMAP(group.getPropertyChunk(CMAP_ID));
        this.decodeBODY(chunk);
        double aspect = (double)this.bmhdXAspect / (double)this.bmhdYAspect;
        if (this.bmhdXAspect == 0 || this.bmhdYAspect == 0) {
            aspect = 1.0;
        }
        Hashtable props = this.memoryImageSource.getProperties();
        props.put("aspect", new Double(aspect));
        String s = "Indexed Colors";
        props.put("screenMode", s);
        props.put("nbPlanes", this.bmhdNbPlanes + ((this.bmhdMasking & 1) != 0 ? "+mask" : ""));
        StringBuffer comment = new StringBuffer();
        IFFChunk[] chunks = group.getCollectionChunks(ANNO_ID);
        int i = 0;
        while (i < chunks.length) {
            if (comment.length() > 0) {
                comment.append('\n');
            }
            comment.append(new String(chunks[i].getData()));
            ++i;
        }
        chunks = group.getCollectionChunks(AUTH_ID);
        i = 0;
        while (i < chunks.length) {
            if (comment.length() > 0) {
                comment.append('\n');
            }
            comment.append("Author: ");
            comment.append(new String(chunks[i].getData()));
            ++i;
        }
        chunks = group.getCollectionChunks(COPYRIGHT_ID);
        i = 0;
        while (i < chunks.length) {
            if (comment.length() > 0) {
                comment.append('\n');
            }
            comment.append("\u00a9 ");
            comment.append(new String(chunks[i].getData()));
            ++i;
        }
        if (comment.length() > 0) {
            props.put("comment", comment.toString());
        }
        IFFChunk[] crngChunks = group.getCollectionChunks(CRNG_ID);
        IFFChunk[] drngChunks = group.getCollectionChunks(DRNG_ID);
        int activeCycles = 0;
        int j = 0;
        int k = 0;
        int i2 = 0;
        int n = crngChunks.length + drngChunks.length;
        while (i2 < n) {
            ColorCycle cc;
            if (j < crngChunks.length && (k >= drngChunks.length || crngChunks[j].getScan() < drngChunks[k].getScan())) {
                cc = this.decodeCRNG(crngChunks[j]);
                this.memoryImageSource.addColorCycle(cc);
                if (cc.isActive()) {
                    ++activeCycles;
                }
                ++j;
            } else {
                cc = this.decodeDRNG(drngChunks[k]);
                this.memoryImageSource.addColorCycle(cc);
                if (cc.isActive()) {
                    ++activeCycles;
                }
                ++k;
            }
            ++i2;
        }
        if (activeCycles > 0) {
            this.memoryImageSource.setAnimated(true);
            props.put("colorCycling", activeCycles);
        }
        this.sources.add(this.memoryImageSource);
    }

    protected void decodeBMHD(IFFChunk chunk) throws ParseException {
        if (chunk == null) {
            throw new ParseException("no BMHD -> no Picture");
        }
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            this.bmhdWidth = in.readUWORD();
            this.bmhdHeight = in.readUWORD();
            this.bmhdXPosition = in.readWORD();
            this.bmhdYPosition = in.readWORD();
            this.bmhdNbPlanes = in.readUBYTE();
            this.bmhdMasking = in.readUBYTE();
            this.bmhdCompression = in.readUBYTE();
            in.skip(1L);
            this.bmhdTransparentColor = in.readUWORD();
            this.bmhdXAspect = in.readUBYTE();
            this.bmhdYAspect = in.readUBYTE();
            this.bmhdPageWidth = in.readWORD();
            this.bmhdPageHeight = in.readWORD();
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    protected void decodeCMAP(IFFChunk chunk) throws ParseException {
        int transparentColorIndex;
        int size = 0;
        int colorsToRead = 0;
        size = (this.bmhdMasking & 1) != 0 ? 2 << this.bmhdNbPlanes : 1 << this.bmhdNbPlanes;
        colorsToRead = Math.min(size, (int)chunk.getSize() / 3);
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        byte[] data = chunk.getData();
        int j = 0;
        int i = 0;
        while (i < colorsToRead) {
            red[i] = data[j++];
            green[i] = data[j++];
            blue[i] = data[j++];
            ++i;
        }
        int n = transparentColorIndex = (this.bmhdMasking & 2) != 0 ? this.bmhdTransparentColor : -1;
        if ((this.bmhdMasking & 1) != 0) {
            System.arraycopy(red, 0, red, red.length / 2, red.length / 2);
            System.arraycopy(green, 0, green, green.length / 2, green.length / 2);
            System.arraycopy(blue, 0, blue, blue.length / 2, blue.length / 2);
            byte[] alpha = new byte[red.length];
            int i2 = 0;
            int n2 = red.length / 2;
            while (i2 < n2) {
                alpha[i2] = -1;
                ++i2;
            }
            this.cmapColorModel = new IndexColorModel(8, red.length, red, green, blue, alpha);
        } else {
            this.cmapColorModel = new IndexColorModel(8, red.length, red, green, blue, transparentColorIndex);
        }
    }

    protected ColorCycle decodeCRNG(IFFChunk chunk) throws ParseException {
        CRNGColorCycle cc;
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int pad1 = in.readUWORD();
            int rate = in.readUWORD();
            int flags = in.readUWORD();
            int low = in.readUBYTE();
            int high = in.readUBYTE();
            cc = new CRNGColorCycle(rate, 273, low, high, (flags & 1) != 0 && rate > 36 && high > low, (flags & 2) != 0, false);
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
        return cc;
    }

    protected ColorCycle decodeDRNG(IFFChunk chunk) throws ParseException {
        DRNGColorCycle cc;
        try {
            int cell;
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int min = in.readUBYTE();
            int max = in.readUBYTE();
            int rate = in.readUWORD();
            int flags = in.readUWORD();
            int ntrue = in.readUBYTE();
            int nregs = in.readUBYTE();
            DRNGColorCycle.Cell[] cells = new DRNGColorCycle.Cell[ntrue + nregs];
            int i = 0;
            while (i < ntrue) {
                cell = in.readUBYTE();
                int rgb = in.readUBYTE() << 16 | in.readUBYTE() << 8 | in.readUBYTE();
                cells[i] = new DRNGColorCycle.DColorCell(cell, rgb);
                ++i;
            }
            i = 0;
            while (i < nregs) {
                cell = in.readUBYTE();
                int index = in.readUBYTE();
                cells[i + ntrue] = new DRNGColorCycle.DIndexCell(cell, index);
                ++i;
            }
            cc = new DRNGColorCycle(rate, 273, min, max, (flags & 1) != 0 && rate > 36 && min <= max && ntrue + nregs > 1, false, cells);
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
        return cc;
    }

    protected void decodeBODY(IFFChunk chunk) throws ParseException {
        int pixmapWidth = this.bmhdWidth % 2 == 1 ? this.bmhdWidth + 1 : this.bmhdWidth;
        byte[] pixels = new byte[pixmapWidth * this.bmhdHeight];
        byte[] data = chunk.getData();
        switch (this.bmhdCompression) {
            case 0: {
                System.arraycopy(data, 0, pixels, 0, data.length);
                break;
            }
            case 1: {
                PBMDecoder.unpackByteRun1(data, pixels);
                break;
            }
            default: {
                throw new ParseException("unknown compression method: " + this.bmhdCompression);
            }
        }
        Hashtable props = new Hashtable();
        if ((this.bmhdMasking & 1) != 0) {
            System.out.println("PBMDecoder Images with Mask not supported");
            this.memoryImageSource = new ColorCyclingMemoryImageSource(this.bmhdWidth, this.bmhdHeight, this.cmapColorModel, pixels, 0, pixmapWidth, props);
        } else {
            this.memoryImageSource = new ColorCyclingMemoryImageSource(this.bmhdWidth, this.bmhdHeight, this.cmapColorModel, pixels, 0, pixmapWidth, props);
        }
    }

    public static int unpackByteRun1(byte[] in, byte[] out) throws ParseException {
        try {
            return MC68000InputStream.unpackByteRun1(in, out);
        }
        catch (IOException ex) {
            ParseException e = new ParseException("couldn't decompress body");
            e.initCause(ex);
            throw e;
        }
    }
}

