/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.imgseq;

import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;

public class OSXCollator
extends Collator {
    private Collator collator;

    public OSXCollator() {
        this(Locale.getDefault());
    }

    public OSXCollator(Locale locale) {
        this.collator = Collator.getInstance(locale);
        if (this.collator instanceof RuleBasedCollator) {
            String rules = ((RuleBasedCollator)this.collator).getRules();
            int pos = rules.indexOf(",'-'");
            int primaryRelationPos = rules.indexOf(60);
            if (primaryRelationPos == rules.indexOf("'<'")) {
                primaryRelationPos = rules.indexOf(60, primaryRelationPos + 2);
            }
            if (pos != -1 && pos < primaryRelationPos) {
                rules = String.valueOf(rules.substring(0, pos)) + rules.substring(pos + 4, primaryRelationPos) + "<'-'" + rules.substring(primaryRelationPos);
            }
            pos = rules.indexOf(";' '");
            primaryRelationPos = rules.indexOf(60);
            if (primaryRelationPos == rules.indexOf("'<'")) {
                primaryRelationPos = rules.indexOf(60, primaryRelationPos + 2);
            }
            if (pos != -1 && pos < primaryRelationPos) {
                rules = String.valueOf(rules.substring(0, pos)) + rules.substring(pos + 4, primaryRelationPos) + "<' '" + rules.substring(primaryRelationPos);
            }
            try {
                this.collator = new RuleBasedCollator(rules);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int compare(String source, String target) {
        return this.collator.compare(this.expandNumbers(source), this.expandNumbers(target));
    }

    @Override
    public CollationKey getCollationKey(String source) {
        return this.collator.getCollationKey(this.expandNumbers(source));
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OSXCollator) {
            OSXCollator that = (OSXCollator)o;
            return this.collator.equals(that.collator);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.collator.hashCode();
    }

    private String expandNumbers(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        StringBuffer digits = new StringBuffer();
        int i = 0;
        int n = s.length();
        while (i < n) {
            char ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') {
                digits.append(ch);
            } else {
                if (digits.length() != 0) {
                    if (digits.length() < 10) {
                        out.append("00");
                        out.append(digits.length());
                    } else if (digits.length() < 100) {
                        out.append("0");
                        out.append(digits.length());
                    } else if (digits.length() < 1000) {
                        out.append(digits.length());
                    } else if (digits.length() > 999) {
                        out.append("999");
                    }
                    out.append(digits.toString());
                    digits.delete(0, digits.length());
                }
                out.append(ch);
            }
            ++i;
        }
        if (digits.length() != 0) {
            if (digits.length() < 10) {
                out.append("00");
                out.append(digits.length());
            } else if (digits.length() < 100) {
                out.append("0");
                out.append(digits.length());
            } else if (digits.length() < 1000) {
                out.append(digits.length());
            } else if (digits.length() > 999) {
                out.append("999");
            }
            out.append(digits);
        }
        return out.toString();
    }
}

