/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.ilbm;

import org.monte.media.ilbm.ColorCycle;

public class CRNGColorCycle
extends ColorCycle {
    private int low;
    private int high;
    private boolean isReverse;
    private boolean isEHB;

    public CRNGColorCycle(int rate, int timeScale, int low, int high, boolean isActive, boolean isReverse, boolean isEHB) {
        super(rate, timeScale, isActive);
        this.low = low;
        this.high = high;
        this.isReverse = isReverse;
        this.isEHB = isEHB;
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    public int getLow() {
        return this.low;
    }

    public int getHigh() {
        return this.high;
    }

    @Override
    public void doCycle(int[] rgbs, long time) {
        if (this.isBlended) {
            this.doBlendedCycle(rgbs, time);
        } else {
            this.doHardCycle(rgbs, time);
        }
    }

    public void doBlendedCycle(int[] rgbs, long time) {
        if (this.isActive) {
            this.doHardCycle(rgbs, time);
            double blendf = Math.IEEEremainder((float)(time * (long)this.rate / (long)this.timeScale) / 1000.0f, this.high - this.low + 1);
            blendf -= Math.floor(blendf);
            int blend = 255 - (int)(blendf * 255.0);
            if (this.isReverse) {
                blend = 255 - blend;
                int tmp = rgbs[this.high];
                int i = this.high;
                while (i > this.low) {
                    rgbs[i] = (rgbs[i] & 0xFF) * blend + (rgbs[i - 1] & 0xFF) * (255 - blend) >> 8 & 0xFF | (rgbs[i] & 0xFF00) * blend + (rgbs[i - 1] & 0xFF00) * (255 - blend) >> 8 & 0xFF00 | (rgbs[i] & 0xFF0000) * blend + (rgbs[i - 1] & 0xFF0000) * (255 - blend) >> 8 & 0xFF0000;
                    --i;
                }
                rgbs[this.low] = (rgbs[this.low] & 0xFF) * blend + (tmp & 0xFF) * (255 - blend) >> 8 & 0xFF | (rgbs[this.low] & 0xFF00) * blend + (tmp & 0xFF00) * (255 - blend) >> 8 & 0xFF00 | (rgbs[this.low] & 0xFF0000) * blend + (tmp & 0xFF0000) * (255 - blend) >> 8 & 0xFF0000;
            } else {
                int tmp = rgbs[this.high];
                int i = this.high;
                while (i > this.low) {
                    rgbs[i] = (rgbs[i] & 0xFF) * blend + (rgbs[i - 1] & 0xFF) * (255 - blend) >> 8 & 0xFF | (rgbs[i] & 0xFF00) * blend + (rgbs[i - 1] & 0xFF00) * (255 - blend) >> 8 & 0xFF00 | (rgbs[i] & 0xFF0000) * blend + (rgbs[i - 1] & 0xFF0000) * (255 - blend) >> 8 & 0xFF0000;
                    --i;
                }
                rgbs[this.low] = (rgbs[this.low] & 0xFF) * blend + (tmp & 0xFF) * (255 - blend) >> 8 & 0xFF | (rgbs[this.low] & 0xFF00) * blend + (tmp & 0xFF00) * (255 - blend) >> 8 & 0xFF00 | (rgbs[this.low] & 0xFF0000) * blend + (tmp & 0xFF0000) * (255 - blend) >> 8 & 0xFF0000;
            }
        }
    }

    public void doHardCycle(int[] rgbs, long time) {
        block9: {
            int i;
            int tmp;
            int shift;
            block10: {
                int i2;
                int tmp2;
                if (!this.isActive) break block9;
                shift = (int)(time * (long)this.rate / (long)this.timeScale / 1000L % (long)(this.high - this.low + 1));
                if (!this.isReverse) break block10;
                int j = 0;
                while (j < shift) {
                    tmp2 = rgbs[this.low];
                    i2 = this.low;
                    while (i2 < this.high) {
                        rgbs[i2] = rgbs[i2 + 1];
                        ++i2;
                    }
                    rgbs[this.high] = tmp2;
                    ++j;
                }
                if (!this.isEHB) break block9;
                j = 0;
                while (j < shift) {
                    tmp2 = rgbs[this.low + 32];
                    i2 = this.low + 32;
                    while (i2 < this.high + 32) {
                        rgbs[i2] = rgbs[i2 + 1];
                        ++i2;
                    }
                    rgbs[this.high + 32] = tmp2;
                    ++j;
                }
                break block9;
            }
            int j = 0;
            while (j < shift) {
                tmp = rgbs[this.high];
                i = this.high;
                while (i > this.low) {
                    rgbs[i] = rgbs[i - 1];
                    --i;
                }
                rgbs[this.low] = tmp;
                ++j;
            }
            if (this.isEHB) {
                j = 0;
                while (j < shift) {
                    tmp = rgbs[this.high + 32];
                    i = this.high + 32;
                    while (i > this.low + 32) {
                        rgbs[i] = rgbs[i - 1];
                        --i;
                    }
                    rgbs[this.low + 32] = tmp;
                    ++j;
                }
            }
        }
    }
}

