/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.eightsvx;

import java.io.InputStream;
import org.monte.media.eightsvx.LoopableAudioClip;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;
import sun.audio.ContinuousAudioDataStream;

public class JDK10AudioClip
implements LoopableAudioClip {
    private int sampleRate;
    private byte[] samples;
    private AudioDataStream audioStream;

    public JDK10AudioClip(byte[] samples, int sampleRate) {
        this.samples = samples;
        this.sampleRate = sampleRate;
    }

    @Override
    public synchronized void play() {
        this.stop();
        byte[] data = new byte[this.samples.length + 24];
        JDK10AudioClip.writeSunAudioHeader(data, this.sampleRate, this.samples.length);
        System.arraycopy(this.samples, 0, data, 24, this.samples.length);
        AudioData audioData = new AudioData(data);
        this.audioStream = new AudioDataStream(audioData);
        AudioPlayer.player.start((InputStream)this.audioStream);
    }

    @Override
    public synchronized void loop() {
        this.stop();
        byte[] data = new byte[this.samples.length + 24];
        JDK10AudioClip.writeSunAudioHeader(data, this.sampleRate, this.samples.length);
        System.arraycopy(this.samples, 0, data, 24, this.samples.length);
        AudioData audioData = new AudioData(data);
        ContinuousAudioDataStream audioStream = new ContinuousAudioDataStream(audioData);
        AudioPlayer.player.start((InputStream)audioStream);
    }

    @Override
    public void loop(int count) {
        if (count == 1 || count == 0) {
            this.play();
        } else if (count == -1) {
            this.loop();
        } else {
            this.stop();
            byte[] data = new byte[this.samples.length * count + 24];
            JDK10AudioClip.writeSunAudioHeader(data, this.sampleRate, this.samples.length * count);
            int i = 0;
            while (i < count) {
                System.arraycopy(this.samples, 0, data, 24 + i * this.samples.length, this.samples.length);
                ++i;
            }
            AudioData audioData = new AudioData(data);
            ContinuousAudioDataStream audioStream = new ContinuousAudioDataStream(audioData);
            AudioPlayer.player.start((InputStream)audioStream);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.audioStream != null) {
            AudioPlayer.player.stop((InputStream)this.audioStream);
            this.audioStream = null;
        }
    }

    public static void writeSunAudioHeader(byte[] data, int sampleRate, int datasize) {
        int headersize = 24;
        byte[] byArray = new byte[24];
        byArray[0] = 46;
        byArray[1] = 115;
        byArray[2] = 110;
        byArray[3] = 100;
        byArray[4] = (byte)(headersize >>> 24 & 0xFF);
        byArray[5] = (byte)(headersize >>> 16 & 0xFF);
        byArray[6] = (byte)(headersize >>> 8 & 0xFF);
        byArray[7] = (byte)(headersize & 0xFF);
        byArray[8] = (byte)(datasize >>> 24 & 0xFF);
        byArray[9] = (byte)(datasize >>> 16 & 0xFF);
        byArray[10] = (byte)(datasize >>> 8 & 0xFF);
        byArray[11] = (byte)(datasize & 0xFF);
        byArray[15] = 1;
        byArray[16] = (byte)(sampleRate >>> 24 & 0xFF);
        byArray[17] = (byte)(sampleRate >>> 16 & 0xFF);
        byArray[18] = (byte)(sampleRate >>> 8 & 0xFF);
        byArray[19] = (byte)(sampleRate & 0xFF);
        byArray[23] = 1;
        byte[] header = byArray;
        System.arraycopy(header, 0, data, 0, headersize);
    }
}

