/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.converter;

import java.awt.image.BufferedImage;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.BezierInterpolator;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.SplineInterpolator;
import org.monte.media.converter.ColorAdjustModel;
import org.monte.media.converter.DefaultColorAdjustModel;
import org.monte.media.image.ColorModels;
import org.monte.media.image.Images;

public class ColorAdjustCodec
extends AbstractVideoCodec {
    private ColorAdjustModel model = new DefaultColorAdjustModel();

    public ColorAdjustCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"})}, new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"})});
        this.name = "Adjust Color";
    }

    @Override
    public Format setInputFormat(Format f) {
        Format fNew;
        this.outputFormat = fNew = super.setInputFormat(f);
        return fNew;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        float[] fArray;
        float crShift;
        float cbShift;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        BufferedImage imgIn = (BufferedImage)in.data;
        if (imgIn == null || this.model == null) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        BufferedImage imgOut = null;
        if (out.data instanceof BufferedImage && ((imgOut = (BufferedImage)out.data).getWidth() != imgIn.getWidth() || imgOut.getHeight() != imgIn.getHeight() || imgOut.getType() != 1)) {
            imgOut = null;
        }
        if (imgOut == null) {
            imgOut = new BufferedImage(imgIn.getWidth(), imgIn.getHeight(), 1);
        }
        out.data = imgOut;
        int[] rgbIn = Images.toPixels(imgIn);
        int[] rgbOut = Images.toPixels(imgOut);
        float whitePoint = Math.max(this.model.getWhitePoint(), this.model.getBlackPoint());
        float midPoint = this.model.getMidPoint();
        float blackPoint = Math.min(this.model.getBlackPoint(), this.model.getWhitePoint());
        float invLevelsExtent = 1.0f / (whitePoint - blackPoint);
        if (whitePoint == 1.0f && blackPoint == 0.0f || whitePoint - blackPoint == 0.0f) {
            invLevelsExtent = -1.0f;
        }
        float saturation = this.model.getSaturation() * 2.0f;
        float invsqrt2 = (float)(1.0 / Math.sqrt(2.0));
        boolean TT = this.model.isWhiteBalanceTTEnabled();
        if (TT) {
            cbShift = (-this.model.getTemperature() - this.model.getTint()) * invsqrt2;
            crShift = (this.model.getTemperature() - this.model.getTint()) * invsqrt2;
        } else {
            crShift = 0.0f;
            cbShift = 0.0f;
        }
        SplineInterpolator sint = new SplineInterpolator(0.5f - this.model.getShadows() * 0.5f, 0.5f, 0.5f + this.model.getHighlights() * 0.5f, 0.5f);
        BezierInterpolator hilightsAndShadows = this.model.getShadows() == 0.0f && this.model.getHighlights() == 0.0f ? null : new BezierInterpolator(new double[][]{{0.0, 0.0}, {0.5f - this.model.getShadows() * 0.5f, 0.5}, {0.5, 0.5}, {0.5f + this.model.getHighlights() * 0.5f, 0.5}, {1.0, 1.0}});
        float brightness = this.model.getBrightness();
        float exposure = 1.0f + this.model.getExposure();
        exposure *= exposure;
        float contrast = 1.0f + this.model.getContrast();
        boolean becAdjust = this.model.getBrightness() != 0.0f || this.model.getExposure() != 0.0f || this.model.getContrast() != 0.0f;
        float[] ycc = new float[3];
        float[] rgb = new float[3];
        boolean QM = this.model.isWhiteBalanceQMEnabled();
        if (QM) {
            fArray = this.model.getWhiteBalanceQM();
        } else {
            float[] fArray2 = new float[4];
            fArray2[0] = 0.0f;
            fArray2[1] = 1.0f;
            fArray2[2] = 0.0f;
            fArray = fArray2;
            fArray2[3] = 1.0f;
        }
        float[] wbqm = fArray;
        float rmu = wbqm[0];
        float rnu = wbqm[1];
        float bmu = wbqm[2];
        float bnu = wbqm[3];
        int i = 0;
        while (i < rgbIn.length) {
            int p = rgbIn[i];
            rgb[0] = (p & 0xFF0000) >>> 16;
            rgb[1] = (p & 0xFF00) >> 8;
            rgb[2] = p & 0xFF;
            if (QM) {
                float r = rgb[0];
                float b = rgb[2];
                rgb[0] = r * r * rmu + r * rnu;
                rgb[2] = b * b * bmu + b * bnu;
            }
            rgb[0] = rgb[0] * 0.003921569f;
            rgb[1] = rgb[1] * 0.003921569f;
            rgb[2] = rgb[2] * 0.003921569f;
            if (TT) {
                ColorModels.RGBtoYCC(rgb, ycc);
                ycc[1] = (ycc[1] + cbShift) * saturation;
                ycc[2] = (ycc[2] + crShift) * saturation;
                ColorModels.YCCtoRGB(ycc, rgb);
            }
            if (hilightsAndShadows != null) {
                rgb[0] = hilightsAndShadows.getFraction(rgb[0]);
                rgb[1] = hilightsAndShadows.getFraction(rgb[1]);
                rgb[2] = hilightsAndShadows.getFraction(rgb[2]);
            }
            if (becAdjust) {
                rgb[0] = Math.max(0.0f, Math.min(1.0f, ((rgb[0] - 0.5f) * contrast + 0.5f) * exposure + brightness));
                rgb[1] = Math.max(0.0f, Math.min(1.0f, ((rgb[1] - 0.5f) * contrast + 0.5f) * exposure + brightness));
                rgb[2] = Math.max(0.0f, Math.min(1.0f, ((rgb[2] - 0.5f) * contrast + 0.5f) * exposure + brightness));
            }
            if (invLevelsExtent != -1.0f) {
                rgb[0] = (Math.max(Math.min(rgb[0], whitePoint), blackPoint) - blackPoint) * invLevelsExtent;
                rgb[1] = (Math.max(Math.min(rgb[1], whitePoint), blackPoint) - blackPoint) * invLevelsExtent;
                rgb[2] = (Math.max(Math.min(rgb[2], whitePoint), blackPoint) - blackPoint) * invLevelsExtent;
            }
            rgbOut[i] = (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f) << 0;
            ++i;
        }
        return 0;
    }

    public ColorAdjustModel getModel() {
        return this.model;
    }

    public void setModel(ColorAdjustModel newValue) {
        this.model = newValue;
    }
}

