/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.avi.AbstractAVIStream;
import org.monte.media.math.Rational;
import org.monte.media.riff.RIFFChunk;
import org.monte.media.riff.RIFFParser;

public class AVIOutputStream
extends AbstractAVIStream {
    protected States state = States.FINISHED;
    protected AbstractAVIStream.CompositeChunk aviChunk;
    protected AbstractAVIStream.CompositeChunk moviChunk;
    protected AbstractAVIStream.FixedSizeDataChunk avihChunk;
    ArrayList<AbstractAVIStream.Sample> idx1 = new ArrayList();

    public AVIOutputStream(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.streamOffset = 0L;
    }

    public AVIOutputStream(ImageOutputStream out) throws IOException {
        this.out = out;
        this.streamOffset = out.getStreamPosition();
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    public int addVideoTrack(String fccHandler, long scale, long rate, int width, int height, int depth, int syncInterval) throws IOException {
        this.ensureFinished();
        if (fccHandler == null || fccHandler.length() != 4) {
            throw new IllegalArgumentException("fccHandler must be 4 characters long:" + fccHandler);
        }
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream)this.new AbstractAVIStream.VideoTrack(this.tracks.size(), AVIOutputStream.typeToInt(fccHandler), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, fccHandler, VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height, VideoFormatKeys.DepthKey, depth, VideoFormatKeys.FixedFrameRateKey, true, FormatKeys.FrameRateKey, new Rational(rate, scale)}));
        vt.scale = scale;
        vt.rate = rate;
        vt.syncInterval = syncInterval;
        vt.frameLeft = 0;
        vt.frameTop = 0;
        vt.frameRight = width;
        vt.frameBottom = height;
        vt.bitCount = depth;
        vt.planes = 1;
        if (depth == 4) {
            byte[] gray = new byte[16];
            int i = 0;
            while (i < gray.length) {
                gray[i] = (byte)(i << 4 | i);
                ++i;
            }
            vt.palette = new IndexColorModel(4, 16, gray, gray, gray);
        } else if (depth == 8) {
            byte[] gray = new byte[256];
            int i = 0;
            while (i < gray.length) {
                gray[i] = (byte)i;
                ++i;
            }
            vt.palette = new IndexColorModel(8, 256, gray, gray, gray);
        }
        this.tracks.add(vt);
        return this.tracks.size() - 1;
    }

    public int addAudioTrack(int waveFormatTag, long scale, long rate, int numberOfChannels, int sampleSizeInBits, boolean isCompressed, int frameDuration, int frameSize) throws IOException {
        this.ensureFinished();
        if (scale < 1L || scale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + scale);
        }
        if (numberOfChannels != 1 && numberOfChannels != 2) {
            throw new IllegalArgumentException("numberOfChannels must be 1 or 2: " + numberOfChannels);
        }
        if (sampleSizeInBits != 8 && sampleSizeInBits != 16) {
            throw new IllegalArgumentException("sampleSize must be 8 or 16: " + numberOfChannels);
        }
        AbstractAVIStream.AudioTrack t = new AbstractAVIStream.AudioTrack(this.tracks.size(), AVIOutputStream.typeToInt("\u0000\u0000\u0000\u0000"));
        t.wFormatTag = waveFormatTag;
        float afSampleRate = (float)rate / (float)scale;
        t.format = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, RIFFParser.idToString(waveFormatTag), AudioFormatKeys.SampleRateKey, Rational.valueOf(afSampleRate), AudioFormatKeys.SampleSizeInBitsKey, sampleSizeInBits, AudioFormatKeys.ChannelsKey, numberOfChannels, AudioFormatKeys.FrameSizeKey, frameSize, FormatKeys.FrameRateKey, Rational.valueOf(afSampleRate), AudioFormatKeys.SignedKey, sampleSizeInBits != 8, AudioFormatKeys.ByteOrderKey, ByteOrder.LITTLE_ENDIAN});
        t.scale = scale;
        t.rate = rate;
        t.samplesPerSec = rate / scale;
        t.channels = numberOfChannels;
        t.avgBytesPerSec = t.samplesPerSec * (long)frameSize;
        t.blockAlign = t.channels * sampleSizeInBits / 8;
        t.bitsPerSample = sampleSizeInBits;
        this.tracks.add(t);
        return this.tracks.size() - 1;
    }

    public void setPalette(int track, ColorModel palette) {
        if (palette instanceof IndexColorModel) {
            ((AbstractAVIStream.VideoTrack)this.tracks.get((int)track)).palette = (IndexColorModel)palette;
        }
    }

    public Dimension getVideoDimension(int track) {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        if (tr instanceof AbstractAVIStream.VideoTrack) {
            AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)tr;
            Format fmt = vt.format;
            return new Dimension(fmt.get(VideoFormatKeys.WidthKey), fmt.get(VideoFormatKeys.HeightKey));
        }
        return new Dimension(0, 0);
    }

    public void putExtraHeader(int track, String fourcc, byte[] data) throws IOException {
        if (this.state == States.STARTED) {
            throw new IllegalStateException("Stream headers have already been written!");
        }
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        int id = RIFFParser.stringToID(fourcc);
        int i = tr.extraHeaders.size() - 1;
        while (i >= 0) {
            if (tr.extraHeaders.get(i).getID() == id) {
                tr.extraHeaders.remove(i);
            }
            --i;
        }
        RIFFChunk chunk = new RIFFChunk(1937011304, id, data.length, -1L);
        chunk.setData(data);
        tr.extraHeaders.add(chunk);
    }

    public String[] getExtraHeaderFourCCs(int track) throws IOException {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        String[] fourccs = new String[tr.extraHeaders.size()];
        int i = 0;
        while (i < fourccs.length) {
            fourccs[i] = RIFFParser.idToString(tr.extraHeaders.get(i).getID());
            ++i;
        }
        return fourccs;
    }

    public void setName(int track, String name) {
        ((AbstractAVIStream.Track)this.tracks.get((int)track)).name = name;
    }

    public void setCompressionQuality(int track, float newValue) {
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.tracks.get(track);
        vt.videoQuality = newValue;
    }

    public float getCompressionQuality(int track) {
        return ((AbstractAVIStream.VideoTrack)this.tracks.get((int)track)).videoQuality;
    }

    protected void ensureStarted() throws IOException {
        if (this.state != States.STARTED) {
            this.writeProlog();
            this.state = States.STARTED;
        }
    }

    protected void ensureFinished() throws IOException {
        if (this.state != States.FINISHED) {
            throw new IllegalStateException("Writer is in illegal state for this operation.");
        }
    }

    public void writePalette(int track, byte[] data, int off, int len, boolean isKeyframe) throws IOException {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        if (!(tr instanceof AbstractAVIStream.VideoTrack)) {
            throw new IllegalArgumentException("Error: track " + track + " is not a video track.");
        }
        if (!isKeyframe && tr.samples.isEmpty()) {
            throw new IllegalStateException("The first sample in a track must be a keyframe.");
        }
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)tr;
        tr.flags |= 0x10000;
        AbstractAVIStream.DataChunk paletteChangeChunk = new AbstractAVIStream.DataChunk(vt.twoCC | 0x7063);
        long offset = this.getRelativeStreamPosition();
        ImageOutputStream pOut = paletteChangeChunk.getOutputStream();
        pOut.write(data, off, len);
        this.moviChunk.add(paletteChangeChunk);
        paletteChangeChunk.finish();
        long length = this.getRelativeStreamPosition() - offset;
        AbstractAVIStream.Sample s = new AbstractAVIStream.Sample(paletteChangeChunk.chunkType, 0, offset, length, isKeyframe);
        tr.addSample(s);
        this.idx1.add(s);
        offset = this.getRelativeStreamPosition();
    }

    public void writeSample(int track, File file, boolean isKeyframe) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.writeSample(track, in, isKeyframe);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void writeSample(int track, InputStream in, boolean isKeyframe) throws IOException {
        int len;
        this.ensureStarted();
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        if (!isKeyframe && tr.samples.isEmpty()) {
            throw new IllegalStateException("The first sample in a track must be a keyframe.");
        }
        if (isKeyframe && (tr.flags & 0x10000) != 0) {
            if (tr.samples.size() > 0) {
                AbstractAVIStream.Sample s = tr.samples.get(tr.samples.size() - 1);
                if ((s.chunkType & 0xFFFF) == 28771) {
                    s.isKeyframe = true;
                }
            }
            isKeyframe = false;
        }
        AbstractAVIStream.DataChunk dc = new AbstractAVIStream.DataChunk(tr.getSampleChunkFourCC(isKeyframe));
        this.moviChunk.add(dc);
        ImageOutputStream mdatOut = dc.getOutputStream();
        long offset = this.getRelativeStreamPosition();
        byte[] buf = new byte[512];
        while ((len = in.read(buf)) != -1) {
            mdatOut.write(buf, 0, len);
        }
        long length = this.getRelativeStreamPosition() - offset;
        dc.finish();
        AbstractAVIStream.Sample s = new AbstractAVIStream.Sample(dc.chunkType, 1, offset, length, isKeyframe);
        tr.addSample(s);
        this.idx1.add(s);
        ++tr.length;
        if (this.getRelativeStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    public void writeSample(int track, byte[] data, int off, int len, boolean isKeyframe) throws IOException {
        this.ensureStarted();
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        if (!isKeyframe && tr.samples.isEmpty()) {
            throw new IllegalStateException("The first sample in a track must be a keyframe.\nTrack=" + track + ", " + tr.format);
        }
        if (isKeyframe && (tr.flags & 0x10000) != 0) {
            throw new IllegalStateException("Only palette changes can be marked as keyframe.\nTrack=" + track + ", " + tr.format);
        }
        AbstractAVIStream.DataChunk dc = new AbstractAVIStream.DataChunk(tr.getSampleChunkFourCC(isKeyframe), len);
        this.moviChunk.add(dc);
        ImageOutputStream mdatOut = dc.getOutputStream();
        long offset = this.getRelativeStreamPosition();
        mdatOut.write(data, off, len);
        long length = this.getRelativeStreamPosition() - offset;
        dc.finish();
        AbstractAVIStream.Sample s = new AbstractAVIStream.Sample(dc.chunkType, 1, offset, length, isKeyframe);
        tr.addSample(s);
        this.idx1.add(s);
        if (this.getRelativeStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, boolean isKeyframe) throws IOException {
        this.ensureStarted();
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        if (tr.mediaType == AbstractAVIStream.AVIMediaType.AUDIO) {
            AbstractAVIStream.DataChunk dc = new AbstractAVIStream.DataChunk(tr.getSampleChunkFourCC(isKeyframe), len);
            this.moviChunk.add(dc);
            ImageOutputStream mdatOut = dc.getOutputStream();
            long offset = this.getRelativeStreamPosition();
            mdatOut.write(data, off, len);
            long length = this.getRelativeStreamPosition() - offset;
            dc.finish();
            AbstractAVIStream.Sample s = new AbstractAVIStream.Sample(dc.chunkType, sampleCount, offset, length, isKeyframe | tr.samples.isEmpty());
            tr.addSample(s);
            this.idx1.add(s);
            tr.length += (long)sampleCount;
            if (this.getRelativeStreamPosition() > 0x100000000L) {
                throw new IOException("AVI file is larger than 4 GB");
            }
        } else {
            int i = 0;
            while (i < sampleCount) {
                this.writeSample(track, data, off, len / sampleCount, isKeyframe);
                off += len / sampleCount;
                ++i;
            }
        }
    }

    public long getMediaDuration(int track) {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        long duration = tr.startTime;
        if (!tr.samples.isEmpty()) {
            AbstractAVIStream.Sample s = tr.samples.get(tr.samples.size() - 1);
            duration += s.timeStamp + (long)s.duration;
        }
        return duration;
    }

    public void close() throws IOException {
        if (this.state == States.STARTED) {
            this.finish();
        }
        if (this.state != States.CLOSED) {
            this.out.close();
            this.state = States.CLOSED;
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != States.FINISHED) {
            this.moviChunk.finish();
            this.writeEpilog();
            this.state = States.FINISHED;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state == States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    public boolean isDataLimitReached() {
        try {
            return this.getRelativeStreamPosition() > 0x73333333L;
        }
        catch (IOException ex) {
            return true;
        }
    }

    private void writeProlog() throws IOException {
        this.aviChunk = new AbstractAVIStream.CompositeChunk(1380533830, 1096173856);
        AbstractAVIStream.CompositeChunk hdrlChunk = new AbstractAVIStream.CompositeChunk(1279873876, 1751413356);
        this.aviChunk.add(hdrlChunk);
        this.avihChunk = new AbstractAVIStream.FixedSizeDataChunk(1635150184, 56L);
        this.avihChunk.seekToEndOfChunk();
        hdrlChunk.add(this.avihChunk);
        for (AbstractAVIStream.Track tr : this.tracks) {
            AbstractAVIStream.CompositeChunk strlChunk = new AbstractAVIStream.CompositeChunk(1279873876, 1937011308);
            hdrlChunk.add(strlChunk);
            tr.strhChunk = new AbstractAVIStream.FixedSizeDataChunk(1937011304, 56L);
            tr.strhChunk.seekToEndOfChunk();
            strlChunk.add(tr.strhChunk);
            tr.strfChunk = new AbstractAVIStream.FixedSizeDataChunk(1937011302, tr.getSTRFChunkSize());
            tr.strfChunk.seekToEndOfChunk();
            strlChunk.add(tr.strfChunk);
            for (RIFFChunk c : tr.extraHeaders) {
                AbstractAVIStream.DataChunk d = new AbstractAVIStream.DataChunk(c.getID(), c.getSize());
                ImageOutputStream dout = d.getOutputStream();
                dout.write(c.getData());
                d.finish();
                strlChunk.add(d);
            }
            if (tr.name == null) continue;
            byte[] data = (String.valueOf(tr.name) + "\u0000").getBytes("ASCII");
            AbstractAVIStream.DataChunk d = new AbstractAVIStream.DataChunk(1937011310, data.length);
            ImageOutputStream dout = d.getOutputStream();
            dout.write(data);
            d.finish();
            strlChunk.add(d);
        }
        this.moviChunk = new AbstractAVIStream.CompositeChunk(1279873876, 1836021353);
        this.aviChunk.add(this.moviChunk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeEpilog() throws IOException {
        AbstractAVIStream.DataChunk idx1Chunk = new AbstractAVIStream.DataChunk(1768192049);
        this.aviChunk.add(idx1Chunk);
        ImageOutputStream d = idx1Chunk.getOutputStream();
        long moviListOffset = this.moviChunk.offset + 8L + 8L;
        double movieTime = 0.0;
        int nTracks = this.tracks.size();
        int[] trackSampleIndex = new int[nTracks];
        long[] trackSampleCount = new long[nTracks];
        for (AbstractAVIStream.Sample s : this.idx1) {
            d.setByteOrder(ByteOrder.BIG_ENDIAN);
            d.writeInt(s.chunkType);
            d.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            d.writeInt(((s.chunkType & 0xFFFF) == 28771 ? 256 : 0) | (s.isKeyframe ? 16 : 0));
            d.writeInt((int)(s.offset - moviListOffset));
            d.writeInt((int)s.length);
        }
        idx1Chunk.finish();
        this.avihChunk.seekToStartOfData();
        d = this.avihChunk.getOutputStream();
        long largestBufferSize = 0L;
        long duration = 0L;
        for (AbstractAVIStream.Track tr : this.tracks) {
            long trackDuration = 0L;
            for (AbstractAVIStream.Sample s : tr.samples) {
                trackDuration += (long)s.duration;
            }
            duration = Math.max(duration, trackDuration);
            for (AbstractAVIStream.Sample s : tr.samples) {
                if (s.length <= largestBufferSize) continue;
                largestBufferSize = s.length;
            }
        }
        AbstractAVIStream.Track tt = (AbstractAVIStream.Track)this.tracks.get(0);
        d.writeInt((int)(1000000L * tt.scale / tt.rate));
        d.writeInt((int)largestBufferSize);
        d.writeInt(0);
        d.writeInt(2320);
        d.writeInt(tt.samples.size());
        d.writeInt(0);
        d.writeInt(this.tracks.size());
        d.writeInt((int)largestBufferSize);
        Object vt = null;
        int width = 0;
        int height = 0;
        for (AbstractAVIStream.Track tr : this.tracks) {
            width = Math.max(width, Math.max(tr.frameLeft, tr.frameRight));
            height = Math.max(height, Math.max(tr.frameTop, tr.frameBottom));
        }
        d.writeInt(width);
        d.writeInt(height);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        for (AbstractAVIStream.Track tr : this.tracks) {
            tr.strhChunk.seekToStartOfData();
            d = tr.strhChunk.getOutputStream();
            d.setByteOrder(ByteOrder.BIG_ENDIAN);
            d.writeInt(AVIOutputStream.typeToInt(tr.mediaType.fccType));
            d.writeInt(tr.fccHandler);
            d.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            d.writeInt(tr.flags);
            d.writeShort(tr.priority);
            d.writeShort(tr.language);
            d.writeInt((int)tr.initialFrames);
            d.writeInt((int)tr.scale);
            d.writeInt((int)tr.rate);
            d.writeInt((int)tr.startTime);
            d.writeInt((int)tr.length);
            long dwSuggestedBufferSize = 0L;
            long dwSampleSize = -1L;
            for (AbstractAVIStream.Sample s : tr.samples) {
                if (s.length > dwSuggestedBufferSize) {
                    dwSuggestedBufferSize = s.length;
                }
                if (dwSampleSize == -1L) {
                    dwSampleSize = s.length;
                    continue;
                }
                if (dwSampleSize == s.length) continue;
                dwSampleSize = 0L;
            }
            if (dwSampleSize == -1L) {
                dwSampleSize = 0L;
            }
            d.writeInt((int)dwSuggestedBufferSize);
            d.writeInt(tr.quality);
            d.writeInt(tr instanceof AbstractAVIStream.AudioTrack ? ((AbstractAVIStream.AudioTrack)tr).blockAlign : (int)dwSampleSize);
            d.writeShort(tr.frameLeft);
            d.writeShort(tr.frameTop);
            d.writeShort(tr.frameRight);
            d.writeShort(tr.frameBottom);
            if (tr instanceof AbstractAVIStream.VideoTrack) {
                AbstractAVIStream.VideoTrack vt2 = (AbstractAVIStream.VideoTrack)tr;
                Format vf = tr.format;
                tr.strfChunk.seekToStartOfData();
                d = tr.strfChunk.getOutputStream();
                d.writeInt(40);
                d.writeInt(vf.get(VideoFormatKeys.WidthKey));
                d.writeInt(vf.get(VideoFormatKeys.HeightKey));
                d.writeShort(1);
                d.writeShort(vf.get(VideoFormatKeys.DepthKey));
                String enc = vf.get(FormatKeys.EncodingKey);
                if (enc.equals("DIB ")) {
                    d.writeInt(0);
                } else if (enc.equals("RLE ")) {
                    if (vf.get(VideoFormatKeys.DepthKey) == 8) {
                        d.writeInt(1);
                    } else {
                        if (vf.get(VideoFormatKeys.DepthKey) != 4) throw new UnsupportedOperationException("RLE only supports 4-bit and 8-bit images");
                        d.writeInt(2);
                    }
                } else {
                    d.setByteOrder(ByteOrder.BIG_ENDIAN);
                    d.writeInt(AVIOutputStream.typeToInt(vt2.format.get(FormatKeys.EncodingKey)));
                    d.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                }
                if (enc.equals("DIB ")) {
                    d.writeInt(0);
                } else if (vf.get(VideoFormatKeys.DepthKey) == 4) {
                    d.writeInt(vf.get(VideoFormatKeys.WidthKey) * vf.get(VideoFormatKeys.HeightKey) / 2);
                } else {
                    int bytesPerPixel = Math.max(1, vf.get(VideoFormatKeys.DepthKey) / 8);
                    d.writeInt(vf.get(VideoFormatKeys.WidthKey) * vf.get(VideoFormatKeys.HeightKey) * bytesPerPixel);
                }
                d.writeInt(0);
                d.writeInt(0);
                d.writeInt(vt2.palette == null ? 0 : vt2.palette.getMapSize());
                d.writeInt(0);
                if (vt2.palette == null) continue;
                int i = 0;
                int n = vt2.palette.getMapSize();
                while (i < n) {
                    d.write(vt2.palette.getBlue(i));
                    d.write(vt2.palette.getGreen(i));
                    d.write(vt2.palette.getRed(i));
                    d.write(0);
                    ++i;
                }
                continue;
            }
            if (!(tr instanceof AbstractAVIStream.AudioTrack)) continue;
            AbstractAVIStream.AudioTrack at = (AbstractAVIStream.AudioTrack)tr;
            tr.strfChunk.seekToStartOfData();
            d = tr.strfChunk.getOutputStream();
            d.writeShort(at.wFormatTag);
            d.writeShort(at.channels);
            d.writeInt((int)at.samplesPerSec);
            d.writeInt((int)at.avgBytesPerSec);
            d.writeShort(at.blockAlign);
            d.writeShort(at.bitsPerSample);
            d.writeShort(0);
        }
        this.aviChunk.finish();
    }

    protected static enum States {
        STARTED,
        FINISHED,
        CLOSED;

    }
}

