/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;

public class DefaultRegistry
extends Registry {
    private HashMap<String, LinkedList<RegistryEntry>> codecMap;
    private HashMap<String, LinkedList<RegistryEntry>> readerMap;
    private HashMap<String, LinkedList<RegistryEntry>> writerMap;
    private HashMap<String, Format> fileFormatMap;

    @Override
    public Format[] getReaderFormats() {
        return this.getFileFormats();
    }

    @Override
    public Format[] getWriterFormats() {
        return this.getFileFormats();
    }

    @Override
    public Format[] getFileFormats() {
        return this.fileFormatMap.values().toArray(new Format[this.fileFormatMap.size()]);
    }

    @Override
    protected void init() {
        this.codecMap = new HashMap();
        this.readerMap = new HashMap();
        this.writerMap = new HashMap();
        this.fileFormatMap = new HashMap();
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "x-iff/anim", FormatKeys.EncodingKey, "ILBM"}), "org.monte.media.anim.BitmapCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "DIB "}), "org.monte.media.avi.DIBCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "MJPG"}), "org.monte.media.jpeg.JPEGCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "png "}), "org.monte.media.png.PNGCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "RLE "}), "org.monte.media.avi.RunLengthCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "tscc"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), "org.monte.media.avi.TechSmithCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "ZMBV"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), "org.monte.media.avi.ZMBVCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "\u0000\u0000\u0000\u0001"}), "org.monte.media.avi.AVIPCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "\u0000\u0000\u0000\u0001"}), "org.monte.media.avi.AVIPCMAudioCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "raw "}), "org.monte.media.quicktime.RawCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "rle "}), "org.monte.media.quicktime.AnimationCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "jpeg"}), "org.monte.media.jpeg.JPEGCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "MJPG"}), "org.monte.media.jpeg.JPEGCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "png "}), "org.monte.media.png.PNGCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), "org.monte.media.avi.TechSmithCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "twos"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "twos"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "sowt"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "sowt"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "in24"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "in24"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "in32"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "in32"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "raw "}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "raw "}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putReader(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/avi"}), "org.monte.media.avi.AVIReader");
        this.putReader(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"}), "org.monte.media.quicktime.QuickTimeReader");
        this.putReader(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "x-iff/anim"}), "org.monte.media.anim.ANIMReader");
        this.putWriter(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/avi"}), "org.monte.media.avi.AVIWriter");
        this.putWriter(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"}), "org.monte.media.quicktime.QuickTimeWriter");
        this.putWriter(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "x-iff/anim"}), "org.monte.media.anim.ANIMWriter");
        this.putFileFormat("avi", new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/avi"}));
        this.putFileFormat("mov", new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"}));
        this.putFileFormat("anim", new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "x-iff/anim"}));
    }

    public void putBidiCodec(Format inputFormat, Format outputFormat, String codecClass) {
        this.putCodec(inputFormat, outputFormat, codecClass);
        this.putCodec(outputFormat, inputFormat, codecClass);
    }

    @Override
    public void putCodec(Format inputFormat, Format outputFormat, String codecClass) {
        RegistryEntry entry = new RegistryEntry(inputFormat, outputFormat, codecClass);
        this.addCodecEntry(inputFormat.get(FormatKeys.EncodingKey), entry);
        this.addCodecEntry(outputFormat.get(FormatKeys.EncodingKey), entry);
    }

    private void addCodecEntry(String key, RegistryEntry entry) {
        LinkedList<RegistryEntry> list = this.codecMap.get(key);
        if (list == null) {
            list = new LinkedList();
            this.codecMap.put(key, list);
        }
        list.add(entry);
    }

    @Override
    public void putReader(Format fileFormat, String readerClass) {
        RegistryEntry entry = new RegistryEntry(null, fileFormat, readerClass);
        String key = fileFormat.get(FormatKeys.MimeTypeKey);
        LinkedList<RegistryEntry> list = this.readerMap.get(key);
        if (list == null) {
            list = new LinkedList();
            this.readerMap.put(key, list);
        }
        list.add(entry);
    }

    @Override
    public void putWriter(Format fileFormat, String writerClass) {
        RegistryEntry entry = new RegistryEntry(fileFormat, null, writerClass);
        String key = fileFormat.get(FormatKeys.MimeTypeKey);
        LinkedList<RegistryEntry> list = this.writerMap.get(key);
        if (list == null) {
            list = new LinkedList();
            this.writerMap.put(key, list);
        }
        list.add(entry);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getCodecClasses(Format inputFormat, Format outputFormat) {
        HashSet<String> classNames = new HashSet<String>();
        HashSet entries = new HashSet();
        if (inputFormat != null) {
            void var5_7;
            if (inputFormat.get(FormatKeys.EncodingKey) == null) {
                LinkedList<RegistryEntry> linkedList = new LinkedList<RegistryEntry>();
                for (Map.Entry<String, LinkedList<RegistryEntry>> i : this.codecMap.entrySet()) {
                    for (RegistryEntry j : i.getValue()) {
                        if (!inputFormat.matches(j.inputFormat)) continue;
                        linkedList.add(j);
                    }
                }
            } else {
                LinkedList<RegistryEntry> linkedList = this.codecMap.get(inputFormat.get(FormatKeys.EncodingKey));
            }
            if (var5_7 != null) {
                entries.addAll(var5_7);
            }
        }
        if (outputFormat != null) {
            void var5_10;
            if (outputFormat.get(FormatKeys.EncodingKey) == null) {
                LinkedList<RegistryEntry> linkedList = new LinkedList<RegistryEntry>();
                for (Map.Entry<String, LinkedList<RegistryEntry>> i : this.codecMap.entrySet()) {
                    for (RegistryEntry j : i.getValue()) {
                        if (!outputFormat.matches(j.outputFormat)) continue;
                        linkedList.add(j);
                    }
                }
            } else {
                LinkedList<RegistryEntry> linkedList = this.codecMap.get(outputFormat.get(FormatKeys.EncodingKey));
            }
            if (var5_10 != null) {
                entries.addAll(var5_10);
            }
        }
        for (RegistryEntry registryEntry : entries) {
            if (inputFormat != null && registryEntry.inputFormat != null && !inputFormat.matches(registryEntry.inputFormat) || outputFormat != null && registryEntry.outputFormat != null && !outputFormat.matches(registryEntry.outputFormat)) continue;
            classNames.add(registryEntry.className);
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    @Override
    public String[] getReaderClasses(Format fileFormat) {
        LinkedList<RegistryEntry> rr = this.readerMap.get(fileFormat.get(FormatKeys.MimeTypeKey));
        String[] names = new String[rr == null ? 0 : rr.size()];
        if (rr != null) {
            int i = 0;
            for (RegistryEntry e : rr) {
                names[i++] = e.className;
            }
        }
        return names;
    }

    @Override
    public Format getFileFormat(File file) {
        String ext = file.getName();
        int p = ext.lastIndexOf(46);
        if (p != -1) {
            ext = ext.substring(p + 1);
        }
        ext = ext.toLowerCase();
        return this.fileFormatMap.get(ext);
    }

    @Override
    public String[] getWriterClasses(Format fileFormat) {
        LinkedList<RegistryEntry> rr = this.writerMap.get(fileFormat.get(FormatKeys.MimeTypeKey));
        String[] names = new String[rr == null ? 0 : rr.size()];
        if (rr != null) {
            int i = 0;
            for (RegistryEntry e : rr) {
                names[i++] = e.className;
            }
        }
        return names;
    }

    @Override
    public void putFileFormat(String extension, Format format) {
        this.fileFormatMap.put(extension.toLowerCase(), format);
    }

    @Override
    public String getExtension(Format ff) {
        for (Map.Entry<String, Format> e : this.fileFormatMap.entrySet()) {
            if (!e.getValue().get(FormatKeys.MimeTypeKey).equals(ff.get(FormatKeys.MimeTypeKey))) continue;
            return e.getKey();
        }
        return "";
    }

    @Override
    public void unregisterCodec(String codecClass) {
        for (Map.Entry<String, LinkedList<RegistryEntry>> i : this.codecMap.entrySet()) {
            LinkedList<RegistryEntry> ll = i.getValue();
            Iterator j = ll.iterator();
            while (j.hasNext()) {
                RegistryEntry e = (RegistryEntry)j.next();
                if (!e.className.equals(codecClass)) continue;
                j.remove();
            }
        }
    }

    private static class RegistryEntry {
        Format inputFormat;
        Format outputFormat;
        String className;

        public RegistryEntry(Format inputFormat, Format outputFormat, String className) {
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
            this.className = className;
        }
    }
}

