/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Comparator;
import org.monte.media.Interpolator;

public abstract class AbstractSplineInterpolator
extends Interpolator {
    private LengthItem[] fractions;
    private static FractionComparator fractionComparator = new FractionComparator();

    public AbstractSplineInterpolator() {
        this(0.0f, 1.0f);
    }

    public AbstractSplineInterpolator(long timespan) {
        this(0.0f, 1.0f, timespan);
    }

    public AbstractSplineInterpolator(boolean reverse) {
        this(reverse ? 1.0f : 0.0f, reverse ? 0.0f : 1.0f);
    }

    public AbstractSplineInterpolator(float startValue, float endValue) {
        this(startValue, endValue, 1000L);
    }

    public AbstractSplineInterpolator(float startValue, float endValue, long timespan) {
        super(startValue, endValue, timespan);
    }

    protected void updateFractions(int N) {
        this.fractions = new LengthItem[N];
        Point2D.Float p = new Point2D.Float();
        int i = 0;
        while (i < N) {
            float t = (float)i / (float)(N - 1);
            this.fractions[i] = new LengthItem(this.getXY(t, p), t);
            ++i;
        }
    }

    @Override
    public final float getFraction(float t) {
        LengthItem p1 = new LengthItem(t, 0.0f, t);
        LengthItem p2 = new LengthItem(t, 0.0f, t);
        int index = Arrays.binarySearch(this.fractions, p1, fractionComparator);
        if (index >= 0) {
            return this.fractions[index].y;
        }
        if ((index = -1 - index) == this.fractions.length) {
            return this.fractions[this.fractions.length - 1].y;
        }
        if (index == 0) {
            return this.fractions[0].y;
        }
        p1 = this.fractions[Math.max(0, index - 1)];
        p2 = this.fractions[Math.min(this.fractions.length - 1, index)];
        float weight = (p2.x - t) / (p2.x - p1.x);
        float s = p1.t * weight + p2.t * (1.0f - weight);
        return this.getY(s);
    }

    protected abstract Point2D.Float getXY(float var1, Point2D.Float var2);

    protected abstract float getY(float var1);

    @Override
    protected void update(float fraction) {
    }

    private static class FractionComparator
    implements Comparator<LengthItem> {
        private FractionComparator() {
        }

        @Override
        public int compare(LengthItem o1, LengthItem o2) {
            if (o1.x > o2.x) {
                return 1;
            }
            if (o1.x < o2.x) {
                return -1;
            }
            return 0;
        }
    }

    private static class LengthItem {
        public float x;
        public float y;
        public float t;

        public LengthItem(float x, float y, float t) {
            this.x = x;
            this.y = y;
            this.t = t;
        }

        public LengthItem(Point2D.Float p, float t) {
            this.x = p.x;
            this.y = p.y;
            this.t = t;
        }

        public String toString() {
            return "LengthItem{x=" + this.x + ", y=" + this.y + ", t=" + this.t + '}';
        }
    }
}

