/*
 * Decompiled with CFR 0.152.
 */
package org.monte.iodemo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Codec;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.MovieReader;
import org.monte.media.MovieWriter;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;
import org.monte.media.image.Images;
import org.monte.media.math.Rational;

public class ReadWriteDemoMain {
    public static void main(String[] args) {
        try {
            HashSet<String> usedFilenames = new HashSet<String>();
            Codec[] codecArray = Registry.getInstance().getEncoders(new Format(new Object[]{FormatKeys.MimeTypeKey, "video/avi", FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO}));
            int n = codecArray.length;
            int n2 = 0;
            while (n2 < n) {
                Codec c = codecArray[n2];
                Format[] formatArray = c.getOutputFormats(new Format(VideoFormatKeys.DataClassKey, BufferedImage.class));
                int n3 = formatArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Format f = formatArray[n4];
                    if (f.get(FormatKeys.MimeTypeKey) == "video/avi") {
                        String filename = "montemedia-" + f.get(FormatKeys.EncodingKey).trim() + f.get(VideoFormatKeys.DepthKey) + ".avi";
                        String filename2 = "montemedia-" + f.get(FormatKeys.EncodingKey).trim() + f.get(VideoFormatKeys.DepthKey) + "(2).avi";
                        if (usedFilenames.add(filename)) {
                            ReadWriteDemoMain.test(new File(filename), new File(filename2), f);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void test(File file, File file2, Format format) throws IOException {
        ReadWriteDemoMain.testWriting(file, format);
        try {
            ReadWriteDemoMain.testReading(file);
            BufferedImage[] frames = ReadWriteDemoMain.readMovie(file);
            ReadWriteDemoMain.writeMovie(file2, frames);
        }
        catch (UnsupportedOperationException e) {
            System.out.println(e);
        }
    }

    private static void testWriting(File file, Format format) throws IOException {
        System.out.println("Writing " + file);
        format = format.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.FrameRateKey, new Rational(30L, 1L), VideoFormatKeys.WidthKey, 320, VideoFormatKeys.HeightKey, 160});
        BufferedImage img = ReadWriteDemoMain.createImage(format);
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        MovieWriter out = null;
        try {
            out = Registry.getInstance().getWriter(format, file);
            out.addTrack(format);
            Random rnd = new Random(0L);
            g.setBackground(Color.WHITE);
            g.clearRect(0, 0, img.getWidth(), img.getHeight());
            Buffer buf = new Buffer();
            buf.format = new Format(VideoFormatKeys.DataClassKey, BufferedImage.class);
            buf.sampleDuration = format.get(FormatKeys.FrameRateKey).inverse();
            buf.data = img;
            int i = 0;
            while (i < 100) {
                g.setColor(new Color(rnd.nextInt()));
                g.fillOval(rnd.nextInt(img.getWidth() - 30), rnd.nextInt(img.getHeight() - 30), 30, 30);
                out.write(0, buf);
                ++i;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            g.dispose();
        }
    }

    private static void writeMovie(File file, BufferedImage[] frames) throws IOException {
        MovieWriter out = Registry.getInstance().getWriter(file);
        Format format = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "MJPG", FormatKeys.FrameRateKey, new Rational(30L, 1L), VideoFormatKeys.WidthKey, frames[0].getWidth(), VideoFormatKeys.HeightKey, frames[0].getHeight(), VideoFormatKeys.DepthKey, 24});
        int track = out.addTrack(format);
        try {
            Buffer buf = new Buffer();
            buf.format = new Format(VideoFormatKeys.DataClassKey, BufferedImage.class);
            buf.sampleDuration = format.get(FormatKeys.FrameRateKey).inverse();
            int i = 0;
            while (i < frames.length) {
                buf.data = frames[i];
                out.write(track, buf);
                ++i;
            }
        }
        finally {
            out.close();
        }
    }

    private static BufferedImage[] readMovie(File file) throws IOException {
        ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
        MovieReader in = Registry.getInstance().getReader(file);
        Format format = new Format(VideoFormatKeys.DataClassKey, BufferedImage.class);
        int track = in.findTrack(0, new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO}));
        Codec codec = Registry.getInstance().getCodec(in.getFormat(track), format);
        try {
            Buffer inbuf = new Buffer();
            Buffer codecbuf = new Buffer();
            do {
                in.read(track, inbuf);
                codec.process(inbuf, codecbuf);
                if (codecbuf.isFlag(BufferFlag.DISCARD)) continue;
                frames.add(Images.cloneImage((BufferedImage)codecbuf.data));
            } while (!inbuf.isFlag(BufferFlag.END_OF_MEDIA));
        }
        finally {
            in.close();
        }
        return frames.toArray(new BufferedImage[frames.size()]);
    }

    private static void testReading(File file) throws IOException {
        System.out.println("Reading " + file);
        MovieReader in = null;
        try {
            in = Registry.getInstance().getReader(file);
            int track = 0;
            while (track < in.getTrackCount() && in.getFormat(track).get(FormatKeys.MediaTypeKey) != FormatKeys.MediaType.VIDEO) {
                ++track;
            }
            Buffer inputBuffer = new Buffer();
            Buffer codecBuffer = new Buffer();
            Format imageFormat = new Format(VideoFormatKeys.DataClassKey, BufferedImage.class);
            Codec codec = null;
            Object img = null;
            do {
                in.read(track, inputBuffer);
                Buffer imageBuffer = null;
                if (inputBuffer.format.matches(imageFormat)) {
                    imageBuffer = inputBuffer;
                    continue;
                }
                if (codec == null) {
                    codec = Registry.getInstance().getCodec(inputBuffer.format, imageFormat);
                }
                if (codec == null) {
                    throw new UnsupportedOperationException("No Codec for " + inputBuffer.format);
                }
                codec.process(inputBuffer, codecBuffer);
                imageBuffer = codecBuffer;
            } while (img != null);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static BufferedImage createImage(Format format) {
        BufferedImage img;
        int depth = format.get(VideoFormatKeys.DepthKey);
        int width = format.get(VideoFormatKeys.WidthKey);
        int height = format.get(VideoFormatKeys.HeightKey);
        Random rnd = new Random(0L);
        switch (depth) {
            default: {
                img = new BufferedImage(width, height, 1);
                break;
            }
            case 8: {
                byte[] red = new byte[256];
                byte[] green = new byte[256];
                byte[] blue = new byte[256];
                int i = 0;
                while (i < 255) {
                    red[i] = (byte)rnd.nextInt(256);
                    green[i] = (byte)rnd.nextInt(256);
                    blue[i] = (byte)rnd.nextInt(256);
                    ++i;
                }
                rnd.setSeed(0L);
                IndexColorModel palette = new IndexColorModel(8, 256, red, green, blue);
                img = new BufferedImage(width, height, 13, palette);
                break;
            }
            case 4: {
                byte[] red = new byte[16];
                byte[] green = new byte[16];
                byte[] blue = new byte[16];
                int i = 0;
                while (i < 15) {
                    red[i] = (byte)rnd.nextInt(16);
                    green[i] = (byte)rnd.nextInt(16);
                    blue[i] = (byte)rnd.nextInt(16);
                    ++i;
                }
                rnd.setSeed(0L);
                IndexColorModel palette = new IndexColorModel(4, 16, red, green, blue);
                img = new BufferedImage(width, height, 13, palette);
            }
        }
        return img;
    }
}

