/*
 * Decompiled with CFR 0.152.
 */
package org.monte.cmykdemo;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import org.monte.media.jpeg.CMYKJPEGImageReader;
import org.monte.media.jpeg.CMYKJPEGImageReaderSpi;

public class Main
extends JFrame {
    private Handler handler;
    private JLabel imageLabel;
    private JLabel infoLabel;
    private JScrollPane scrollPane;

    public Main() {
        this.initComponents();
        this.setSize(400, 300);
        String version = Main.class.getPackage().getImplementationVersion();
        if (version != null) {
            int p = version.indexOf(32);
            this.setTitle(String.valueOf(this.getTitle()) + " " + version.substring(0, p == -1 ? version.length() : p));
        }
        this.handler = new Handler();
        this.setTransferHandler(this.handler);
        this.imageLabel.setTransferHandler(this.handler);
        this.infoLabel.setTransferHandler(this.handler);
        this.scrollPane.setTransferHandler(this.handler);
        this.scrollPane.getViewport().setTransferHandler(this.handler);
    }

    public void setFile(final File file) {
        this.imageLabel.setIcon(null);
        this.imageLabel.setText("Loading image...");
        new SwingWorker<BufferedImage, BufferedImage>(){

            @Override
            protected BufferedImage doInBackground() throws Exception {
                BufferedImage img = null;
                FileImageInputStream iis = new FileImageInputStream(file);
                try {
                    CMYKJPEGImageReader r = new CMYKJPEGImageReader(new CMYKJPEGImageReaderSpi());
                    r.setInput(iis);
                    img = r.read(0);
                }
                finally {
                    iis.close();
                }
                return img;
            }

            @Override
            protected void done() {
                try {
                    BufferedImage image = (BufferedImage)this.get();
                    if (image == null) {
                        Main.this.imageLabel.setText("Sorry. Couldn't load image.");
                        Main.this.infoLabel.setText(null);
                    } else {
                        Main.this.imageLabel.setIcon(new ImageIcon(image));
                        Main.this.imageLabel.setText(null);
                        Main.this.infoLabel.setText("<html>Image Dimension: " + image.getWidth() + " x " + image.getHeight() + "<br>Color Model: " + image.getColorModel() + "<br>has alpha: " + image.getColorModel().hasAlpha() + " is alpha premultiplied:" + image.getColorModel().isAlphaPremultiplied());
                    }
                }
                catch (Exception ex) {
                    Main.this.imageLabel.setText("Sorry. Couldn't load image.");
                    ex.printStackTrace();
                }
                super.done();
            }
        }.execute();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.imageLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("MonteMedia CMYK Demo");
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setText("Drop CMYK image here");
        this.scrollPane.setViewportView(this.imageLabel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.infoLabel.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add((Component)this.infoLabel, "Last");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Main().setVisible(true);
            }
        });
    }

    private class Handler
    extends TransferHandler {
        private Handler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            try {
                List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (files.size() == 1) {
                    Main.this.setFile((File)files.get(0));
                }
                return true;
            }
            catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return false;
        }
    }
}

