/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry.butterflies;

import codechicken.nei.api.API;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterflyRoot;
import java.util.Collection;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticItemFilter;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.forestry.butterflies.ButterflyBreedingHandler;

public class ButterflyHelper {
    public static Collection<IAlleleButterflySpecies> allSpecies;
    public static IButterflyRoot root;

    public static void setup() {
        root = (IButterflyRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
        allSpecies = GeneticsUtils.getAllButterflySpecies(AddonForestry.loadBlacklisted);
        if (AddonForestry.showButterflyMutations) {
            ButterflyBreedingHandler breedingRecipeHandler = new ButterflyBreedingHandler();
            API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
            API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        }
        for (IAlleleButterflySpecies species : allSpecies) {
            if (!AddonForestry.addBees) continue;
            Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumFlutterType.BUTTERFLY.ordinal()));
            Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumFlutterType.CATERPILLAR.ordinal()));
            Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumFlutterType.SERUM.ordinal()));
        }
        API.addSubset((String)"Forestry.Butterflies.Butterflies", (ItemFilter)new GeneticItemFilter((ISpeciesRoot)root, EnumFlutterType.BUTTERFLY.ordinal(), true));
        API.addSubset((String)"Forestry.Butterflies.Caterpillars", (ItemFilter)new GeneticItemFilter((ISpeciesRoot)root, EnumFlutterType.CATERPILLAR.ordinal(), true));
        API.addSubset((String)"Forestry.Butterflies.Serums", (ItemFilter)new GeneticItemFilter((ISpeciesRoot)root, EnumFlutterType.SERUM.ordinal(), true));
    }
}

