/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.botany.flowers;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Collection;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.botany.AddonBotany;
import net.bdew.neiaddons.botany.flowers.FlowerBreedingHandler;
import net.bdew.neiaddons.forestry.GeneticsUtils;

public class FlowerHelper {
    public static Collection<IAlleleSpecies> allSpecies;
    public static Class<? extends IAlleleSpecies> flowerSpeciesClass;
    public static ISpeciesRoot root;

    public static void setup() {
        root = AlleleManager.alleleRegistry.getSpeciesRoot("rootFlowers");
        if (root == null) {
            AddonBotany.instance.logWarning("Failed to load Flower root, Botany support disabled", new Object[0]);
        }
        try {
            flowerSpeciesClass = Utils.getAndCheckClass("binnie.botany.api.IAlleleFlowerSpecies", IAlleleSpecies.class);
        }
        catch (Throwable e) {
            AddonBotany.instance.logWarningExc(e, "Failed to load Flower species interface, Botany support disabled", new Object[0]);
            return;
        }
        AddonBotany.instance.logInfo("Root=%s Species=%s", root, flowerSpeciesClass);
        allSpecies = GeneticsUtils.getAllTypedSpecies(flowerSpeciesClass, AddonBotany.loadBlacklisted);
        if (AddonBotany.showFlowerMutations) {
            FlowerBreedingHandler breedingRecipeHandler = new FlowerBreedingHandler();
            API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
            API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
            AddonBotany.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        }
    }
}

