/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.Tezzelator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class MCRSelectionList {
    private static final int NO_DRAG = -1;
    private static final int DRAG_OUTSIDE = -2;
    private int width;
    private int height;
    protected int y0;
    protected int y1;
    private int x1;
    private int x0;
    protected final int itemHeight;
    protected int xm;
    protected int ym;
    private float yDrag = -2.0f;
    private float yDragScale;
    private float yo;
    private int lastSelection = -1;
    private long lastSelectionTime;
    private boolean renderSelection = true;
    private boolean renderHeader;
    private int headerHeight;

    public MCRSelectionList(int width, int height, int y0, int y1, int itemHeight) {
        this.width = width;
        this.height = height;
        this.y0 = y0;
        this.y1 = y1;
        this.itemHeight = itemHeight;
        this.x0 = 0;
        this.x1 = width;
    }

    public void updateSize(int width, int height, int y0, int y1) {
        this.width = width;
        this.height = height;
        this.y0 = y0;
        this.y1 = y1;
        this.x0 = 0;
        this.x1 = width;
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
    }

    protected void setRenderHeader(boolean renderHeader, int headerHeight) {
        this.renderHeader = renderHeader;
        this.headerHeight = headerHeight;
        if (!renderHeader) {
            this.headerHeight = 0;
        }
    }

    protected abstract int getNumberOfItems();

    protected abstract void selectItem(int var1, boolean var2);

    protected abstract boolean isSelectedItem(int var1);

    protected abstract boolean isMyWorld(int var1);

    protected int getMaxPosition() {
        return this.getNumberOfItems() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground();

    protected abstract void renderItem(int var1, int var2, int var3, int var4, int var5, Tezzelator var6);

    protected void renderHeader(int x, int y, Tezzelator t) {
    }

    protected void clickedHeader(int headerMouseX, int headerMouseY) {
    }

    protected void renderDecorations(int mouseX, int mouseY) {
    }

    public int getItemAtPosition(int x, int y) {
        int x0 = this.width / 2 - 110;
        int x1 = this.width / 2 + 110;
        int clickSlotPos = y - this.y0 - this.headerHeight + (int)this.yo - 4;
        int slot = clickSlotPos / this.itemHeight;
        if (x >= x0 && x <= x1 && slot >= 0 && clickSlotPos >= 0 && slot < this.getNumberOfItems()) {
            return slot;
        }
        return -1;
    }

    public void scrollToItem(int itemIndex) {
        if (itemIndex < 0) {
            return;
        }
        int yo = this.headerHeight + itemIndex * this.itemHeight;
        this.scroll(yo);
    }

    private void capYPosition() {
        int max = this.getMaxScroll();
        if (max < 0) {
            max /= 2;
        }
        if (this.yo < 0.0f) {
            this.yo = 0.0f;
        }
        if (this.yo > (float)max) {
            this.yo = max;
        }
    }

    public int getMaxScroll() {
        return this.getMaxPosition() - (this.y1 - this.y0 - 4);
    }

    public int getScroll() {
        return (int)this.yo;
    }

    public int getScrollBottom() {
        return (int)this.yo - this.height - this.headerHeight;
    }

    public void scroll(int amount) {
        this.yo += (float)amount;
        this.capYPosition();
        this.yDrag = -2.0f;
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
    }

    public void itemClicked(int x, int y, int xm, int ym, int width) {
    }

    protected void renderSelected(int width, int y, int h, Tezzelator t) {
        int x0 = width / 2 - 110;
        int x1 = width / 2 + 110;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3553);
        t.begin();
        t.color(0x808080);
        t.vertexUV((double)x0, (double)(y + h + 2), 0.0, 0.0, 1.0);
        t.vertexUV((double)x1, (double)(y + h + 2), 0.0, 1.0, 1.0);
        t.vertexUV((double)x1, (double)(y - 2), 0.0, 1.0, 0.0);
        t.vertexUV((double)x0, (double)(y - 2), 0.0, 0.0, 0.0);
        t.color(0);
        t.vertexUV((double)(x0 + 1), (double)(y + h + 1), 0.0, 0.0, 1.0);
        t.vertexUV((double)(x1 - 1), (double)(y + h + 1), 0.0, 1.0, 1.0);
        t.vertexUV((double)(x1 - 1), (double)(y - 1), 0.0, 1.0, 0.0);
        t.vertexUV((double)(x0 + 1), (double)(y - 1), 0.0, 0.0, 0.0);
        t.end();
        GL11.glEnable((int)3553);
    }

    public void render(int xm, int ym, float a) {
        int barHeight;
        int max;
        this.xm = xm;
        this.ym = ym;
        this.renderBackground();
        int itemCount = this.getNumberOfItems();
        int xx0 = this.getScrollbarPosition();
        int xx1 = xx0 + 6;
        boolean itemClicked = false;
        if (Mouse.isButtonDown((int)0)) {
            if (this.yDrag == -1.0f) {
                boolean doDrag = true;
                if (ym >= this.y0 && ym <= this.y1) {
                    int x0 = this.width / 2 - 110;
                    int x1 = this.width / 2 + 110;
                    int clickSlotPos = ym - this.y0 - this.headerHeight + (int)this.yo - 4;
                    int slot = clickSlotPos / this.itemHeight;
                    if (xm >= x0 && xm <= xx0 && slot >= 0 && clickSlotPos >= 0 && slot < itemCount) {
                        boolean doubleClick = slot == this.lastSelection && Realms.currentTimeMillis() - this.lastSelectionTime < 250L;
                        this.selectItem(slot, doubleClick);
                        itemClicked = true;
                        this.lastSelection = slot;
                        this.lastSelectionTime = Realms.currentTimeMillis();
                    } else if (xm >= x0 && xm <= x1 && clickSlotPos < 0) {
                        this.clickedHeader(xm - x0, ym - this.y0 + (int)this.yo - 4);
                        doDrag = false;
                    }
                    if (xm >= xx0 && xm <= xx1) {
                        this.yDragScale = -1.0f;
                        max = this.getMaxScroll();
                        if (max < 1) {
                            max = 1;
                        }
                        if ((barHeight = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition())) < 32) {
                            barHeight = 32;
                        }
                        if (barHeight > this.y1 - this.y0 - 8) {
                            barHeight = this.y1 - this.y0 - 8;
                        }
                        this.yDragScale /= (float)(this.y1 - this.y0 - barHeight) / (float)max;
                    } else {
                        this.yDragScale = 1.0f;
                    }
                    this.yDrag = doDrag ? (float)ym : -2.0f;
                } else {
                    this.yDrag = -2.0f;
                }
            } else if (this.yDrag >= 0.0f) {
                this.yo -= ((float)ym - this.yDrag) * this.yDragScale;
                this.yDrag = ym;
            }
        } else {
            while (!Realms.isTouchScreen() && Mouse.next()) {
                int wheel = Mouse.getEventDWheel();
                if (wheel == 0) continue;
                if (wheel > 0) {
                    wheel = -1;
                } else if (wheel < 0) {
                    wheel = 1;
                }
                this.yo += (float)(wheel * this.itemHeight / 2);
            }
            this.yDrag = -1.0f;
        }
        this.capYPosition();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tezzelator t = Tezzelator.instance;
        RealmsScreen.bind((String)"textures/gui/options_background.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float s = 32.0f;
        t.begin();
        t.color(0x202020);
        t.vertexUV((double)this.x0, (double)this.y1, 0.0, (double)((float)this.x0 / s), (double)((float)(this.y1 + (int)this.yo) / s));
        t.vertexUV((double)this.x1, (double)this.y1, 0.0, (double)((float)this.x1 / s), (double)((float)(this.y1 + (int)this.yo) / s));
        t.vertexUV((double)this.x1, (double)this.y0, 0.0, (double)((float)this.x1 / s), (double)((float)(this.y0 + (int)this.yo) / s));
        t.vertexUV((double)this.x0, (double)this.y0, 0.0, (double)((float)this.x0 / s), (double)((float)(this.y0 + (int)this.yo) / s));
        t.end();
        int rowX = this.width / 2 - 92 - 16;
        int rowBaseY = this.y0 + 4 - (int)this.yo;
        if (this.renderHeader) {
            this.renderHeader(rowX, rowBaseY, t);
        }
        for (int i = 0; i < itemCount; ++i) {
            int y = rowBaseY + i * this.itemHeight + this.headerHeight;
            int h = this.itemHeight - 4;
            if (y > this.y1 || y + h < this.y0) continue;
            if (this.renderSelection && this.isSelectedItem(i)) {
                this.renderSelected(this.width, y, h, t);
            }
            this.renderItem(i, rowX, y, h, this.width, t);
            if (!itemClicked) continue;
            this.itemClicked(rowX, y, xm, ym, this.width);
        }
        GL11.glDisable((int)2929);
        int d = 4;
        this.renderHoleBackground(0, this.y0, 255, 255);
        this.renderHoleBackground(this.y1, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        t.begin();
        t.color(0, 0);
        t.vertexUV((double)this.x0, (double)(this.y0 + d), 0.0, 0.0, 1.0);
        t.vertexUV((double)this.x1, (double)(this.y0 + d), 0.0, 1.0, 1.0);
        t.color(0, 255);
        t.vertexUV((double)this.x1, (double)this.y0, 0.0, 1.0, 0.0);
        t.vertexUV((double)this.x0, (double)this.y0, 0.0, 0.0, 0.0);
        t.end();
        t.begin();
        t.color(0, 255);
        t.vertexUV((double)this.x0, (double)this.y1, 0.0, 0.0, 1.0);
        t.vertexUV((double)this.x1, (double)this.y1, 0.0, 1.0, 1.0);
        t.color(0, 0);
        t.vertexUV((double)this.x1, (double)(this.y1 - d), 0.0, 1.0, 0.0);
        t.vertexUV((double)this.x0, (double)(this.y1 - d), 0.0, 0.0, 0.0);
        t.end();
        max = this.getMaxScroll();
        if (max > 0) {
            int yp;
            barHeight = (this.y1 - this.y0) * (this.y1 - this.y0) / this.getMaxPosition();
            if (barHeight < 32) {
                barHeight = 32;
            }
            if (barHeight > this.y1 - this.y0 - 8) {
                barHeight = this.y1 - this.y0 - 8;
            }
            if ((yp = (int)this.yo * (this.y1 - this.y0 - barHeight) / max + this.y0) < this.y0) {
                yp = this.y0;
            }
            t.begin();
            t.color(0, 255);
            t.vertexUV((double)xx0, (double)this.y1, 0.0, 0.0, 1.0);
            t.vertexUV((double)xx1, (double)this.y1, 0.0, 1.0, 1.0);
            t.vertexUV((double)xx1, (double)this.y0, 0.0, 1.0, 0.0);
            t.vertexUV((double)xx0, (double)this.y0, 0.0, 0.0, 0.0);
            t.end();
            t.begin();
            t.color(0x808080, 255);
            t.vertexUV((double)xx0, (double)(yp + barHeight), 0.0, 0.0, 1.0);
            t.vertexUV((double)xx1, (double)(yp + barHeight), 0.0, 1.0, 1.0);
            t.vertexUV((double)xx1, (double)yp, 0.0, 1.0, 0.0);
            t.vertexUV((double)xx0, (double)yp, 0.0, 0.0, 0.0);
            t.end();
            t.begin();
            t.color(0xC0C0C0, 255);
            t.vertexUV((double)xx0, (double)(yp + barHeight - 1), 0.0, 0.0, 1.0);
            t.vertexUV((double)(xx1 - 1), (double)(yp + barHeight - 1), 0.0, 1.0, 1.0);
            t.vertexUV((double)(xx1 - 1), (double)yp, 0.0, 1.0, 0.0);
            t.vertexUV((double)xx0, (double)yp, 0.0, 0.0, 0.0);
            t.end();
        }
        this.renderDecorations(xm, ym);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    private void renderHoleBackground(int y0, int y1, int a0, int a1) {
        Tezzelator t = Tezzelator.instance;
        RealmsScreen.bind((String)"textures/gui/options_background.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float s = 32.0f;
        t.begin();
        t.color(0x404040, a1);
        t.vertexUV(0.0, (double)y1, 0.0, 0.0, (double)((float)y1 / s));
        t.vertexUV((double)this.width, (double)y1, 0.0, (double)((float)this.width / s), (double)((float)y1 / s));
        t.color(0x404040, a0);
        t.vertexUV((double)this.width, (double)y0, 0.0, (double)((float)this.width / s), (double)((float)y0 / s));
        t.vertexUV(0.0, (double)y0, 0.0, 0.0, (double)((float)y0 / s));
        t.end();
    }
}

