/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.railcraft;

import codechicken.core.ReflectionManager;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;
import tonius.neiintegration.railcraft.RecipeHandlerRollingMachine;

public class RecipeHandlerRollingMachineShaped
extends RecipeHandlerRollingMachine {
    @Override
    public String getRecipeSubName() {
        return Utils.translate("shaped");
    }

    private CachedRollingMachineShapedRecipe getCachedRecipe(IRecipe irecipe, boolean genPerms) {
        CachedRollingMachineShapedRecipe recipe = null;
        if (irecipe instanceof ShapedRecipes) {
            recipe = new CachedRollingMachineShapedRecipe((ShapedRecipes)irecipe, genPerms);
        } else if (irecipe instanceof ShapedOreRecipe) {
            recipe = this.getCachedOreRecipe((ShapedOreRecipe)irecipe, genPerms);
        }
        return recipe;
    }

    private CachedRollingMachineShapedRecipe getCachedOreRecipe(ShapedOreRecipe recipe, boolean genPerms) {
        Object[] items;
        int height;
        int width;
        try {
            width = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)4);
            height = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)5);
        }
        catch (Exception e) {
            return null;
        }
        for (Object item : items = recipe.getInput()) {
            if (!(item instanceof List) || !((List)item).isEmpty()) continue;
            return null;
        }
        return new CachedRollingMachineShapedRecipe(width, height, items, recipe.func_77571_b(), genPerms);
    }

    @Override
    public void loadAllRecipes() {
        for (IRecipe irecipe : RailcraftCraftingManager.rollingMachine.getRecipeList()) {
            CachedRollingMachineShapedRecipe recipe = this.getCachedRecipe(irecipe, true);
            if (recipe == null) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : RailcraftCraftingManager.rollingMachine.getRecipeList()) {
            CachedRollingMachineShapedRecipe recipe;
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result) || (recipe = this.getCachedRecipe(irecipe, true)) == null) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : RailcraftCraftingManager.rollingMachine.getRecipeList()) {
            CachedRollingMachineShapedRecipe recipe = this.getCachedRecipe(irecipe, false);
            if (recipe == null || !recipe.contains(recipe.inputs, ingredient)) continue;
            recipe.generatePermutations();
            recipe.setIngredientPermutation(recipe.inputs, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public class CachedRollingMachineShapedRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedStack output;

        public CachedRollingMachineShapedRecipe(int width, int height, Object[] items, ItemStack output, boolean genPerms) {
            this.setIngredients(width, height, items);
            this.output = new PositionedStack((Object)output, 88, 18);
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public CachedRollingMachineShapedRecipe(int width, int height, Object[] items, ItemStack output) {
            this(width, height, items, output, false);
        }

        public CachedRollingMachineShapedRecipe(ShapedRecipes recipe, boolean genPerms) {
            this(recipe.field_77576_b, recipe.field_77577_c, recipe.field_77574_d, recipe.func_77571_b(), genPerms);
        }

        public CachedRollingMachineShapedRecipe(ShapedRecipes recipe) {
            this(recipe, false);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 8 + y * 18, false);
                    stack.setMaxSize(1);
                    this.inputs.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerRollingMachineShaped.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

