/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.forestry;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.factory.gadgets.MachineMoistener;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerMoistener
extends RecipeHandlerBase {
    private static Class<? extends GuiContainer> guiClass;

    @Override
    public void prepare() {
        guiClass = Utils.getClass("forestry.factory.gui.GuiMoistener");
    }

    @Override
    public String getRecipeID() {
        return "forestry.moistener";
    }

    public String getRecipeName() {
        return Utils.translate("tile.for.factory.4.name", false);
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/moistener.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(138, 27, 16, 14);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        this.drawProgressBar(88, 6, 176, 91, 29, 55, 80, 3);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(119, 25, 176, 74, 16, 15, 160, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (MachineMoistener.Recipe recipe : MachineMoistener.RecipeManager.recipes) {
            for (MoistenerFuel fuel : FuelManager.moistenerResource.values()) {
                this.arecipes.add(new CachedMoistenerRecipe(recipe, fuel));
            }
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (MachineMoistener.Recipe recipe : MachineMoistener.RecipeManager.recipes) {
            for (MoistenerFuel fuel : FuelManager.moistenerResource.values()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.product, (ItemStack)result) && !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)fuel.product, (ItemStack)result)) continue;
                this.arecipes.add(new CachedMoistenerRecipe(recipe, fuel));
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        super.loadUsageRecipes(ingred);
        for (MachineMoistener.Recipe recipe : MachineMoistener.RecipeManager.recipes) {
            for (MoistenerFuel fuel : FuelManager.moistenerResource.values()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.resource, (ItemStack)ingred) && !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)fuel.item, (ItemStack)ingred)) continue;
                this.arecipes.add(new CachedMoistenerRecipe(recipe, fuel));
            }
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (ingredient.getFluid() == FluidRegistry.WATER) {
            this.loadAllRecipes();
        }
    }

    public class CachedMoistenerRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank tank;
        public List<PositionedStack> fuels = new ArrayList<PositionedStack>();
        public PositionedStack input;
        public PositionedStack output;

        public CachedMoistenerRecipe(MachineMoistener.Recipe recipe, MoistenerFuel fuel) {
            this.tank = new PositionedFluidTank(FluidRegistry.getFluidStack((String)"water", (int)10000), 10000, new Rectangle(11, 5, 16, 58), RecipeHandlerMoistener.this.getGuiTexture(), new Point(176, 0));
            this.tank.showAmount = false;
            this.fuels.add(new PositionedStack((Object)fuel.item, 34, 47));
            this.fuels.add(new PositionedStack((Object)fuel.product, 100, 26));
            this.input = new PositionedStack((Object)recipe.resource, 138, 8);
            this.output = new PositionedStack((Object)recipe.product, 138, 44);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.fuels;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.tank;
        }
    }
}

