/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.buildcraft;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IFlexibleRecipeViewable;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.FluidStack;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerRefinery
extends RecipeHandlerBase {
    private static Class<? extends GuiContainer> guiClass;

    @Override
    public void prepare() {
        guiClass = Utils.getClass("buildcraft.factory.gui.GuiRefinery");
        API.setGuiOffset(guiClass, (int)0, (int)31);
    }

    public String getRecipeName() {
        return Utils.translate("tile.refineryBlock.name", false);
    }

    @Override
    public String getRecipeID() {
        return "buildcraft.refinery";
    }

    public String getGuiTexture() {
        return "buildcraft:textures/gui/refinery_filter.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(52, 24, 23, 15);
        this.addTransferRect(96, 24, 23, 15);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)31, (int)166, (int)65);
    }

    public void drawExtras(int recipe) {
        int energyPerTick = ((CachedRefineryRecipe)((Object)this.arecipes.get((int)recipe))).energy;
        long time = ((CachedRefineryRecipe)((Object)this.arecipes.get((int)recipe))).time;
        GuiDraw.drawStringC((String)String.format(Utils.translate("handler.refinery.energyRate"), (long)energyPerTick * time, energyPerTick), (int)82, (int)45, (int)0x808080, (boolean)false);
        GuiDraw.drawString((String)"->", (int)58, (int)28, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)"<-", (int)102, (int)28, (int)0x404040, (boolean)false);
    }

    @Override
    public void loadAllRecipes() {
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.refinery.getRecipes()) {
            if (!(recipe instanceof IFlexibleRecipeViewable)) continue;
            this.arecipes.add(new CachedRefineryRecipe((IFlexibleRecipeViewable)recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.refinery.getRecipes()) {
            if (!(recipe instanceof IFlexibleRecipeViewable) || ((FluidStack)((IFlexibleRecipeViewable)recipe).getOutput()).getFluid() != result.getFluid()) continue;
            this.arecipes.add(new CachedRefineryRecipe((IFlexibleRecipeViewable)recipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.refinery.getRecipes()) {
            if (!(recipe instanceof IFlexibleRecipeViewable)) continue;
            for (Object o : ((IFlexibleRecipeViewable)recipe).getInputs()) {
                if (!Utils.areFluidsSameType((FluidStack)o, ingredient)) continue;
                this.arecipes.add(new CachedRefineryRecipe((IFlexibleRecipeViewable)recipe));
            }
        }
    }

    public class CachedRefineryRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedFluidTank> tanks = new ArrayList<PositionedFluidTank>();
        public int energy;
        public long time;

        public CachedRefineryRecipe(IFlexibleRecipeViewable recipe) {
            List inputs = (List)recipe.getInputs();
            PositionedFluidTank tank = new PositionedFluidTank((FluidStack)inputs.get(0), ((FluidStack)inputs.get((int)0)).amount, new Rectangle(33, 23, 16, 16));
            this.tanks.add(tank);
            if (inputs.size() > 1) {
                this.tanks.add(new PositionedFluidTank((FluidStack)inputs.get(1), ((FluidStack)inputs.get((int)1)).amount, new Rectangle(121, 23, 16, 16)));
            }
            this.tanks.add(new PositionedFluidTank((FluidStack)recipe.getOutput(), ((FluidStack)recipe.getOutput()).amount, new Rectangle(77, 23, 16, 16)));
            this.energy = recipe.getEnergyCost();
            this.time = recipe.getCraftingTime();
        }

        @Override
        public List<PositionedFluidTank> getFluidTanks() {
            return this.tanks;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

