/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;

public class NetworkUtils {
    private static ArrayList<InetAddress> localAddresses;
    private static ArrayList<InetAddress> netmasks;

    public static void enumerateInterfaces() throws SocketException {
        localAddresses = new ArrayList();
        netmasks = new ArrayList();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (networkInterface == null || networkInterface.isLoopback() || !networkInterface.isUp()) continue;
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                InetAddress subnetMask;
                InetAddress inetAddress;
                if (interfaceAddress == null || !((inetAddress = interfaceAddress.getAddress()) instanceof Inet4Address) || (subnetMask = NetworkUtils.convertNetPrefixToNetmask(interfaceAddress.getNetworkPrefixLength())) == null) continue;
                localAddresses.add(inetAddress);
                netmasks.add(subnetMask);
            }
        }
    }

    private static InetAddress convertNetPrefixToNetmask(int netPrefix) {
        try {
            int shiftby = Integer.MIN_VALUE;
            for (int i = netPrefix - 1; i > 0; --i) {
                shiftby >>= 1;
            }
            String maskString = Integer.toString(shiftby >> 24 & 0xFF) + "." + Integer.toString(shiftby >> 16 & 0xFF) + "." + Integer.toString(shiftby >> 8 & 0xFF) + "." + Integer.toString(shiftby & 0xFF);
            return InetAddress.getByName(maskString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean onSameNetwork(InetAddress ip1, InetAddress ip2, InetAddress mask) throws Exception {
        byte[] a1 = ip1.getAddress();
        byte[] a2 = ip2.getAddress();
        byte[] m = mask.getAddress();
        for (int i = 0; i < a1.length; ++i) {
            if ((a1[i] & m[i]) == (a2[i] & m[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isOnLan(InetAddress serverAddress) {
        try {
            for (int t = 0; t < localAddresses.size(); ++t) {
                if (!NetworkUtils.onSameNetwork(localAddresses.get(t), serverAddress, netmasks.get(t))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

