/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.world.biome.BiomeGenBase;

public class MapData {
    private int width;
    private int height;
    private Object dataLock = new Object();
    private Object labelLock = new Object();
    private static int DATABITS = 16;
    private static int HEIGHTPOS = 0;
    private static int MATERIALPOS = 1;
    private static int METADATAPOS = 2;
    private static int TINTPOS = 3;
    private static int LIGHTPOS = 4;
    private static int OCEANFLOORHEIGHTPOS = 5;
    private static int OCEANFLOORMATERIALPOS = 6;
    private static int OCEANFLOORMETADATAPOS = 7;
    private static int OCEANFLOORTINTPOS = 8;
    private static int OCEANFLOORLIGHTPOS = 9;
    private static int TRANSPARENTHEIGHTPOS = 10;
    private static int TRANSPARENTIDPOS = 11;
    private static int TRANSPARENTMETADATAPOS = 12;
    private static int TRANSPARENTTINTPOS = 13;
    private static int TRANSPARENTLIGHTPOS = 14;
    private static int BIOMEIDPOS = 15;
    private int[] data;
    public Point[][] points;
    public ArrayList<Segment> segments;
    private ArrayList<BiomeLabel> labels = new ArrayList();

    public MapData(int width, int height) {
        this.width = width;
        this.height = height;
        this.data = new int[width * height * DATABITS];
    }

    public int getHeight(int x, int z) {
        return this.getData(x, z, HEIGHTPOS);
    }

    public int getMaterial(int x, int z) {
        return this.getData(x, z, MATERIALPOS);
    }

    public int getMetadata(int x, int z) {
        return this.getData(x, z, METADATAPOS);
    }

    public int getBiomeTint(int x, int z) {
        return this.getData(x, z, TINTPOS);
    }

    public int getLight(int x, int z) {
        return this.getData(x, z, LIGHTPOS);
    }

    public int getOceanFloorHeight(int x, int z) {
        return this.getData(x, z, OCEANFLOORHEIGHTPOS);
    }

    public int getOceanFloorMaterial(int x, int z) {
        return this.getData(x, z, OCEANFLOORMATERIALPOS);
    }

    public int getOceanFloorMetadata(int x, int z) {
        return this.getData(x, z, OCEANFLOORMETADATAPOS);
    }

    public int getOceanFloorBiomeTint(int x, int z) {
        return this.getData(x, z, OCEANFLOORTINTPOS);
    }

    public int getOceanFloorLight(int x, int z) {
        return this.getData(x, z, OCEANFLOORLIGHTPOS);
    }

    public int getTransparentHeight(int x, int z) {
        return this.getData(x, z, TRANSPARENTHEIGHTPOS);
    }

    public int getTransparentId(int x, int z) {
        return this.getData(x, z, TRANSPARENTIDPOS);
    }

    public int getTransparentMetadata(int x, int z) {
        return this.getData(x, z, TRANSPARENTMETADATAPOS);
    }

    public int getTransparentBiomeTint(int x, int z) {
        return this.getData(x, z, TRANSPARENTTINTPOS);
    }

    public int getTransparentLight(int x, int z) {
        return this.getData(x, z, TRANSPARENTLIGHTPOS);
    }

    public int getBiomeID(int x, int z) {
        return this.getData(x, z, BIOMEIDPOS);
    }

    public int getData(int x, int z, int bit) {
        int index = (x + z * this.width) * DATABITS + bit;
        return this.data[index];
    }

    public void setHeight(int x, int z, int value) {
        this.setData(x, z, HEIGHTPOS, value);
    }

    public void setMaterial(int x, int z, int value) {
        this.setData(x, z, MATERIALPOS, value);
    }

    public void setMetadata(int x, int z, int value) {
        this.setData(x, z, METADATAPOS, value);
    }

    public void setBiomeTint(int x, int z, int value) {
        this.setData(x, z, TINTPOS, value);
    }

    public void setLight(int x, int z, int value) {
        this.setData(x, z, LIGHTPOS, value);
    }

    public void setOceanFloorHeight(int x, int z, int value) {
        this.setData(x, z, OCEANFLOORHEIGHTPOS, value);
    }

    public void setOceanFloorMaterial(int x, int z, int value) {
        this.setData(x, z, OCEANFLOORMATERIALPOS, value);
    }

    public void setOceanFloorMetadata(int x, int z, int value) {
        this.setData(x, z, OCEANFLOORMETADATAPOS, value);
    }

    public void setOceanFloorBiomeTint(int x, int z, int value) {
        this.setData(x, z, OCEANFLOORTINTPOS, value);
    }

    public void setOceanFloorLight(int x, int z, int value) {
        this.setData(x, z, OCEANFLOORLIGHTPOS, value);
    }

    public void setTransparentHeight(int x, int z, int value) {
        this.setData(x, z, TRANSPARENTHEIGHTPOS, value);
    }

    public void setTransparentId(int x, int z, int value) {
        this.setData(x, z, TRANSPARENTIDPOS, value);
    }

    public void setTransparentMetadata(int x, int z, int value) {
        this.setData(x, z, TRANSPARENTMETADATAPOS, value);
    }

    public void setTransparentBiomeTint(int x, int z, int value) {
        this.setData(x, z, TRANSPARENTTINTPOS, value);
    }

    public void setTransparentLight(int x, int z, int value) {
        this.setData(x, z, TRANSPARENTLIGHTPOS, value);
    }

    public void setBiomeID(int x, int z, int value) {
        this.setData(x, z, BIOMEIDPOS, value);
    }

    public void setData(int x, int z, int bit, int value) {
        int index = (x + z * this.width) * DATABITS + bit;
        this.data[index] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveX(int offset) {
        Object object = this.dataLock;
        synchronized (object) {
            if (offset > 0) {
                System.arraycopy(this.data, offset * DATABITS, this.data, 0, this.data.length - offset * DATABITS);
            } else if (offset < 0) {
                System.arraycopy(this.data, 0, this.data, -offset * DATABITS, this.data.length + offset * DATABITS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveZ(int offset) {
        Object object = this.dataLock;
        synchronized (object) {
            if (offset > 0) {
                System.arraycopy(this.data, offset * this.width * DATABITS, this.data, 0, this.data.length - offset * this.width * DATABITS);
            } else if (offset < 0) {
                System.arraycopy(this.data, 0, this.data, -offset * this.width * DATABITS, this.data.length + offset * this.width * DATABITS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void segmentBiomes() {
        this.points = new Point[this.width][this.height];
        this.segments = new ArrayList();
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.height; ++z) {
                this.points[x][z] = new Point(x, z, this.getBiomeID(x, z));
            }
        }
        Object object = this.dataLock;
        synchronized (object) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.height; ++z) {
                    if (this.points[x][z].inSegment) continue;
                    Segment segment = new Segment(this.points[x][z]);
                    this.segments.add(segment);
                    segment.flood();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findCenterOfSegments() {
        if (this.segments != null) {
            for (int t = 0; t < this.segments.size(); ++t) {
                Segment segment = this.segments.get(t);
                if (segment.biome == -1) continue;
                segment.calculateCenter();
            }
        }
        Object object = this.labelLock;
        synchronized (object) {
            this.labels.clear();
            if (this.segments != null) {
                for (int t = 0; t < this.segments.size(); ++t) {
                    Segment segment = this.segments.get(t);
                    if (segment.biome == -1) continue;
                    BiomeLabel label = new BiomeLabel();
                    label.biomeInt = segment.biome;
                    label.size = segment.memberPoints.size();
                    label.x = segment.centerX;
                    label.z = segment.centerZ;
                    this.labels.add(label);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BiomeLabel> getBiomeLabels() {
        ArrayList<BiomeLabel> labelsToReturn = new ArrayList<BiomeLabel>();
        Object object = this.labelLock;
        synchronized (object) {
            labelsToReturn.addAll(this.labels);
        }
        return labelsToReturn;
    }

    public class BiomeLabel {
        public int biomeInt = -1;
        public int size = 0;
        public int x = 0;
        public int z = 0;
    }

    public class Segment {
        public ArrayList<Point> memberPoints;
        ArrayList<Point> currentShell;
        public int biome;
        public int centerX = 0;
        public int centerZ = 0;

        public Segment(Point point) {
            this.biome = point.biome;
            this.memberPoints = new ArrayList();
            this.memberPoints.add(point);
            this.currentShell = new ArrayList();
        }

        public void flood() {
            ArrayList<Point> candidatePoints = new ArrayList<Point>();
            candidatePoints.add(this.memberPoints.remove(0));
            while (candidatePoints.size() > 0) {
                Point neighbor;
                Point point = (Point)candidatePoints.remove(0);
                point.isCandidate = false;
                if (point.biome != this.biome) continue;
                this.memberPoints.add(point);
                point.inSegment = true;
                boolean edge = false;
                if (point.x < MapData.this.width - 1) {
                    neighbor = MapData.this.points[point.x + 1][point.z];
                    if (!neighbor.inSegment && !neighbor.isCandidate) {
                        candidatePoints.add(neighbor);
                        neighbor.isCandidate = true;
                    }
                    if (neighbor.biome != point.biome) {
                        edge = true;
                    }
                } else {
                    edge = true;
                }
                if (point.x > 0) {
                    neighbor = MapData.this.points[point.x - 1][point.z];
                    if (!neighbor.inSegment && !neighbor.isCandidate) {
                        candidatePoints.add(neighbor);
                        neighbor.isCandidate = true;
                    }
                    if (neighbor.biome != point.biome) {
                        edge = true;
                    }
                } else {
                    edge = true;
                }
                if (point.z < MapData.this.height - 1) {
                    neighbor = MapData.this.points[point.x][point.z + 1];
                    if (!neighbor.inSegment && !neighbor.isCandidate) {
                        candidatePoints.add(neighbor);
                        neighbor.isCandidate = true;
                    }
                    if (neighbor.biome != point.biome) {
                        edge = true;
                    }
                } else {
                    edge = true;
                }
                if (point.z > 0) {
                    neighbor = MapData.this.points[point.x][point.z - 1];
                    if (!neighbor.inSegment && !neighbor.isCandidate) {
                        candidatePoints.add(neighbor);
                        neighbor.isCandidate = true;
                    }
                    if (neighbor.biome != point.biome) {
                        edge = true;
                    }
                } else {
                    edge = true;
                }
                if (!edge) continue;
                point.layer = 0;
                this.currentShell.add(point);
            }
        }

        public void calculateCenter() {
            this.calculateCenterOfMass();
            this.morphologicallyErode();
        }

        public void calculateCenterOfMass() {
            this.calculateCenterOfMass(this.memberPoints);
        }

        public void calculateCenterOfMass(Collection<Point> points) {
            this.centerX = 0;
            this.centerZ = 0;
            for (Point point : points) {
                this.centerX += point.x;
                this.centerZ += point.z;
            }
            this.centerX /= points.size();
            this.centerZ /= points.size();
        }

        public void calculateClosestPointToCenter(Collection<Point> points) {
            int distanceSquared = 131072;
            Point centerPoint = null;
            for (Point point : points) {
                int pointDistanceSquared = (point.x - this.centerX) * (point.x - this.centerX) + (point.z - this.centerZ) * (point.z - this.centerZ);
                if (pointDistanceSquared >= distanceSquared) continue;
                distanceSquared = pointDistanceSquared;
                centerPoint = point;
            }
            this.centerX = centerPoint.x;
            this.centerZ = centerPoint.z;
        }

        public void morphologicallyErode() {
            float labelWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(BiomeGenBase.func_150565_n()[this.biome].field_76791_y) + 8;
            float multi = MapData.this.width / 32;
            float shellWidth = 2.0f;
            float labelPadding = labelWidth / 16.0f * multi / shellWidth;
            int layer = 0;
            while (this.currentShell.size() > 0 && (float)layer < labelPadding) {
                this.currentShell = this.getNextShell(this.currentShell, ++layer);
            }
            if (this.currentShell.size() > 0) {
                ArrayList<Point> remainingPoints = new ArrayList<Point>();
                for (Point point : this.memberPoints) {
                    if (point.layer >= 0 && point.layer != layer) continue;
                    remainingPoints.add(point);
                }
                this.calculateClosestPointToCenter(remainingPoints);
            }
        }

        public ArrayList<Point> getNextShell(Collection<Point> pointsToCheck, int layer) {
            ArrayList<Point> nextShell = new ArrayList<Point>();
            for (Point point : pointsToCheck) {
                Point neighbor;
                Point neighbor2;
                Point neighbor1;
                if (point.x < MapData.this.width - 2) {
                    neighbor1 = MapData.this.points[point.x + 1][point.z];
                    neighbor2 = MapData.this.points[point.x + 2][point.z];
                    if (neighbor1.biome == point.biome && neighbor1.layer < 0 && neighbor2.biome == point.biome && neighbor2.layer < 0) {
                        neighbor1.layer = layer;
                        neighbor2.layer = layer;
                        nextShell.add(neighbor2);
                    } else if (neighbor1.biome == point.biome && neighbor1.layer < 0) {
                        neighbor1.layer = layer;
                        nextShell.add(neighbor1);
                    } else if (neighbor2.biome == point.biome && neighbor2.layer < 0) {
                        neighbor2.layer = layer;
                        nextShell.add(neighbor2);
                    }
                }
                if (point.x > 1) {
                    neighbor1 = MapData.this.points[point.x - 1][point.z];
                    neighbor2 = MapData.this.points[point.x - 2][point.z];
                    if (neighbor1.biome == point.biome && neighbor1.layer < 0 && neighbor2.biome == point.biome && neighbor2.layer < 0) {
                        neighbor1.layer = layer;
                        neighbor2.layer = layer;
                        nextShell.add(neighbor2);
                    } else if (neighbor1.biome == point.biome && neighbor1.layer < 0) {
                        neighbor1.layer = layer;
                        nextShell.add(neighbor1);
                    } else if (neighbor2.biome == point.biome && neighbor2.layer < 0) {
                        neighbor2.layer = layer;
                        nextShell.add(neighbor2);
                    }
                }
                if (point.z < MapData.this.height - 1) {
                    neighbor = MapData.this.points[point.x][point.z + 1];
                    if (neighbor.biome == point.biome && neighbor.layer < 0) {
                        neighbor.layer = layer;
                        nextShell.add(neighbor);
                    }
                }
                if (point.z <= 0) continue;
                neighbor = MapData.this.points[point.x][point.z - 1];
                if (neighbor.biome != point.biome || neighbor.layer >= 0) continue;
                neighbor.layer = layer;
                nextShell.add(neighbor);
            }
            if (nextShell.size() > 0) {
                return nextShell;
            }
            this.calculateCenterOfMass(pointsToCheck);
            this.calculateClosestPointToCenter(pointsToCheck);
            return nextShell;
        }
    }

    private class Point {
        public int x;
        public int z;
        public boolean inSegment = false;
        public boolean isCandidate = false;
        public boolean isEroded = false;
        public int layer = -1;
        public int biome = -1;

        public Point(int x, int z, int biome) {
            this.x = x;
            this.z = z;
            this.biome = biome;
        }
    }
}

