/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import com.thevoxelbox.voxelmap.interfaces.IMap;
import com.thevoxelbox.voxelmap.util.MapChunk;
import net.minecraft.client.Minecraft;
import net.minecraft.world.chunk.Chunk;

public class MapChunkCache {
    private int width;
    private int height;
    private Chunk lastPlayerChunk = null;
    private MapChunk[] mapChunks;
    private boolean loaded = false;
    private IMap minimap;

    public MapChunkCache(int width, int height, IMap minimap) {
        this.width = width;
        this.height = height;
        this.mapChunks = new MapChunk[width * height];
        this.minimap = minimap;
    }

    public void centerChunks(int playerX, int playerZ) {
        Chunk currentChunk = Minecraft.func_71410_x().field_71441_e.func_72938_d(playerX, playerZ);
        if (currentChunk != this.lastPlayerChunk) {
            if (this.lastPlayerChunk == null) {
                this.fillAllChunks(playerX, playerZ);
                this.lastPlayerChunk = currentChunk;
                return;
            }
            int middleX = this.width / 2;
            int middleZ = this.height / 2;
            int movedX = currentChunk.field_76635_g - this.lastPlayerChunk.field_76635_g;
            int movedZ = currentChunk.field_76647_h - this.lastPlayerChunk.field_76647_h;
            if (Math.abs(movedX) < this.width && Math.abs(movedZ) < this.height && currentChunk.field_76637_e.equals(this.lastPlayerChunk.field_76637_e)) {
                int x;
                int z;
                this.moveX(movedX);
                this.moveZ(movedZ);
                for (z = movedZ > 0 ? this.height - movedZ : 0; z < (movedZ > 0 ? this.height : -movedZ); ++z) {
                    for (x = 0; x < this.width; ++x) {
                        this.mapChunks[x + z * this.width] = new MapChunk(currentChunk.field_76635_g - (middleX - x), currentChunk.field_76647_h - (middleZ - z));
                    }
                }
                for (z = 0; z < this.height; ++z) {
                    for (x = movedX > 0 ? this.width - movedX : 0; x < (movedX > 0 ? this.width : -movedX); ++x) {
                        this.mapChunks[x + z * this.width] = new MapChunk(currentChunk.field_76635_g - (middleX - x), currentChunk.field_76647_h - (middleZ - z));
                    }
                }
            } else {
                this.fillAllChunks(playerX, playerZ);
            }
            this.lastPlayerChunk = currentChunk;
        }
    }

    public void fillAllChunks(int playerX, int playerZ) {
        Chunk currentChunk = Minecraft.func_71410_x().field_71441_e.func_72938_d(playerX, playerZ);
        int middleX = this.width / 2;
        int middleZ = this.height / 2;
        for (int z = 0; z < this.height; ++z) {
            for (int x = 0; x < this.width; ++x) {
                this.mapChunks[x + z * this.width] = new MapChunk(currentChunk.field_76635_g - (middleX - x), currentChunk.field_76647_h - (middleZ - z));
            }
        }
        this.loaded = true;
    }

    public void moveX(int offset) {
        if (offset > 0) {
            System.arraycopy(this.mapChunks, offset, this.mapChunks, 0, this.mapChunks.length - offset);
        } else if (offset < 0) {
            System.arraycopy(this.mapChunks, 0, this.mapChunks, -offset, this.mapChunks.length + offset);
        }
    }

    public void moveZ(int offset) {
        if (offset > 0) {
            System.arraycopy(this.mapChunks, offset * this.width, this.mapChunks, 0, this.mapChunks.length - offset * this.width);
        } else if (offset < 0) {
            System.arraycopy(this.mapChunks, 0, this.mapChunks, -offset * this.width, this.mapChunks.length + offset * this.width);
        }
    }

    public void calculateChunks(boolean realTimeUpdate) {
        if (!this.loaded) {
            return;
        }
        for (int z = this.height - 1; z >= 0; --z) {
            for (int x = 0; x < this.width; ++x) {
                this.mapChunks[x + z * this.width].calculateChunk(this.minimap, realTimeUpdate);
            }
        }
    }
}

