/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import com.thevoxelbox.voxelmap.interfaces.IMap;
import net.minecraft.client.Minecraft;
import net.minecraft.world.chunk.Chunk;

public class MapChunk {
    private int x = 0;
    private int z = 0;
    private int width;
    private int height;
    private Chunk chunk;
    private boolean isLoaded = false;

    public MapChunk(int x, int z) {
        this.x = x;
        this.z = z;
        this.chunk = Minecraft.func_71410_x().field_71441_e.func_72964_e(x, z);
        this.isLoaded = this.chunk.field_76636_d;
    }

    public void calculateChunk(IMap minimap, boolean realTimeUpdate) {
        if (this.hasChunkLoadedOrUnloaded() || realTimeUpdate && this.hasChunkChanged()) {
            minimap.chunkCalc(this.chunk);
            if (realTimeUpdate) {
                this.chunk.field_76643_l = false;
            }
        }
    }

    private boolean hasChunkLoadedOrUnloaded() {
        boolean hasChanged = false;
        if (!this.isLoaded) {
            this.chunk = Minecraft.func_71410_x().field_71441_e.func_72964_e(this.x, this.z);
            if (this.chunk.field_76636_d) {
                this.isLoaded = true;
                hasChanged = true;
            }
        } else if (this.isLoaded && !this.chunk.field_76636_d) {
            this.isLoaded = false;
            hasChanged = true;
        }
        return hasChanged;
    }

    private boolean hasChunkChanged() {
        boolean hasChanged = false;
        if (this.chunk.field_76636_d && this.chunk.field_76643_l) {
            hasChanged = true;
        }
        return hasChanged;
    }
}

