/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import com.thevoxelbox.voxelmap.interfaces.IDimensionManager;
import com.thevoxelbox.voxelmap.interfaces.IVoxelMap;
import com.thevoxelbox.voxelmap.util.Dimension;
import com.thevoxelbox.voxelmap.util.Waypoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.world.WorldProvider;

public class DimensionManager
implements IDimensionManager {
    IVoxelMap master;
    public ArrayList<Dimension> dimensions;

    public DimensionManager(IVoxelMap master) {
        this.master = master;
        this.dimensions = new ArrayList();
    }

    @Override
    public ArrayList<Dimension> getDimensions() {
        return this.dimensions;
    }

    @Override
    public void populateDimensions() {
        this.dimensions.clear();
        for (int t = -1; t <= 1; ++t) {
            String name = "notLoaded";
            WorldProvider provider = null;
            try {
                provider = WorldProvider.func_76570_a((int)t);
            }
            catch (Exception e) {
                provider = null;
            }
            if (provider == null) continue;
            try {
                name = provider.func_80007_l();
            }
            catch (Exception e) {
                name = "failedToLoad";
            }
            Dimension dim = new Dimension(name, t);
            this.dimensions.add(dim);
        }
        for (Waypoint pt : this.master.getWaypointManager().getWaypoints()) {
            for (Integer t : pt.dimensions) {
                if (this.getDimensionByID(t) != null) continue;
                String name = "notLoaded";
                WorldProvider provider = null;
                try {
                    provider = WorldProvider.func_76570_a((int)t);
                }
                catch (Exception e) {
                    provider = null;
                }
                if (provider == null) continue;
                try {
                    name = provider.func_80007_l();
                }
                catch (Exception e) {
                    name = "failedToLoad";
                }
                Dimension dim = new Dimension(name, t);
                this.dimensions.add(dim);
            }
        }
        Collections.sort(this.dimensions, new Comparator<Dimension>(){

            @Override
            public int compare(Dimension dim1, Dimension dim2) {
                return dim1.ID - dim2.ID;
            }
        });
    }

    @Override
    public void enteredDimension(int ID) {
        Dimension dim = this.getDimensionByID(ID);
        if (dim == null) {
            dim = new Dimension("notLoaded", ID);
            this.dimensions.add(dim);
            Collections.sort(this.dimensions, new Comparator<Dimension>(){

                @Override
                public int compare(Dimension dim1, Dimension dim2) {
                    return dim1.ID - dim2.ID;
                }
            });
        }
        if (dim.name.equals("notLoaded") || dim.name.equals("failedToLoad")) {
            try {
                dim.name = Minecraft.func_71410_x().field_71441_e.field_73011_w.func_80007_l();
            }
            catch (Exception e) {
                dim.name = "dimension " + ID + "(" + Minecraft.func_71410_x().field_71441_e.field_73011_w.getClass().getSimpleName() + ")";
            }
        }
    }

    @Override
    public Dimension getDimensionByID(int ID) {
        for (Dimension dim : this.dimensions) {
            if (dim.ID != ID) continue;
            return dim;
        }
        return null;
    }

    public Dimension getDimensionByName(String name) {
        for (Dimension dim : this.dimensions) {
            if (!dim.name.equals(name)) continue;
            return dim;
        }
        return null;
    }
}

