/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import com.thevoxelbox.voxelmap.MapSettingsManager;
import com.thevoxelbox.voxelmap.util.EntityWaypointContainer;
import com.thevoxelbox.voxelmap.util.Waypoint;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderWaypointContainer
extends Render {
    MapSettingsManager options = null;

    public RenderWaypointContainer(MapSettingsManager options) {
        this.options = options;
    }

    public ResourceLocation func_110775_a(Entity par1Entity) {
        return new ResourceLocation("", "");
    }

    public void doRenderWaypoints(EntityWaypointContainer par1EntityWaypointContainer, double baseX, double baseY, double baseZ, float par8, float par9) {
        for (Waypoint pt : par1EntityWaypointContainer.wayPts) {
            if (!pt.isActive()) continue;
            int x = pt.getX();
            int z = pt.getZ();
            int y = pt.getY();
            if (this.options.showBeacons && par1EntityWaypointContainer.field_70170_p.func_72938_d((int)x, (int)z).field_76636_d) {
                double bottomOfWorld = 0.0 - RenderManager.field_78726_c;
                this.renderBeam(pt, (double)x - RenderManager.field_78725_b, bottomOfWorld, (double)z - RenderManager.field_78723_d, 64.0f);
            }
            if (!this.options.showWaypoints || this.options.game.field_71474_y.field_74319_N) continue;
            String label = pt.name;
            this.renderLabel(pt, label, baseX + (double)x, baseY + (double)y + 1.0, baseZ + (double)z, 64);
        }
    }

    public void renderBeam(Waypoint par1EntityWaypoint, double baseX, double baseY, double baseZ, float par8) {
        Tessellator tesselator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        int height = 256;
        float brightness = 0.06f;
        double topWidthFactor = 1.05;
        double bottomWidthFactor = 1.05;
        float r = par1EntityWaypoint.red;
        float b = par1EntityWaypoint.blue;
        float g = par1EntityWaypoint.green;
        for (int width = 0; width < 4; ++width) {
            tesselator.func_78371_b(5);
            tesselator.func_78369_a(r * brightness, g * brightness, b * brightness, 0.8f);
            double var32 = 0.1 + (double)width * 0.2;
            var32 *= topWidthFactor;
            double var34 = 0.1 + (double)width * 0.2;
            var34 *= bottomWidthFactor;
            for (int side = 0; side < 5; ++side) {
                double vertX2 = baseX + 0.5 - var32;
                double vertZ2 = baseZ + 0.5 - var32;
                if (side == 1 || side == 2) {
                    vertX2 += var32 * 2.0;
                }
                if (side == 2 || side == 3) {
                    vertZ2 += var32 * 2.0;
                }
                double vertX1 = baseX + 0.5 - var34;
                double vertZ1 = baseZ + 0.5 - var34;
                if (side == 1 || side == 2) {
                    vertX1 += var34 * 2.0;
                }
                if (side == 2 || side == 3) {
                    vertZ1 += var34 * 2.0;
                }
                tesselator.func_78377_a(vertX1, baseY + 0.0, vertZ1);
                tesselator.func_78377_a(vertX2, baseY + (double)height, vertZ2);
            }
            tesselator.func_78381_a();
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2912);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    protected void renderLabel(Waypoint par1EntityWaypoint, String par2Str, double par3, double par5, double par7, int par9) {
        GL11.glAlphaFunc((int)516, (float)0.1f);
        double distance = Math.sqrt(par1EntityWaypoint.getDistanceSqToEntity((Entity)this.field_76990_c.field_78734_h));
        if (distance <= (double)this.options.maxWaypointDisplayDistance || this.options.maxWaypointDisplayDistance < 0) {
            par2Str = par2Str + " (" + (int)distance + "m)";
            double maxDistance = (double)(this.options.game.field_71474_y.func_74296_a(GameSettings.Options.RENDER_DISTANCE) * 16.0f) * 0.75;
            double adjustedDistance = distance;
            if (distance > maxDistance) {
                par3 = par3 / distance * maxDistance;
                par5 = par5 / distance * maxDistance;
                par7 = par7 / distance * maxDistance;
                adjustedDistance = maxDistance;
            }
            FontRenderer fontRenderer = this.func_76983_a();
            float var14 = ((float)adjustedDistance * 0.1f + 1.0f) * 0.0266f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)par3 + 0.5f), (float)((float)par5 + 1.3f), (float)((float)par7 + 0.5f));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-var14), (float)(-var14), (float)var14);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2912);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator var15 = Tessellator.field_78398_a;
            int var16 = 0;
            GL11.glDisable((int)3553);
            int var17 = fontRenderer.func_78256_a(par2Str) / 2;
            GL11.glEnable((int)2929);
            if (distance < maxDistance) {
                GL11.glDepthMask((boolean)true);
            }
            GL11.glEnable((int)32823);
            GL11.glPolygonOffset((float)1.0f, (float)3.0f);
            var15.func_78382_b();
            var15.func_78369_a(par1EntityWaypoint.red, par1EntityWaypoint.green, par1EntityWaypoint.blue, 0.6f);
            var15.func_78377_a((double)(-var17 - 2), (double)(-2 + var16), 0.0);
            var15.func_78377_a((double)(-var17 - 2), (double)(9 + var16), 0.0);
            var15.func_78377_a((double)(var17 + 2), (double)(9 + var16), 0.0);
            var15.func_78377_a((double)(var17 + 2), (double)(-2 + var16), 0.0);
            var15.func_78381_a();
            GL11.glPolygonOffset((float)1.0f, (float)1.0f);
            var15.func_78382_b();
            var15.func_78369_a(0.0f, 0.0f, 0.0f, 0.15f);
            var15.func_78377_a((double)(-var17 - 1), (double)(-1 + var16), 0.0);
            var15.func_78377_a((double)(-var17 - 1), (double)(8 + var16), 0.0);
            var15.func_78377_a((double)(var17 + 1), (double)(8 + var16), 0.0);
            var15.func_78377_a((double)(var17 + 1), (double)(-1 + var16), 0.0);
            var15.func_78381_a();
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glPolygonOffset((float)1.0f, (float)7.0f);
            var15.func_78382_b();
            var15.func_78369_a(par1EntityWaypoint.red, par1EntityWaypoint.green, par1EntityWaypoint.blue, 0.15f);
            var15.func_78377_a((double)(-var17 - 2), (double)(-2 + var16), 0.0);
            var15.func_78377_a((double)(-var17 - 2), (double)(9 + var16), 0.0);
            var15.func_78377_a((double)(var17 + 2), (double)(9 + var16), 0.0);
            var15.func_78377_a((double)(var17 + 2), (double)(-2 + var16), 0.0);
            var15.func_78381_a();
            GL11.glPolygonOffset((float)1.0f, (float)5.0f);
            var15.func_78382_b();
            var15.func_78369_a(0.0f, 0.0f, 0.0f, 0.15f);
            var15.func_78377_a((double)(-var17 - 1), (double)(-1 + var16), 0.0);
            var15.func_78377_a((double)(-var17 - 1), (double)(8 + var16), 0.0);
            var15.func_78377_a((double)(var17 + 1), (double)(8 + var16), 0.0);
            var15.func_78377_a((double)(var17 + 1), (double)(-1 + var16), 0.0);
            var15.func_78381_a();
            GL11.glDisable((int)32823);
            GL11.glEnable((int)3553);
            fontRenderer.func_78276_b(par2Str, -fontRenderer.func_78256_a(par2Str) / 2, var16, -3355444);
            GL11.glEnable((int)2929);
            fontRenderer.func_78276_b(par2Str, -fontRenderer.func_78256_a(par2Str) / 2, var16, -1);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2912);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public void func_76986_a(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.doRenderWaypoints((EntityWaypointContainer)par1Entity, par2, par4, par6, par8, par9);
    }
}

