/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.gui;

import com.thevoxelbox.voxelmap.gui.GuiSlotDimensions;
import com.thevoxelbox.voxelmap.gui.GuiWaypoints;
import com.thevoxelbox.voxelmap.gui.overridden.GuiScreenMinimap;
import com.thevoxelbox.voxelmap.interfaces.IColorManager;
import com.thevoxelbox.voxelmap.interfaces.IVoxelMap;
import com.thevoxelbox.voxelmap.interfaces.IWaypointManager;
import com.thevoxelbox.voxelmap.util.Dimension;
import com.thevoxelbox.voxelmap.util.GLUtils;
import com.thevoxelbox.voxelmap.util.I18nUtils;
import com.thevoxelbox.voxelmap.util.Waypoint;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiScreenAddWaypoint
extends GuiScreenMinimap {
    IVoxelMap master;
    IWaypointManager waypointManager;
    IColorManager colorManager;
    private GuiWaypoints parentGui;
    private GuiSlotDimensions dimensionList;
    protected Dimension selectedDimension = null;
    private String tooltip = null;
    private GuiTextField waypointName;
    private GuiTextField waypointX;
    private GuiTextField waypointZ;
    private GuiTextField waypointY;
    private GuiButton buttonEnabled;
    protected Waypoint waypoint;
    private boolean choosingColor = false;
    private float red;
    private float green;
    private float blue;
    private boolean enabled;
    private Random generator = new Random();

    public GuiScreenAddWaypoint(IVoxelMap master, GuiWaypoints par1GuiScreen, Waypoint par2Waypoint) {
        this.master = master;
        this.waypointManager = master.getWaypointManager();
        this.colorManager = master.getColorManager();
        this.parentGui = par1GuiScreen;
        this.waypoint = par2Waypoint;
        this.red = this.waypoint.red;
        this.green = this.waypoint.green;
        this.blue = this.waypoint.blue;
        this.enabled = this.waypoint.enabled;
    }

    public void func_73876_c() {
        this.waypointName.func_146178_a();
        this.waypointX.func_146178_a();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.getButtonList().clear();
        this.getButtonList().add(new GuiButton(0, this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("addServer.add")));
        this.getButtonList().add(new GuiButton(1, this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("gui.cancel")));
        this.waypointName = new GuiTextField(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0 + 13, 200, 20);
        this.waypointName.func_146195_b(true);
        this.waypointName.func_146180_a(this.waypoint.name);
        this.waypointX = new GuiTextField(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 41 + 13, 56, 20);
        this.waypointX.func_146203_f(128);
        this.waypointX.func_146180_a("" + this.waypoint.getX());
        this.waypointZ = new GuiTextField(this.getFontRenderer(), this.getWidth() / 2 - 28, this.getHeight() / 6 + 41 + 13, 56, 20);
        this.waypointZ.func_146203_f(128);
        this.waypointZ.func_146180_a("" + this.waypoint.getZ());
        this.waypointY = new GuiTextField(this.getFontRenderer(), this.getWidth() / 2 + 44, this.getHeight() / 6 + 41 + 13, 56, 20);
        this.waypointY.func_146203_f(128);
        this.waypointY.func_146180_a("" + this.waypoint.getY());
        this.buttonEnabled = new GuiButton(2, this.getWidth() / 2 - 101, this.getHeight() / 6 + 82 + 6, 100, 20, "Enabled: " + (this.waypoint.enabled ? "On" : "Off"));
        this.getButtonList().add(this.buttonEnabled);
        ((GuiButton)this.getButtonList().get((int)0)).field_146124_l = this.waypointName.func_146179_b().length() > 0;
        this.dimensionList = new GuiSlotDimensions(this);
        this.dimensionList.registerScrollButtons(7, 8);
    }

    @Override
    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            if (par1GuiButton.field_146127_k == 2) {
                boolean bl = this.waypoint.enabled = !this.waypoint.enabled;
            }
            if (par1GuiButton.field_146127_k == 1) {
                this.waypoint.red = this.red;
                this.waypoint.green = this.green;
                this.waypoint.blue = this.blue;
                this.waypoint.enabled = this.enabled;
                if (this.parentGui != null) {
                    this.parentGui.func_73878_a(false, 0);
                } else {
                    this.getMinecraft().func_147108_a(null);
                }
            } else if (par1GuiButton.field_146127_k == 0) {
                this.waypoint.name = this.waypointName.func_146179_b();
                this.waypoint.setX(Integer.parseInt(this.waypointX.func_146179_b()));
                this.waypoint.setZ(Integer.parseInt(this.waypointZ.func_146179_b()));
                this.waypoint.setY(Integer.parseInt(this.waypointY.func_146179_b()));
                if (this.parentGui != null) {
                    this.parentGui.func_73878_a(true, 0);
                } else {
                    this.waypointManager.addWaypoint(this.waypoint);
                    this.getMinecraft().func_147108_a(null);
                }
            }
        }
    }

    protected void func_73869_a(char par1, int par2) {
        this.waypointName.func_146201_a(par1, par2);
        this.waypointX.func_146201_a(par1, par2);
        this.waypointZ.func_146201_a(par1, par2);
        this.waypointY.func_146201_a(par1, par2);
        if (par1 == '\t') {
            if (this.waypointName.func_146206_l()) {
                this.waypointName.func_146195_b(false);
                this.waypointX.func_146195_b(true);
                this.waypointZ.func_146195_b(false);
                this.waypointY.func_146195_b(false);
            } else if (this.waypointX.func_146206_l()) {
                this.waypointName.func_146195_b(false);
                this.waypointX.func_146195_b(false);
                this.waypointZ.func_146195_b(true);
                this.waypointY.func_146195_b(false);
            } else if (this.waypointZ.func_146206_l()) {
                this.waypointName.func_146195_b(false);
                this.waypointX.func_146195_b(false);
                this.waypointZ.func_146195_b(false);
                this.waypointY.func_146195_b(true);
            } else if (this.waypointY.func_146206_l()) {
                this.waypointName.func_146195_b(true);
                this.waypointX.func_146195_b(false);
                this.waypointZ.func_146195_b(false);
                this.waypointY.func_146195_b(false);
            }
        }
        if (par1 == '\r') {
            this.func_146284_a((GuiButton)this.getButtonList().get(0));
        }
        boolean acceptable = this.waypointName.func_146179_b().length() > 0;
        try {
            int x = Integer.parseInt(this.waypointX.func_146179_b());
            acceptable = acceptable;
        }
        catch (NumberFormatException e) {
            acceptable = false;
        }
        try {
            int z = Integer.parseInt(this.waypointZ.func_146179_b());
            acceptable = acceptable;
        }
        catch (NumberFormatException e) {
            acceptable = false;
        }
        try {
            int y = Integer.parseInt(this.waypointY.func_146179_b());
            acceptable = acceptable;
        }
        catch (NumberFormatException e) {
            acceptable = false;
        }
        ((GuiButton)this.getButtonList().get((int)0)).field_146124_l = acceptable;
        if (par2 == 1) {
            this.waypoint.red = this.red;
            this.waypoint.green = this.green;
            this.waypoint.blue = this.blue;
            this.waypoint.enabled = this.enabled;
        }
        super.func_73869_a(par1, par2);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        if (!this.choosingColor) {
            super.func_73864_a(par1, par2, par3);
            this.waypointName.func_146192_a(par1, par2, par3);
            this.waypointX.func_146192_a(par1, par2, par3);
            this.waypointZ.func_146192_a(par1, par2, par3);
            this.waypointY.func_146192_a(par1, par2, par3);
            if (par1 >= this.getWidth() / 2 + 85 && par1 <= this.getWidth() / 2 + 101 && par2 >= this.getHeight() / 6 + 82 + 11 && par2 <= this.getHeight() / 6 + 82 + 21) {
                this.choosingColor = true;
            }
        } else if (par1 >= this.getWidth() / 2 - 128 && par1 <= this.getWidth() / 2 + 128 && par2 >= this.getHeight() / 2 - 128 && par2 <= this.getHeight() / 2 + 128) {
            int color = this.colorManager.getColorPicker().getRGB(par1 - (this.getWidth() / 2 - 128), par2 - (this.getHeight() / 2 - 128));
            this.waypoint.red = (float)(color >> 16 & 0xFF) / 255.0f;
            this.waypoint.green = (float)(color >> 8 & 0xFF) / 255.0f;
            this.waypoint.blue = (float)(color >> 0 & 0xFF) / 255.0f;
            this.choosingColor = false;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.drawMap();
        this.tooltip = null;
        this.buttonEnabled.field_146126_j = I18nUtils.getString("minimap.waypoints.enabled") + " " + (this.waypoint.enabled ? I18nUtils.getString("options.on") : I18nUtils.getString("options.off"));
        this.func_146276_q_();
        this.dimensionList.drawScreen(par1, par2, par3);
        this.func_73732_a(this.getFontRenderer(), this.parentGui != null && this.parentGui.editClicked ? I18nUtils.getString("minimap.waypoints.edit") : I18nUtils.getString("minimap.waypoints.new"), this.getWidth() / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.getFontRenderer(), I18nUtils.getString("minimap.waypoints.name"), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0, 0xA0A0A0);
        this.func_73731_b(this.getFontRenderer(), I18nUtils.getString("X"), this.getWidth() / 2 - 100, this.getHeight() / 6 + 41, 0xA0A0A0);
        this.func_73731_b(this.getFontRenderer(), I18nUtils.getString("Z"), this.getWidth() / 2 - 28, this.getHeight() / 6 + 41, 0xA0A0A0);
        this.func_73731_b(this.getFontRenderer(), I18nUtils.getString("Y"), this.getWidth() / 2 + 44, this.getHeight() / 6 + 41, 0xA0A0A0);
        this.func_73731_b(this.getFontRenderer(), I18nUtils.getString("minimap.waypoints.choosecolor"), this.getWidth() / 2 + 10, this.getHeight() / 6 + 82 + 11, 0xA0A0A0);
        this.waypointName.func_146194_f();
        this.waypointX.func_146194_f();
        this.waypointZ.func_146194_f();
        this.waypointY.func_146194_f();
        GL11.glColor4f((float)this.waypoint.red, (float)this.waypoint.green, (float)this.waypoint.blue, (float)1.0f);
        GLUtils.disp(-1);
        this.func_73729_b(this.getWidth() / 2 + 85, this.getHeight() / 6 + 82 + 11, 0, 0, 16, 10);
        super.func_73863_a(par1, par2, par3);
        if (this.choosingColor) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GLUtils.img(new ResourceLocation("voxelmap", "images/colorPicker.png"));
            this.func_73729_b(this.getWidth() / 2 - 128, this.getHeight() / 2 - 128, 0, 0, 256, 256);
        }
        this.drawTooltip(this.tooltip, par1, par2);
    }

    public void setSelectedDimension(Dimension dimension) {
        this.selectedDimension = dimension;
    }

    public void toggleDimensionSelected() {
        if (this.waypoint.dimensions.size() > 1 && this.waypoint.dimensions.contains(this.selectedDimension.ID) && this.selectedDimension.ID != Minecraft.func_71410_x().field_71439_g.field_71093_bK) {
            this.waypoint.dimensions.remove(new Integer(this.selectedDimension.ID));
        } else if (!this.waypoint.dimensions.contains(this.selectedDimension.ID)) {
            this.waypoint.dimensions.add(new Integer(this.selectedDimension.ID));
        }
    }

    protected void drawTooltip(String par1Str, int par2, int par3) {
        if (par1Str != null) {
            int var4 = par2 + 12;
            int var5 = par3 - 12;
            int var6 = this.getFontRenderer().func_78256_a(par1Str);
            this.func_73733_a(var4 - 3, var5 - 3, var4 + var6 + 3, var5 + 8 + 3, -1073741824, -1073741824);
            this.getFontRenderer().func_78261_a(par1Str, var4, var5, -1);
        }
    }

    static String setTooltip(GuiScreenAddWaypoint par0GuiWaypoint, String par1Str) {
        par0GuiWaypoint.tooltip = par1Str;
        return par0GuiWaypoint.tooltip;
    }
}

