/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap;

import com.thevoxelbox.voxelmap.ColorManager;
import com.thevoxelbox.voxelmap.Map;
import com.thevoxelbox.voxelmap.MapSettingsManager;
import com.thevoxelbox.voxelmap.Radar;
import com.thevoxelbox.voxelmap.RadarSettingsManager;
import com.thevoxelbox.voxelmap.WaypointManager;
import com.thevoxelbox.voxelmap.interfaces.AbstractVoxelMap;
import com.thevoxelbox.voxelmap.interfaces.IColorManager;
import com.thevoxelbox.voxelmap.interfaces.IDimensionManager;
import com.thevoxelbox.voxelmap.interfaces.IMap;
import com.thevoxelbox.voxelmap.interfaces.IObservableChunkChangeNotifier;
import com.thevoxelbox.voxelmap.interfaces.IRadar;
import com.thevoxelbox.voxelmap.interfaces.IVoxelMap;
import com.thevoxelbox.voxelmap.interfaces.IWaypointManager;
import com.thevoxelbox.voxelmap.util.AddonResourcePack;
import com.thevoxelbox.voxelmap.util.DimensionManager;
import com.thevoxelbox.voxelmap.util.ObservableChunkChangeNotifier;
import com.thevoxelbox.voxelmap.util.ReflectionUtils;
import java.util.List;
import net.minecraft.client.Minecraft;

public class VoxelMap
extends AbstractVoxelMap {
    private MapSettingsManager mapOptions = null;
    private RadarSettingsManager radarOptions = null;
    private IMap map = null;
    private IRadar radar = null;
    private IColorManager colorManager = null;
    private IWaypointManager waypointManager = null;
    private IDimensionManager dimensionManager = null;
    private ObservableChunkChangeNotifier chunkChangeNotifier = new ObservableChunkChangeNotifier();

    public VoxelMap(boolean showUnderMenus, boolean isFair) {
        instance = this;
        if (!Minecraft.func_71410_x().func_110442_L().func_135055_a().contains("voxelmap")) {
            AddonResourcePack voxelMapResourcePack = new AddonResourcePack("voxelmap");
            List defaultResourcePacks = (List)ReflectionUtils.getPrivateFieldValueByType(Minecraft.func_71410_x(), Minecraft.class, List.class, 1);
            defaultResourcePacks.add(voxelMapResourcePack);
            Minecraft.func_71410_x().func_110436_a();
        }
        this.mapOptions = new MapSettingsManager();
        this.mapOptions.showUnderMenus = showUnderMenus;
        this.radarOptions = new RadarSettingsManager();
        this.mapOptions.setRadarSettings(this.radarOptions);
        this.colorManager = new ColorManager(this);
        this.waypointManager = new WaypointManager(this);
        this.dimensionManager = new DimensionManager(this);
        if (ReflectionUtils.classExists("com.thevoxelbox.voxelmap.Radar") && !isFair) {
            this.radar = new Radar((IVoxelMap)this);
        }
        this.map = new Map(this);
        this.mapOptions.loadAll();
    }

    public void onTickInGame(Minecraft mc) {
        this.map.onTickInGame(mc);
    }

    @Override
    public IObservableChunkChangeNotifier getNotifier() {
        return this.chunkChangeNotifier;
    }

    @Override
    public MapSettingsManager getMapOptions() {
        return this.mapOptions;
    }

    @Override
    public RadarSettingsManager getRadarOptions() {
        return this.radarOptions;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public IRadar getRadar() {
        return this.radar;
    }

    @Override
    public IColorManager getColorManager() {
        return this.colorManager;
    }

    @Override
    public IWaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    @Override
    public IDimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    @Override
    public void setPermissions(boolean hasRadarPermission, boolean hasCavemodePermission) {
        this.map.setPermissions(hasRadarPermission, hasCavemodePermission);
    }

    @Override
    public void newSubWorldName(String name) {
        this.waypointManager.newSubWorldName(name);
    }

    @Override
    public void newSubWorldHash(String hash) {
        this.waypointManager.newSubWorldHash(hash);
    }
}

