/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.functions.GenericIterableFactory;
import cpw.mods.fml.common.registry.ExistingSubstitutionException;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.IncompatibleSubstitutionException;
import cpw.mods.fml.common.registry.RegistryDelegate;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FMLControlledNamespacedRegistry<I>
extends cw {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugRegistryEntries", "false"));
    private final Class<I> superType;
    private String optionalDefaultName;
    private I optionalDefaultObject;
    private int maxId;
    private int minId;
    private char discriminator;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private BiMap<String, I> persistentSubstitutions;
    private BiMap<String, I> activeSubstitutions = HashBiMap.create();

    FMLControlledNamespacedRegistry(String optionalDefault, int maxIdValue, int minIdValue, Class<I> type, char discriminator) {
        this.superType = type;
        this.discriminator = discriminator;
        this.optionalDefaultName = optionalDefault;
        this.maxId = maxIdValue;
        this.minId = minIdValue;
    }

    void validateContent(int maxId, String type, BitSet availabilityMap, Set<Integer> blockedIds, FMLControlledNamespacedRegistry<aji> iBlockRegistry) {
        for (I obj : this.typeSafeIterable()) {
            int id = this.getId(obj);
            String name = this.c(obj);
            if (id < 0) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s, doesn't yield an id.", type, obj, name));
            }
            if (id > maxId) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s uses the too large id %d.", type, obj, name));
            }
            if (name == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, doesn't yield a name.", type, obj, id));
            }
            if (name.isEmpty()) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, yields an empty name.", type, obj, id));
            }
            if (name.indexOf(58) == -1) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, has the non-prefixed name %s.", type, obj, id, name));
            }
            if (this.getRaw(id) != obj) {
                throw new IllegalStateException(String.format("Registry entry for id %d, name %s, doesn't yield the expected %s %s.", id, name, type, obj));
            }
            if (!this.activeSubstitutions.containsKey((Object)name) && !this.activeSubstitutions.containsValue((Object)name) && this.getRaw(name) != obj) {
                throw new IllegalStateException(String.format("Registry entry for name %s, id %d, doesn't yield the expected %s %s.", name, id, type, obj));
            }
            if (!this.activeSubstitutions.containsKey((Object)name) && !this.activeSubstitutions.containsValue((Object)name) && this.getId(name) != id) {
                throw new IllegalStateException(String.format("Registry entry for name %s doesn't yield the expected id %d.", name, id));
            }
            if (!availabilityMap.get(id)) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, name %s, marked as empty.", type, obj, id, name));
            }
            if (blockedIds.contains(id)) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, name %s, marked as dangling.", type, obj, id, name));
            }
            if (!(obj instanceof abh)) continue;
            aji block = ((abh)obj).a;
            if (iBlockRegistry.getId(block) != id) {
                throw new IllegalStateException(String.format("Registry entry for ItemBlock %s, id %d, is missing or uses the non-matching id %d.", obj, id, iBlockRegistry.getId(block)));
            }
            if (id <= 4095) continue;
            throw new IllegalStateException(String.format("ItemBlock %s uses the id %d outside the block id range", name, id));
        }
    }

    void set(FMLControlledNamespacedRegistry<I> registry) {
        if (this.superType != registry.superType) {
            throw new IllegalArgumentException("incompatible registry");
        }
        this.discriminator = registry.discriminator;
        this.optionalDefaultName = registry.optionalDefaultName;
        this.maxId = registry.maxId;
        this.minId = registry.minId;
        this.aliases.clear();
        this.aliases.putAll(registry.aliases);
        this.activeSubstitutions.clear();
        this.a = new ct();
        this.c.clear();
        for (I thing : registry.typeSafeIterable()) {
            this.addObjectRaw(registry.getId(thing), registry.c(thing), thing);
        }
        this.activeSubstitutions.putAll(registry.activeSubstitutions);
    }

    @Deprecated
    public void a(int id, String name, Object thing) {
        GameData.getMain().register(thing, name, id);
    }

    @Deprecated
    public void a(Object objName, Object obj) {
        String name = (String)objName;
        I thing = this.cast(obj);
        if (name == null) {
            throw new NullPointerException("Can't use a null-name for the registry.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Can't use an empty name for the registry.");
        }
        if (thing == null) {
            throw new NullPointerException("Can't add null-object to the registry.");
        }
        name = FMLControlledNamespacedRegistry.c((String)name);
        String existingName = this.c(thing);
        if (existingName == null) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), not resolvable", name, thing);
        } else if (existingName.equals(name)) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), already added", name, thing);
        } else {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), adding alias to %s instead", name, thing, existingName);
            this.addAlias(name, existingName);
        }
    }

    public I a(String name) {
        I object = this.getRaw(name);
        return object == null ? this.optionalDefaultObject : object;
    }

    public I a(int id) {
        I object = this.getRaw(id);
        return object == null ? this.optionalDefaultObject : object;
    }

    @Deprecated
    public I get(int id) {
        return this.a(id);
    }

    @Deprecated
    public I get(String name) {
        return this.a(name);
    }

    public int getId(I thing) {
        return this.b(thing);
    }

    public I getRaw(int id) {
        return this.cast(super.a(id));
    }

    private I cast(Object obj) {
        return (I)obj;
    }

    public I getRaw(String name) {
        I ret = this.cast(super.a(name));
        if (ret == null && (name = this.aliases.get(name)) != null) {
            return this.getRaw(name);
        }
        return ret;
    }

    public boolean b(String name) {
        boolean ret = super.b(name);
        if (!ret && (name = this.aliases.get(name)) != null) {
            return this.b(name);
        }
        return ret;
    }

    public int getId(String itemName) {
        I obj = this.getRaw(itemName);
        if (obj == null) {
            return -1;
        }
        return this.getId(obj);
    }

    @Deprecated
    public boolean contains(String itemName) {
        return this.b(itemName);
    }

    public Iterable<I> typeSafeIterable() {
        return GenericIterableFactory.newCastingIterable(super.iterator(), this.superType);
    }

    public void serializeInto(Map<String, Integer> idMapping) {
        for (I thing : this.typeSafeIterable()) {
            idMapping.put(this.discriminator + this.c(thing), this.getId(thing));
        }
    }

    public Map<String, String> getAliases() {
        return ImmutableMap.copyOf(this.aliases);
    }

    int add(int id, String name, I thing, BitSet availabilityMap) {
        if (name == null) {
            throw new NullPointerException(String.format("Can't use a null-name for the registry, object %s.", thing));
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't use an empty name for the registry, object %s.", thing));
        }
        if (name.indexOf(58) == -1) {
            throw new IllegalArgumentException(String.format("Can't add the name (%s) without a prefix, object %s", name, thing));
        }
        if (thing == null) {
            throw new NullPointerException(String.format("Can't add null-object to the registry, name %s.", name));
        }
        if (name.equals(this.optionalDefaultName) && this.optionalDefaultObject == null) {
            this.optionalDefaultObject = thing;
        }
        if (this.getPersistentSubstitutions().containsValue(thing)) {
            throw new IllegalArgumentException(String.format("The object %s (%s) cannot be added to the registry. It is already being used as a substitute for %s", thing.getClass(), name, this.getPersistentSubstitutions().inverse().get(thing)));
        }
        int idToUse = id;
        if (idToUse < 0 || availabilityMap.get(idToUse)) {
            idToUse = availabilityMap.nextClearBit(this.minId);
        }
        if (idToUse > this.maxId) {
            throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", idToUse));
        }
        if (this.getRaw(name) == thing) {
            FMLLog.bigWarning("The object %s has been registered twice for the same name %s.", thing, name);
            return this.getId(thing);
        }
        if (this.getRaw(name) != null) {
            throw new IllegalArgumentException(String.format("The name %s has been registered twice, for %s and %s.", name, this.getRaw(name), thing));
        }
        if (this.getId(thing) >= 0) {
            int foundId = this.getId(thing);
            I otherThing = this.getRaw(foundId);
            throw new IllegalArgumentException(String.format("The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", thing, System.identityHashCode(thing), this.c(thing), name, otherThing, System.identityHashCode(otherThing)));
        }
        if (GameData.isFrozen(this)) {
            FMLLog.bigWarning("The object %s (name %s) is being added too late.", thing, name);
        }
        if (this.activeSubstitutions.containsKey((Object)name)) {
            thing = this.activeSubstitutions.get((Object)name);
        }
        this.addObjectRaw(idToUse, name, thing);
        if (DEBUG) {
            FMLLog.finer("Registry add: %s %d %s (req. id %d)", name, idToUse, thing, id);
        }
        return idToUse;
    }

    void addAlias(String from, String to) {
        this.aliases.put(from, to);
        if (DEBUG) {
            FMLLog.finer("Registry alias: %s -> %s", from, to);
        }
    }

    Map<String, Integer> getEntriesNotIn(FMLControlledNamespacedRegistry<I> registry) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (I thing : this.typeSafeIterable()) {
            if (registry.b.containsKey(thing) || registry.activeSubstitutions.containsKey((Object)this.c(thing))) continue;
            ret.put(this.c(thing), this.getId(thing));
        }
        return ret;
    }

    void dump() {
        if (!DEBUG) {
            return;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (I thing : this.typeSafeIterable()) {
            ids.add(this.getId(thing));
        }
        Collections.sort(ids);
        Iterator<Object> i$ = ids.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            I thing = this.getRaw(id);
            FMLLog.finer("Registry: %d %s %s", id, this.c(thing), thing);
        }
    }

    private void addObjectRaw(int id, String name, I thing) {
        if (name == null) {
            throw new NullPointerException("The name to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (thing == null) {
            throw new NullPointerException("The object to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (!this.superType.isInstance(thing)) {
            throw new IllegalArgumentException("The object to be added to the registry is not of the right type. Reflection/ASM hackery? Registry bug?");
        }
        this.a.a(thing, id);
        super.a((Object)name, thing);
    }

    public I getDefaultValue() {
        return this.optionalDefaultObject;
    }

    public RegistryDelegate<I> getDelegate(I thing, Class<I> clazz) {
        return GameData.buildDelegate(thing, clazz);
    }

    void activateSubstitution(String nameToReplace) {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace)) {
            this.activeSubstitutions.put((Object)nameToReplace, this.getPersistentSubstitutions().get((Object)nameToReplace));
        }
    }

    void addSubstitutionAlias(String modId, String nameToReplace, Object toReplace) throws ExistingSubstitutionException {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace) || this.getPersistentSubstitutions().containsValue(toReplace)) {
            FMLLog.severe("The substitution of %s has already occured. You cannot duplicate substitutions", nameToReplace);
            throw new ExistingSubstitutionException(nameToReplace, toReplace);
        }
        I replacement = this.cast(toReplace);
        I original = this.getRaw(nameToReplace);
        if (original == null) {
            throw new NullPointerException("The replacement target is not present. This won't work");
        }
        if (!original.getClass().isAssignableFrom(replacement.getClass())) {
            FMLLog.severe("The substitute %s for %s (type %s) is type incompatible. This won't work", replacement.getClass().getName(), nameToReplace, original.getClass().getName());
            throw new IncompatibleSubstitutionException(nameToReplace, replacement, original);
        }
        int existingId = this.getId(replacement);
        if (existingId != -1) {
            FMLLog.severe("The substitute %s for %s is registered into the game independently. This won't work", replacement.getClass().getName(), nameToReplace);
            throw new IllegalArgumentException("The object substitution is already registered. This won't work");
        }
        this.getPersistentSubstitutions().put((Object)nameToReplace, replacement);
    }

    public void serializeSubstitutions(Set<String> blockSubs) {
        blockSubs.addAll(this.activeSubstitutions.keySet());
    }

    private BiMap<String, I> getPersistentSubstitutions() {
        if (this.persistentSubstitutions == null) {
            this.persistentSubstitutions = GameData.getMain().getPersistentSubstitutionMap(this.superType);
        }
        return this.persistentSubstitutions;
    }

    public Iterator<I> iterator() {
        return Iterators.concat((Iterator)super.iterator(), this.getPersistentSubstitutions().values().iterator());
    }
}

