/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.thermalexpansion;

import java.util.HashMap;
import java.util.List;
import neiplugins.common.FuelTooltip;
import neiplugins.common.SimpleFuelContextHelper;
import neiplugins.common.SimpleFuelHelper;
import neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ThermalExpansionFuelHelper {
    private static Utils.MethodInvoker Compression_getFuelEnergy;
    private static Utils.MethodInvoker Compression_getCoolantEnergy;
    private static Utils.MethodInvoker Compression_isValidFuel;
    private static Utils.MethodInvoker Compression_isValidCoolant;
    private static Utils.MethodInvoker Reactant_getFuelEnergy;
    private static Utils.MethodInvoker Reactant_getReactantEnergy;
    private static Utils.MethodInvoker Reactant_isValidFuel;
    private static Utils.MethodInvoker Magmatic_getFuelEnergy;
    private static Utils.MethodInvoker Magmatic_isValidFuel;
    private static Utils.MethodInvoker Steam_getEnergyValue;
    private static Utils.MethodInvoker Enervation_getEnergyValue;

    public static void registerFuelHelpers() {
        Class cls = Utils.findClass("thermalexpansion.block.dynamo.TileDynamoCompression");
        if (cls != null) {
            Compression_getFuelEnergy = Utils.getMethodInvoker(cls, "getFuelEnergy", null, FluidStack.class);
            Compression_getCoolantEnergy = Utils.getMethodInvoker(cls, "getCoolantEnergy", null, FluidStack.class);
            Compression_isValidFuel = Utils.getMethodInvoker(cls, "isValidFuel", null, FluidStack.class);
            Compression_isValidCoolant = Utils.getMethodInvoker(cls, "isValidCoolant", null, FluidStack.class);
        }
        if ((cls = Utils.findClass("thermalexpansion.block.dynamo.TileDynamoReactant")) != null) {
            Reactant_getFuelEnergy = Utils.getMethodInvoker(cls, "getFuelEnergy", null, FluidStack.class);
            Reactant_getReactantEnergy = Utils.getMethodInvoker(cls, "getReactantEnergy", null, ItemStack.class);
            Reactant_isValidFuel = Utils.getMethodInvoker(cls, "isValidFuel", null, FluidStack.class);
        }
        if ((cls = Utils.findClass("thermalexpansion.block.dynamo.TileDynamoMagmatic")) != null) {
            Magmatic_getFuelEnergy = Utils.getMethodInvoker(cls, "getFuelEnergy", null, FluidStack.class);
            Magmatic_isValidFuel = Utils.getMethodInvoker(cls, "isValidFuel", null, FluidStack.class);
        }
        if ((cls = Utils.findClass("thermalexpansion.block.dynamo.TileDynamoSteam")) != null) {
            Steam_getEnergyValue = Utils.getMethodInvoker(cls, "getEnergyValue", null, ItemStack.class);
        }
        if ((cls = Utils.findClass("thermalexpansion.block.dynamo.TileDynamoEnervation")) != null) {
            Enervation_getEnergyValue = Utils.getMethodInvoker(cls, "getEnergyValue", null, ItemStack.class);
        }
        if (Compression_getFuelEnergy != null && Compression_isValidFuel != null && Compression_getCoolantEnergy != null && Compression_isValidCoolant != null) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("te.DynamoCompression", "Compression Dynamo", null){

                @Override
                public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                    int fuelValue;
                    if (((Boolean)Compression_isValidFuel.invoke(liquid)).booleanValue() && (fuelValue = (Integer)Compression_getFuelEnergy.invoke(liquid) * 20) > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Compression Dynamo fuel)");
                    }
                    if (((Boolean)Compression_isValidCoolant.invoke(liquid)).booleanValue() && (fuelValue = (Integer)Compression_getCoolantEnergy.invoke(liquid) * 20) > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Compression Dynamo coolant)");
                    }
                    return currenttip;
                }
            });
        }
        if (Reactant_getFuelEnergy != null && Reactant_getReactantEnergy != null && Reactant_isValidFuel != null) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("te.DynamoReactant", "Reactant Dynamo", null){

                @Override
                public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                    int fuelValue;
                    if (((Boolean)Reactant_isValidFuel.invoke(liquid)).booleanValue() && (fuelValue = (Integer)Reactant_getFuelEnergy.invoke(liquid) * 20) > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Reactant Dynamo fuel)");
                    }
                    return currenttip;
                }

                @Override
                public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                    int fuelValue = (Integer)Reactant_getReactantEnergy.invoke(stack);
                    if (fuelValue > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Reactant Dynamo reactant)");
                    }
                    return currenttip;
                }
            });
        }
        if (Steam_getEnergyValue != null) {
            FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("te.DynamoSteam", "Steam Dynamo", null){

                @Override
                public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                    int fuelValue = (Integer)Steam_getEnergyValue.invoke(stack);
                    if (fuelValue > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Steam Dynamo)");
                    }
                    return currenttip;
                }

                @Override
                public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                    int fuelValue;
                    if (liquid.getFluid() != null && liquid.getFluid().getName().equals("steam") && (fuelValue = liquid.amount * 2) > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Steam Dynamo)");
                    }
                    return currenttip;
                }
            });
        }
        if (Enervation_getEnergyValue != null) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("te.DynamoEnervation", "Enervation Dynamo", null){

                @Override
                public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                    int fuelValue = (Integer)Enervation_getEnergyValue.invoke(stack);
                    if (fuelValue > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Enervation Dynamo)");
                    }
                    return currenttip;
                }
            });
        }
        if (Magmatic_getFuelEnergy != null && Magmatic_isValidFuel != null) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("te.DynamoMagmatic", "Magmatic Dynamo", null){

                @Override
                public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                    if (!((Boolean)Magmatic_isValidFuel.invoke(liquid)).booleanValue()) {
                        return currenttip;
                    }
                    int fuelValue = (Integer)Magmatic_getFuelEnergy.invoke(liquid) * 20;
                    if (fuelValue > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Magmatic Dynamo)");
                    }
                    return currenttip;
                }
            });
        }
        HashMap<Class, String> map = new HashMap<Class, String>();
        cls = Utils.findClass("thermalexpansion.gui.client.dynamo.GuiDynamoCompression");
        if (cls != null) {
            map.put(cls, "te.DynamoCompression");
        }
        if ((cls = Utils.findClass("thermalexpansion.gui.client.dynamo.GuiDynamoMagmatic")) != null) {
            map.put(cls, "te.DynamoMagmatic");
        }
        if ((cls = Utils.findClass("thermalexpansion.gui.client.dynamo.GuiDynamoSteam")) != null) {
            map.put(cls, "te.DynamoSteam");
        }
        if ((cls = Utils.findClass("thermalexpansion.gui.client.dynamo.GuiDynamoEnervation")) != null) {
            map.put(cls, "te.DynamoEnervation");
        }
        if ((cls = Utils.findClass("thermalexpansion.gui.client.dynamo.GuiDynamoReactant")) != null) {
            map.put(cls, "te.DynamoReactant");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("te.DynamoAll", "Thermal Expansion", null, map));
        }
    }
}

