/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.railcraft;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import neiplugins.common.LiquidTemplateRecipeHandler;
import neiplugins.common.PositionedStackWithTooltip;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class RockCrusherRecipeHandler
extends LiquidTemplateRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
    public static Class<? extends GuiContainer> guiclass;

    public String getRecipeName() {
        return "Rock Crusher";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(59, 9, 176, 0, 29, 53, 48, 0);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(59, 9, 29, 53), "railcraft.crusher", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiclass;
    }

    @Override
    public String getRecipeId() {
        return "railcraft.crusher";
    }

    @Override
    public void loadSameRecipeId() {
        for (IRockCrusherRecipe irecipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
            this.arecipes.add(new CachedRockCrusherRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRockCrusherRecipe irecipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
            CachedRockCrusherRecipe recipe = new CachedRockCrusherRecipe(irecipe);
            if (!recipe.canProduce(result)) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRockCrusherRecipe irecipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getInput(), (ItemStack)ingredient) || irecipe.getOutputs().size() <= 0) continue;
            this.arecipes.add(new CachedRockCrusherRecipe(irecipe));
        }
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public String getGuiTexture() {
        return "railcraft:textures/gui/gui_crusher.png";
    }

    public class CachedRockCrusherRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList<PositionedStack> products;
        ArrayList<PositionedStack> resources;

        public CachedRockCrusherRecipe(IRockCrusherRecipe recipe) {
            super((TemplateRecipeHandler)RockCrusherRecipeHandler.this);
            this.resources = new ArrayList();
            this.resources.add(new PositionedStack((Object)recipe.getInput(), 3, 10));
            this.products = new ArrayList();
            this.setProducts(recipe.getOutputs());
        }

        public void setProducts(List<Map.Entry<ItemStack, Float>> iproducts) {
            int i = 0;
            for (Map.Entry<ItemStack, Float> product : iproducts) {
                if (i > 8) break;
                PositionedStackWithTooltip pStack = new PositionedStackWithTooltip(product.getKey(), 93 + stackorder[i][0] * 18, 10 + stackorder[i][1] * 18);
                pStack.setFloatChanceTooltip(product.getValue().floatValue());
                this.products.add(pStack);
                ++i;
            }
        }

        public List<PositionedStack> getOtherStacks() {
            return this.products;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RockCrusherRecipeHandler.this.cycleticks / 20, this.resources);
        }

        public boolean canProduce(ItemStack product) {
            for (PositionedStack pStack : this.products) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)pStack.item, (ItemStack)product)) continue;
                return true;
            }
            return false;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

