/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.railcraft;

import java.util.HashMap;
import java.util.List;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import neiplugins.common.FuelTooltip;
import neiplugins.common.SimpleFuelContextHelper;
import neiplugins.common.SimpleFuelHelper;
import neiplugins.common.Utils;
import neiplugins.railcraft.BoilerFuelContextHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RailcraftFuelHelper {
    public static Class guiCartBore;
    public static Class guiEngineSteamHobby;
    public static Class guiLocomotiveSteam;
    public static int steamTurbineIC2Output;
    public static int steamTurbineSteamUsage;
    public static int steamTurbineBCOutput;

    public static int getFuelValue(ItemStack stack) {
        int fuelValue = 0;
        try {
            fuelValue = FuelPlugin.getBurnTime((ItemStack)stack);
        }
        catch (Exception ex) {
            return 0;
        }
        return fuelValue;
    }

    public static void registerFuelHelpers() {
        guiCartBore = Utils.findClass("mods.railcraft.client.gui.GuiCartBore");
        guiEngineSteamHobby = Utils.findClass("mods.railcraft.client.gui.GuiEngineSteamHobby");
        guiLocomotiveSteam = Utils.findClass("mods.railcraft.client.gui.GuiLocomotiveSteam");
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("railcraft.enginesteamhobby", "Hobbyist's Steam Engine", null){

            @Override
            public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                int fuelValue = RailcraftFuelHelper.getFuelValue(stack);
                if (fuelValue > 0) {
                    currenttip.add("\u00a77" + FuelTooltip.convertMJtF(1.6f) + " MJ/t up to " + fuelValue / 8 * 20 + " ticks (Hobbyist's Steam Engine)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("railcraft.locomotivesteam", "Steam Locomotive", null){

            @Override
            public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                int fuelValue = RailcraftFuelHelper.getFuelValue(stack);
                if (fuelValue > 0) {
                    currenttip.add("\u00a7780 Steam/t up to " + Math.round((double)fuelValue / 6.4) * 2L + " ticks (Steam Locomotive)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("railcraft.tunnelbore", "Tunnel Bore", null){

            @Override
            public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                int fuelValue = RailcraftFuelHelper.getFuelValue(stack);
                if (fuelValue > 0) {
                    currenttip.add("\u00a77Heat to work for " + fuelValue / 12 + " ticks (Tunnel Bore)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("railcraft.solidfirebox", "Solid Fueled Firebox", null){

            @Override
            public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                int boilerFuelValue = RailcraftFuelHelper.getFuelValue(stack);
                if (boilerFuelValue > 0) {
                    currenttip.add("\u00a77" + FuelTooltip.convertHeatValue(boilerFuelValue, 1) + " (Solid Fueled Firebox)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("railcraft.liquidfirebox", "Liquid Fueled Firebox", null){

            @Override
            public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                FluidStack tempLiquid = liquid.copy();
                tempLiquid.amount = 1000;
                int boilerFuelValue = FuelManager.getBoilerFuelValue((Fluid)tempLiquid.getFluid());
                if (boilerFuelValue > 0) {
                    currenttip.add("\u00a77" + FuelTooltip.convertHeatValue(boilerFuelValue * liquid.amount / 1000, 1) + " (Liquid Fueled Firebox)");
                }
                return currenttip;
            }
        });
        Class tileSteamTurbine = Utils.findClass("mods.railcraft.common.blocks.machine.alpha.TileSteamTurbine");
        if (tileSteamTurbine != null) {
            steamTurbineIC2Output = Utils.getFieldInt(tileSteamTurbine, "IC2_OUTPUT", null);
            steamTurbineBCOutput = Utils.getFieldInt(tileSteamTurbine, "BC_OUTPUT", null);
            steamTurbineSteamUsage = Utils.getFieldInt(tileSteamTurbine, "STEAM_USAGE", null);
        }
        if ((steamTurbineIC2Output > 0 || steamTurbineBCOutput > 0) && steamTurbineSteamUsage > 0) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("railcraft.steam", "Steam Turbine", null){

                @Override
                public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                    if (liquid.getFluid() == FluidRegistry.getFluid((String)"steam")) {
                        if (steamTurbineBCOutput > 0) {
                            currenttip.add("\u00a77" + FuelTooltip.compactValue(liquid.amount * steamTurbineBCOutput / steamTurbineSteamUsage) + " MJ (Steam Engines)");
                        }
                        if (steamTurbineIC2Output > 0) {
                            currenttip.add("\u00a77" + FuelTooltip.compactValue(liquid.amount * steamTurbineIC2Output / steamTurbineSteamUsage) + " EU (Steam Turbine)");
                        }
                    }
                    return currenttip;
                }
            });
        }
        Class liquidGui = Utils.findClass("mods.railcraft.client.gui.GuiBoilerLiquid");
        Class solidGui = Utils.findClass("mods.railcraft.client.gui.GuiBoilerSolid");
        if (liquidGui != null && solidGui != null) {
            FuelTooltip.addContextFuelHelper(new BoilerFuelContextHelper(solidGui, liquidGui));
        }
        HashMap<Class, String> map = new HashMap<Class, String>();
        if (guiEngineSteamHobby != null) {
            map.put(guiEngineSteamHobby, "railcraft.enginesteamhobby");
        }
        if (guiLocomotiveSteam != null) {
            map.put(guiLocomotiveSteam, "railcraft.locomotivesteam");
        }
        if (guiCartBore != null) {
            map.put(guiCartBore, "railcraft.tunnelbore");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("railcraft.all", "Railcraft", null, map));
        }
    }

    static {
        steamTurbineIC2Output = 0;
        steamTurbineSteamUsage = 0;
        steamTurbineBCOutput = 0;
    }
}

