/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.options;

import codechicken.nei.config.OptionButton;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;

public class OptionRecipeHandlerControl
extends OptionButton {
    private Class cls;
    private ICraftingHandler craftingHandler;
    private IUsageHandler usageHandler;

    public OptionRecipeHandlerControl(String name, Class cls) {
        super(name);
        this.cls = cls;
        this.craftingHandler = null;
        this.usageHandler = null;
    }

    public boolean onClick(int button) {
        if (!this.init()) {
            return false;
        }
        if (this.isEnabled()) {
            if (this.craftingHandler != null && GuiCraftingRecipe.craftinghandlers.contains(this.craftingHandler)) {
                GuiCraftingRecipe.craftinghandlers.remove(this.craftingHandler);
            }
            if (this.usageHandler != null && GuiUsageRecipe.usagehandlers.contains(this.usageHandler)) {
                GuiUsageRecipe.usagehandlers.remove(this.usageHandler);
            }
        } else {
            if (this.craftingHandler != null && !GuiCraftingRecipe.craftinghandlers.contains(this.craftingHandler)) {
                GuiCraftingRecipe.craftinghandlers.add(this.craftingHandler);
            }
            if (this.usageHandler != null && !GuiUsageRecipe.usagehandlers.contains(this.usageHandler)) {
                GuiUsageRecipe.usagehandlers.add(this.usageHandler);
            }
        }
        this.setEnabled(!this.isEnabled());
        return true;
    }

    public boolean init() {
        if (this.craftingHandler != null || this.usageHandler != null) {
            return true;
        }
        for (ICraftingHandler handler : GuiCraftingRecipe.craftinghandlers) {
            if (handler.getClass() != this.cls) continue;
            this.craftingHandler = handler;
        }
        for (ICraftingHandler handler : GuiUsageRecipe.usagehandlers) {
            if (handler.getClass() != this.cls) continue;
            this.usageHandler = handler;
        }
        return this.craftingHandler != null || this.usageHandler != null;
    }
}

