/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.openblocks;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import openblocks.OpenBlocks;

public class PaintMixerRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Paint Mixer";
    }

    public String getRecipeId() {
        return "openblocks.paintmixer";
    }

    public String getGuiTexture() {
        return "neiplugins:gfx/Item2Item.png";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    public void drawExtras(int recipe) {
        GuiDraw.drawString((String)"Dye usage varies", (int)50, (int)70, (int)0x808080, (boolean)false);
        GuiDraw.drawString((String)"per paint color", (int)50, (int)80, (int)0x808080, (boolean)false);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            this.showTutorial();
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() == Item.func_150898_a((Block)OpenBlocks.Blocks.paintCan)) {
            this.showTutorial(result);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() == Items.field_151117_aB) {
            this.showTutorial();
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)ingredient)) {
            if (id == OreDictionary.getOreID((String)"dyeCyan")) {
                this.showTutorial(null, ingredient, null, null, null);
                return;
            }
            if (id == OreDictionary.getOreID((String)"dyeYellow")) {
                this.showTutorial(null, null, ingredient, null, null);
                return;
            }
            if (id == OreDictionary.getOreID((String)"dyeMagenta")) {
                this.showTutorial(null, null, null, ingredient, null);
                return;
            }
            if (id != OreDictionary.getOreID((String)"dyeBlack")) continue;
            this.showTutorial(null, null, null, null, ingredient);
            return;
        }
    }

    public void showTutorial() {
        this.arecipes.add(new CachedPaintMixerRecipe(null));
    }

    public void showTutorial(ItemStack paint) {
        this.arecipes.add(new CachedPaintMixerRecipe(paint));
    }

    public void showTutorial(ItemStack paint, ItemStack cyan, ItemStack yellow, ItemStack magenta, ItemStack black) {
        this.arecipes.add(new CachedPaintMixerRecipe(paint, cyan, yellow, magenta, black));
    }

    public class CachedPaintMixerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack milk;
        public List<ItemStack> cyan;
        public List<ItemStack> yellow;
        public List<ItemStack> magenta;
        public List<ItemStack> black;
        public PositionedStack paint;
        public ItemStack randomPaint;
        public int randomPaintHue;
        public List<PositionedStack> otherStacks;

        public CachedPaintMixerRecipe(ItemStack paint) {
            super((TemplateRecipeHandler)PaintMixerRecipeHandler.this);
            this.randomPaintHue = new Random().nextInt(360);
            this.paint = paint != null ? new PositionedStack((Object)paint, 111, 24) : null;
            this.milk = new PositionedStack((Object)new ItemStack(Items.field_151117_aB), 51, 24);
            this.cyan = OreDictionary.getOres((String)"dyeCyan");
            this.yellow = OreDictionary.getOres((String)"dyeYellow");
            this.magenta = OreDictionary.getOres((String)"dyeMagenta");
            this.black = OreDictionary.getOres((String)"dyeBlack");
        }

        public CachedPaintMixerRecipe(ItemStack paint, ItemStack cyan, ItemStack yellow, ItemStack magenta, ItemStack black) {
            this(paint);
            if (cyan != null) {
                this.cyan = new ArrayList<ItemStack>();
                this.cyan.add(cyan);
            }
            if (yellow != null) {
                this.yellow = new ArrayList<ItemStack>();
                this.yellow.add(yellow);
            }
            if (magenta != null) {
                this.magenta = new ArrayList<ItemStack>();
                this.magenta.add(magenta);
            }
            if (black != null) {
                this.black = new ArrayList<ItemStack>();
                this.black.add(black);
            }
        }

        public PositionedStack getIngredient() {
            return this.milk;
        }

        public List<PositionedStack> getOtherStacks() {
            if (PaintMixerRecipeHandler.this.cycleticks % 20 == 0 || this.otherStacks == null) {
                this.otherStacks = new ArrayList<PositionedStack>();
                this.otherStacks.add(new PositionedStack((Object)this.getRandomStack(this.cyan), 51, 50));
                this.otherStacks.add(new PositionedStack((Object)this.getRandomStack(this.yellow), 71, 50));
                this.otherStacks.add(new PositionedStack((Object)this.getRandomStack(this.magenta), 91, 50));
                this.otherStacks.add(new PositionedStack((Object)this.getRandomStack(this.black), 111, 50));
            }
            return this.getCycledIngredients(PaintMixerRecipeHandler.this.cycleticks / 20, this.otherStacks);
        }

        public PositionedStack getResult() {
            if (this.paint != null) {
                return this.paint;
            }
            if (this.randomPaint == null) {
                this.randomPaint = new ItemStack((Block)OpenBlocks.Blocks.paintCan);
                this.randomPaint.field_77990_d = new NBTTagCompound();
                this.randomPaint.field_77990_d.func_74768_a("amount", Integer.MAX_VALUE);
            }
            Color nextColor = new Color(Color.HSBtoRGB((float)this.randomPaintHue / 360.0f, 1.0f, 1.0f));
            this.randomPaint.field_77990_d.func_74768_a("color", nextColor.getRed() << 16 | nextColor.getGreen() << 8 | nextColor.getBlue());
            this.randomPaintHue = this.randomPaintHue >= 360 ? 0 : this.randomPaintHue + 1;
            return new PositionedStack((Object)this.randomPaint, 111, 24);
        }

        public ItemStack getRandomStack(List<ItemStack> stacks) {
            if (stacks.size() > 0) {
                return stacks.get(new Random().nextInt(stacks.size()));
            }
            return null;
        }
    }
}

