/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.minefactoryreloaded;

import java.util.List;
import neiplugins.common.FuelTooltip;
import neiplugins.common.SimpleFuelHelper;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.setup.Machine;

public class MFRFuelHelper {
    public static void registerFuelHelpers() {
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("mfr.GenBioFuel", "BioFuel Generator", null){

            @Override
            public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                int fuelValue;
                if (liquid.getFluid() != null && (liquid.getFluid().getName().equals("biofuel") || liquid.getFluid().getName().equals("bioethanol")) && (fuelValue = liquid.amount / 1 * 5 * Machine.BioFuelGenerator.getActivationEnergy()) > 0) {
                    currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (BioFuel Generator)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("mfr.GenSteamTurbine", "MFR Steam Turbine", null){

            @Override
            public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                int fuelValue;
                if (liquid.getFluid() != null && liquid.getFluid().getName().equals("steam") && (fuelValue = liquid.amount * 2) > 0) {
                    currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (MFR Steam Turbine)");
                }
                return currenttip;
            }
        });
    }
}

