/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.minefactoryreloaded;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import cofh.lib.util.WeightedRandomItemStack;
import java.awt.Dimension;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import neiplugins.common.Utils;
import neiplugins.forge.GuiGameChestLootList;
import neiplugins.lists.GuiList;
import neiplugins.lists.IListElement;
import neiplugins.lists.MultipleStackListElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.WeightedRandom;

public class GuiSludgeBoilerDropsList
extends GuiList {
    public static DecimalFormat chanceFormat = new DecimalFormat("0.##%");

    protected GuiSludgeBoilerDropsList(GuiContainer prevgui, String title, ArrayList<? extends IListElement> list) {
        super(prevgui, title, list);
    }

    public static List<WeightedRandomItemStack> getSludgeDrops() {
        Class cls = Utils.findClass("powercrystals.minefactoryreloaded.MFRRegistry");
        if (cls != null) {
            return (List)Utils.getField(cls, "_sludgeDrops", null);
        }
        return null;
    }

    @Override
    protected void drawBackground(int index, boolean empty, boolean hovered) {
    }

    public static boolean showList(String title) {
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        List<WeightedRandomItemStack> sludgeDrops = GuiSludgeBoilerDropsList.getSludgeDrops();
        if (sludgeDrops == null || sludgeDrops.size() == 0) {
            return false;
        }
        int totalWeight = WeightedRandom.func_76272_a(sludgeDrops);
        Iterator<WeightedRandomItemStack> stacks = sludgeDrops.iterator();
        ArrayList<SludgeDropListElement> list = new ArrayList<SludgeDropListElement>();
        Dimension eSize = new Dimension(140, 16);
        while (stacks.hasNext()) {
            list.add(new SludgeDropListElement(stacks, 4, eSize, totalWeight));
        }
        if (list.isEmpty()) {
            return false;
        }
        mc.func_147108_a((GuiScreen)new GuiSludgeBoilerDropsList(prevscreen, title, list));
        return true;
    }

    static class SludgeDropListElement
    extends MultipleStackListElement {
        public ArrayList<WeightedRandomItemStack> items;
        public int totalWeight;

        public SludgeDropListElement(Iterator<WeightedRandomItemStack> drops, int margin, Dimension size, int totalWeight) {
            this.margin = margin;
            this.stacks = new ArrayList();
            this.items = new ArrayList();
            this.totalWeight = totalWeight;
            int pos = 1;
            while (pos + 16 < size.width && drops.hasNext()) {
                WeightedRandomItemStack i = drops.next();
                if (i.getStack() == null || !Utils.isSafeItemStack(i.getStack())) continue;
                this.stacks.add(new PositionedStack((Object)i.getStack(), pos, 1));
                this.items.add(i);
                pos += 16 + margin;
            }
        }

        @Override
        protected List<String> handleItemTooltip(GuiList gui, int index, List<String> currenttip, Point mousePos) {
            WeightedRandomItemStack i = this.items.get(index);
            currenttip.add("Chance: " + GuiGameChestLootList.chanceFormat.format(1.0f * (float)i.field_76292_a / (float)this.totalWeight));
            return currenttip;
        }
    }
}

