/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.minefactoryreloaded;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import cofh.lib.util.WeightedRandomItemStack;
import java.awt.Dimension;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import neiplugins.common.Colors;
import neiplugins.common.Utils;
import neiplugins.forge.GuiGameChestLootList;
import neiplugins.lists.GuiList;
import neiplugins.lists.IListElement;
import neiplugins.lists.MultipleStackListElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class GuiLaserDrillDropsList
extends GuiList {
    public static DecimalFormat chanceFormat = new DecimalFormat("0.##%");

    protected GuiLaserDrillDropsList(GuiContainer prevgui, String title, ArrayList<? extends IListElement> list) {
        super(prevgui, title, list);
    }

    @Override
    public int getElementsOffset() {
        return 20;
    }

    @Override
    public int getElementHeight() {
        return 16;
    }

    public static List<WeightedRandomItemStack> getLaserOres() {
        Class cls = Utils.findClass("powercrystals.minefactoryreloaded.MFRRegistry");
        if (cls != null) {
            return (List)Utils.getField(cls, "_laserOres", null);
        }
        return null;
    }

    public static Map<Integer, List<ItemStack>> getLaserPreferredOres() {
        Class cls = Utils.findClass("powercrystals.minefactoryreloaded.MFRRegistry");
        if (cls != null) {
            return (Map)Utils.getField(cls, "_laserPreferredOres", null);
        }
        return null;
    }

    @Override
    protected void drawBackground(int index, boolean empty, boolean hovered) {
    }

    public static boolean showList(String title) {
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        List<WeightedRandomItemStack> laserOres = GuiLaserDrillDropsList.getLaserOres();
        Map<Integer, List<ItemStack>> laserPreferredOres = GuiLaserDrillDropsList.getLaserPreferredOres();
        if (laserOres == null || laserOres.size() == 0 || laserPreferredOres == null) {
            return false;
        }
        int totalWeight = WeightedRandom.func_76272_a(laserOres);
        Iterator<WeightedRandomItemStack> stacks = laserOres.iterator();
        ArrayList<LaserOreListElement> list = new ArrayList<LaserOreListElement>();
        Dimension eSize = new Dimension(140, 16);
        while (stacks.hasNext()) {
            list.add(new LaserOreListElement(stacks, laserPreferredOres, 4, eSize, totalWeight));
        }
        if (list.isEmpty()) {
            return false;
        }
        mc.func_147108_a((GuiScreen)new GuiLaserDrillDropsList(prevscreen, title, list));
        return true;
    }

    static class LaserOreListElement
    extends MultipleStackListElement {
        public ArrayList<WeightedRandomItemStack> items;
        public Map<Integer, List<ItemStack>> preferredOres;
        public int totalWeight;

        public LaserOreListElement(Iterator<WeightedRandomItemStack> ores, Map<Integer, List<ItemStack>> preferredOres, int margin, Dimension size, int totalWeight) {
            this.preferredOres = preferredOres;
            this.margin = margin;
            this.stacks = new ArrayList();
            this.items = new ArrayList();
            this.totalWeight = totalWeight;
            int pos = 1;
            while (pos + 16 < size.width && ores.hasNext()) {
                WeightedRandomItemStack i = ores.next();
                if (i.getStack() == null || !Utils.isSafeItemStack(i.getStack())) continue;
                this.stacks.add(new PositionedStack((Object)i.getStack(), pos, 1));
                this.items.add(i);
                pos += 16 + margin;
            }
        }

        @Override
        protected List<String> handleItemTooltip(GuiList gui, int index, List<String> currenttip, Point mousePos) {
            WeightedRandomItemStack i = this.items.get(index);
            currenttip.add("Chance: " + GuiGameChestLootList.chanceFormat.format(1.0f * (float)i.field_76292_a / (float)this.totalWeight));
            ArrayList<String> foci = new ArrayList<String>();
            block0: for (Integer key : this.preferredOres.keySet()) {
                List<ItemStack> value = this.preferredOres.get(key);
                for (ItemStack stack : value) {
                    if (!Utils.areStacksSameTypeCrafting(i.getStack(), stack)) continue;
                    foci.add(" " + Colors.getColoredBlockColorName(key));
                    continue block0;
                }
            }
            if (foci.size() > 0) {
                currenttip.add("Foci:");
                currenttip.addAll(foci);
            }
            return currenttip;
        }
    }
}

