/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.mekanism;

import java.util.HashMap;
import java.util.List;
import neiplugins.common.FuelTooltip;
import neiplugins.common.SimpleFuelContextHelper;
import neiplugins.common.SimpleFuelHelper;
import neiplugins.common.Utils;
import net.minecraft.item.ItemStack;

public class MekanismFuelHelper {
    private static final String[] energyTypes = new String[]{" J ", " RF ", " EU ", " MJ "};
    private static int energyType;
    private static double toMJ;
    private static double toEU;
    private static double toRF;
    private static double heatGeneration;
    private static double bioGeneration;
    private static Utils.MethodInvoker Heat_getFuel;
    private static Utils.MethodInvoker Bio_getFuel;

    public static void registerFuelHelpers() {
        Class cls = Utils.findClass("mekanism.common.Mekanism");
        if (cls != null) {
            energyType = ((Enum)Utils.getField(cls, "activeType", null)).ordinal();
            toMJ = (Double)Utils.getField(cls, "TO_BC", null);
            toEU = (Double)Utils.getField(cls, "TO_IC2", null);
            toRF = toMJ * 10.0;
        }
        if ((cls = Utils.findClass("mekanism.generators.common.MekanismGenerators")) != null) {
            heatGeneration = (Double)Utils.getField(cls, "heatGeneration", null);
            bioGeneration = (Double)Utils.getField(cls, "bioGeneration", null);
        }
        if ((cls = Utils.findClass("mekanism.generators.common.tile.TileEntityHeatGenerator")) != null) {
            try {
                Heat_getFuel = Utils.getMethodInvoker(cls, "getFuel", cls.newInstance(), ItemStack.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((cls = Utils.findClass("mekanism.generators.common.tile.TileEntityBioGenerator")) != null) {
            try {
                Bio_getFuel = Utils.getMethodInvoker(cls, "getFuel", cls.newInstance(), ItemStack.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (Heat_getFuel != null && heatGeneration > 0.0) {
            FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("mekanism.GenHeat", "Heat Generator", null){

                @Override
                public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                    Object[] objectArray = new Object[]{stack};
                    double fuelValue = MekanismFuelHelper.convertFuelValue((double)((Integer)Heat_getFuel.invoke(objectArray)).intValue() * heatGeneration / 10.0, energyType);
                    if (fuelValue > 0.0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValueD(fuelValue) + energyTypes[energyType] + "(Heat Generator)");
                    }
                    return currenttip;
                }
            });
        }
        if (Bio_getFuel != null && bioGeneration > 0.0) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("mekanism.GenBio", "Bio-Generator", null){

                @Override
                public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                    Object[] objectArray = new Object[]{stack};
                    double fuelValue = MekanismFuelHelper.convertFuelValue((double)((Integer)Bio_getFuel.invoke(objectArray)).intValue() * bioGeneration, energyType);
                    if (fuelValue > 0.0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValueD(fuelValue) + energyTypes[energyType] + "(Bio-Generator)");
                    }
                    return currenttip;
                }
            });
        }
        HashMap<Class, String> map = new HashMap<Class, String>();
        cls = Utils.findClass("mekanism.generators.client.gui.GuiHeatGenerator");
        if (cls != null) {
            map.put(cls, "mekanism.GenHeat");
        }
        if ((cls = Utils.findClass("mekanism.generators.client.gui.GuiBioGenerator")) != null) {
            map.put(cls, "mekanism.GenBio");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("mekanism.GenAll", "Mekanism", null, map));
        }
    }

    private static double convertFuelValue(double fuelValue, int energyType) {
        switch (energyType) {
            case 0: {
                return fuelValue;
            }
            case 1: {
                return fuelValue * toRF;
            }
            case 2: {
                return fuelValue * toEU;
            }
            case 3: {
                return fuelValue * toMJ;
            }
        }
        return 0.0;
    }
}

